Ext.define('Academia.view.dashboard.dashlets.EnquiryFollowupDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.enquiryfollowupdashlet',

	graphView:true,
	layout:'card',
	activeItem: 0, 
	autoScroll:false,
	cls:'EnquiryFollowUpDashletCLS dashlet horizontalScrollingFixed',
	loadDashlet :function(){ 
		var this$=this;
		var view= this$.layout.getActiveItem();
		var dates;
		var toolbar; 
		if(this.up('dashboardhomepage') == undefined){
			dates={
					startDate:Ext.ComponentQuery.query('extendeddatefilter[itemId=dateRangePicker]')[0].startDate,
					endDate:Ext.ComponentQuery.query('extendeddatefilter[itemId=dateRangePicker]')[0].endDate
			};
			var tempStartDate=new Date(dates.startDate);
			var tempEndDate=new Date(dates.endDate);
			dates.startDate=tempStartDate.getFullYear()+'-'+(tempStartDate.getMonth()+1)+'-'+tempStartDate.getDate();
			dates.endDate=tempEndDate.getFullYear()+'-'+(tempEndDate.getMonth()+1)+'-'+tempEndDate.getDate();
		}else{
			try{
				toolbar = this$.up('dashboardhomepage').down('toolbar');
				//dates=toolbar.down('#dateRangePicker').getValues();
				dates={
						startDate:toolbar.down('#dateRangePicker').startDate,
						endDate:toolbar.down('#dateRangePicker').endDate
				};
				//dates.startDate = Ext.Date.format(dates.startDate,CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
				//dates.endDate=Ext.Date.format(dates.endDate,CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
				var tempStartDate=new Date(dates.startDate);
				var tempEndDate=new Date(dates.endDate);
				dates.startDate=tempStartDate.getFullYear()+'-'+(tempStartDate.getMonth()+1)+'-'+tempStartDate.getDate();
				dates.endDate=tempEndDate.getFullYear()+'-'+(tempEndDate.getMonth()+1)+'-'+tempEndDate.getDate();
			}
			catch(e){
				dates={
						startDate:null,
						endDate:null
				};
			}
		}
		if(view.xtype=='griddashlet' || view.xtype=='columnchartdashlet'){
			var store= view.getStore();
			var extraparams=this$.getParams();
			store.getProxy().extraParams = {
				startDate:dates.startDate,
				endDate:dates.endDate
			};
			store.load({params:extraparams,
				callback: function(rec, operation, success) {
					if(rec == undefined){
						this$.layout.setActiveItem(0);
					}
				}
			});
		}else{
			if(view.xtype=='image'){
				this.layout.setActiveItem(0);
				var view1=this.layout.getActiveItem();
				var store= view1.getStore();
				var extraparams=this$.getParams();
				store.load({params:extraparams,
					callback: function(rec, operation, success) {
						if(rec == undefined){
							this$.layout.setActiveItem(0);
						}
					}
				});
			}
		}
	},
	defaults: {
		cls:'panelNoSpace',
	},

	items:[{
		xtype: 'panel',
		width: '100%',
		height: '100%',
		//src: CONSTANTS.NO_DATA_DISPALY_DASHBORD_IMAGE_SRC,//'resources/images/no_data_to_display.png',
		html: '<div><div class ="dashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
		listeners:{
			activate:function(portlet){
				var enquiryfollowupdashlet=portlet.up('enquiryfollowupdashlet');
				enquiryfollowupdashlet.activeTab =0;
				enquiryfollowupdashlet.addGraphViewButton(enquiryfollowupdashlet);
				enquiryfollowupdashlet.addExportToPdf(enquiryfollowupdashlet,portlet);
				enquiryfollowupdashlet.addExportToExcel(enquiryfollowupdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquiryfollowupdashlet=portlet.up('enquiryfollowupdashlet');
				enquiryfollowupdashlet.removeGraphViewButton(enquiryfollowupdashlet);
				enquiryfollowupdashlet.removeExportToPdf();
				enquiryfollowupdashlet.removeExportToExcel();
			}
		}
	},{
		xtype:'griddashlet',
		model:'Academia.model.enquiry.EnquiryFollowupDashletModel',
		url : SERVERURL.ENQUIRY_FOLLOWUP_DASHLET,
		addPagingToolbar : true,
		columns : [/*{
			text : getEnquiryTranslation('ENQUIRY_NO'),
    		hidden: true,
    		dataIndex: 'enqId'
    	},*/ {
    		text : getEnquiryTranslation('ENQUIRY_NO'),
    		dataIndex : 'enqCode',
    		sortable : true,
    		flex:0.1,
    		renderer:function(value,meta,record){
    			if(!isNullOrEmpty(record)) {
    				value="<a href='#'>"+record.get('enqCode')+"</a>"; 
    				return value;
    			}
    		}
    	}, {
    		text : getEnquiryTranslation('TRACK_ENQUIRER_NAME'),
    		dataIndex : 'EnquirerName',
    		sortable : true,
    		flex:0.1
    	}/*,{
    		text : getEnquiryTranslation('ENQUIRER_MIDDLE_NAME'),
    		dataIndex : 'EnquirerMiddleName',
    		sortable : false,
    		flex:0.1
    	},{
    		text : getEnquiryTranslation('ENQUIRER_LAST_NAME'),
    		dataIndex : 'EnquirerLastName',
    		sortable : false,
    		flex:0.1
    	}*/, {
    		text : getEnquiryTranslation('ACADEMYLOCATION'),
    		dataIndex : 'EnquiryAcademyLocation',
    		sortable : true,
    		flex:0.1
    	}, {
    		text : getEnquiryTranslation('ENQUIRY_DATE'),
    		dataIndex : 'EnquiryDate',
    		sortable : true,
    		flex:0.1,
    		renderer : function(date) {
    			return dateRender(date);
    		}
    	}, {
    		text : getEnquiryTranslation('FOLLOW_UP_DATE'),
    		dataIndex : 'FollowUpDate',
    		sortable : true,
    		flex:0.1,
    		renderer : function(date) {
    			return dateRender(date);
    		}
    	}],
    	listeners:{
    		activate:function(portlet){
    			var enquiryfollowupdashlet=portlet.up('enquiryfollowupdashlet');
    			enquiryfollowupdashlet.activeTab =1;
//  			enquiryfollowupdashlet.addExportToPdf(enquiryfollowupdashlet);
    			enquiryfollowupdashlet.addGraphViewButton(enquiryfollowupdashlet);
    			enquiryfollowupdashlet.addExportToPdf(enquiryfollowupdashlet,portlet);
    			enquiryfollowupdashlet.addExportToExcel(enquiryfollowupdashlet,portlet);
//  			portlet.doLayout();
    		},
    		deactivate:function(portlet){
    			var enquiryfollowupdashlet=portlet.up('enquiryfollowupdashlet');
    			enquiryfollowupdashlet.removeGraphViewButton(enquiryfollowupdashlet);
    			enquiryfollowupdashlet.removeExportToPdf();
    			enquiryfollowupdashlet.removeExportToExcel();
    		},
    		cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    			var $this=this;
    			if(e.target.tagName == 'A'){
    				var enquiryFollowGrid = cell.up('grid');
    				var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
    				var trackEnquiryController =  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
    				trackEnquiryController.openEnquiryFromDashlet(0,0,enquiryFollowGrid,'Edit');
    			}
    			if(this.up('dashboardhomepage') == undefined){
    				enquiryFollowGrid.up().up().up().close();
    			}
    		}
    	}
	},{
		xtype:'columnchartdashlet',
		xAxesCategoryField :['date'],
		yAxesNumericField : ['count'],
		xAxesCategoryTitle :getEnquiryTranslation('DATE'),
		yAxesNumericTitle :getEnquiryTranslation('COUNTS'),
		model:'Academia.model.enquiry.EnquiryFollowupDashletGraphModel',
		url : SERVERURL.ENQUIRY_FOLLOWUP_DASHLET_GRAPH,
		listeners:{
			activate:function(portlet){
				var enquiryfollowupdashlet=portlet.up('enquiryfollowupdashlet');
				enquiryfollowupdashlet.activeTab = 0;
				enquiryfollowupdashlet.addGridViewButton(enquiryfollowupdashlet);
				enquiryfollowupdashlet.addExportToPng(enquiryfollowupdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquiryfollowupdashlet=portlet.up('enquiryfollowupdashlet');
				enquiryfollowupdashlet.removeGridViewButton(enquiryfollowupdashlet);
				enquiryfollowupdashlet.removeExportToPng();
			}
		}
	}]
});