/**
 * @author Amit G
 */

Ext.define('Academia.view.dashboard.dashlets.GrayQuestApplicationStudentDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.grayquestapplicationstudentdashlet',
    graphView:true,
    layout:'card',
    cls:'StudentPersonalDashletCLS dashlet',
    activeItem: 0, 
    loadDashlet :function(){
    	var this$=this;
    	var userInfo = Academia.model.authentication.UserInfoModel;
    	var portal =  userInfo.get('portalId');
 		var userID =  userInfo.get('userId');
    },
	defaults: {
		cls: 'horizontalScrollingFixed',
    },
    items: [{
    	xtype:'panel',
    	layout:'vbox',
    	id:'GrayQuestApplication',
    	style:{marginTop:'20px',marginLeft:'20px', marginBottom:'15px',fontWeight:'bold'},
    	defaults: {
    		labelAlign: 'top',
    		width:800
    	},
    	items: [{
    		xtype:'displayfield',
    		itemId:'outStandingAmountMGS',
    		labelWidth: 250,
    		labelAlign: 'left',
    		style:{'margin-top':'-5px !important'},
    		cls:'amountBoldCLS',
    		name:'outStandingAmountMGS',
    		fieldLabel: getCommonTranslation('YOUR_OUTSTANDING_AMOUNT_IS'),
    		labelStyle: 'font-weight:bold;'
    	},{
    		xtype:'displayfield',
    		itemId:'applyToGrayQuestMGS',
    		labelSeparator:'',
    		fieldLabel: getCommonTranslation('PLEASE_CLICK_ON_APPLYTO_GRAYQUEST'),
    		labelStyle: 'font-weight:bold;'
    	}]
    },{  xtype: 'panel',
	 	itemId:'noRecordFoundImagePanelItemId', 
	 	autoScroll: false,
	 	html: '<div><div class ="dashletParentNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>', 
	 	style:{ 'overflow': 'hidden !important;' }
    }],
    tbar: {
        cls: 'studentlookupdashbordTbarheaderGrayQuest',
        items: [{
			xtype: 'textfield',
			name: 'outstandingAmount',
			itemId:'outstandingAmount',
			width:'40%',
			style:{marginLeft:'10px'},
            valueField: 'id',
			displayField: 'value',
            editable : false,
            readOnly:true,
            emptyText: 'Outstanding Amount',
        },{
			xtype: 'panel',
			//width: '30.5%',
			itemId:'applyGQButton',
			html: '<button id="gq-button" class="gq-button">'+getCommonTranslation('APPLY_TO_GRAYQUEST')+'</button>',
			listeners:{
				afterrender: function(pnl){
					var grayquestapplicationstudentdashlet = pnl.up('grayquestapplicationstudentdashlet');
					var stRecord = grayquestapplicationstudentdashlet.parentStudentDetails;
					if(isNullOrEmpty(stRecord.feeAmount) || stRecord.feeAmount == '0'){
						Ext.ComponentQuery.query('#applyGQButton')[0].setDisabled(true);
					}
					document.getElementById("gq-button").onclick=function(e) {
						if(parseFloat(stRecord.feeAmount) < 10000.00){
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('OUTSTANDING_AMOUNT_SHOULD_BE_GREATER_THEN_10000'));
							return false;
						}else{
							GqErpSDK.setOptions({env:stRecord.env,auth: {
								client_id:stRecord.clientId,
								client_secret_key:stRecord.clientSecretKey,
								gq_api_key:stRecord.gqAPIKey,},
								student_id:stRecord.studentID,
								customer_mobile:stRecord.customerMobileNumber,
								fee_editable:true,
								fee_amount:stRecord.feeAmount,
								payable_amount:stRecord.feeAmount,
								student_details: {
									student_first_name:stRecord.studentFirstName,
									student_middle_name:stRecord.studentMiddleName,
									student_last_name: stRecord.studentLastName,
									student_type:stRecord.studentType
									},
									customer_details: {
										customer_first_name:stRecord.customerFirstName,
										customer_middle_name:stRecord.customerMiddleName,
										customer_last_name:stRecord.customerLastName,
										customer_dob:stRecord.customerDOB,
										customer_gender:stRecord.customerGender,
										customer_email:stRecord.customerEmail,
										customer_marital_status:stRecord.customerMaritalStatus,
									}
							});
			 				GqErpSDK.render();
						}
						
					
		 			}
				}
			}
        }]
    }
});

