/**
 * @author Deepak.Mathur
 */
Ext.define('Academia.view.dashboard.dashlets.HostelDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.hosteldashlet',
   // graphView:true,
    layout:'card',
    activeItem: 0, 
    autoScroll:false,
    cls:'HostelDashletCLS dashlet',
    loadDashlet :function(paramObj){
    	var this$=this;
    	var tab= this.layout.getActiveItem();
    	//var extraparams=this$.getParams();
    	/*if(isNullOrEmpty(btn)){
    		extraparams = {
    				endDate:null,
    				startDate:null
    		}
    	}*/
    	if(tab.xtype=='griddashlet'){
    		/*var store= tab.getStore();
    		store.load({
    			params:extraparams,
    			callback: function(rec, operation, success) {
    				if(rec.length==0){
    					this$.layout.setActiveItem(10);
    				}
    			}
    		});*/
    		
    		
    		var store= tab.getStore();
			var extraparams;
			userId = this$.getCurrentlyLoggedInDashletUser().id;
			academyLocationId = this$.getUserCurrentAcademyLocation();
			portalId=this$.getCurrentlyLoggedInDashletUser().portalId;
			if(paramObj !=undefined){
				extraparams=paramObj;
			}else{
				extraparams=this$.getParams();	
			}
			this$.resetPageSetting(store);
			var baseController = Academia.app.getController('base.BaseController');
			switch (tab.itemId) {
			case 'hostelBuildingId':
				store.getProxy().extraParams = {
					startDate:this$.getParams().startDate,
					endDate:this$.getParams().endDate					 
			};
				store.load({
					params:extraparams,
					scope:this$,
					callback: function(rec, operation, success) {

						if(rec.length==0){
							this$.layout.setActiveItem(0);
						}
						if (rec.length > 0) {							
							baseController.toggleGridSummaryRow(tab,true);
						}else{
							baseController.toggleGridSummaryRow(tab,false);
						}
					}
				});
				break;
			case 'hostelAcademyLocationId':
				store.getProxy().extraParams = {
					/*startDate:dates.startDate,
					endDate:dates.endDate,*/
					/*status:extraparams.status,
					acadmyLocationId:extraparams.acadmyLocationId,
					sourceEnqId:extraparams.sourceEnqId*/
			};
				store.load({
					params:extraparams,
					scope:this$,
					callback: function(rec, operation, success) {

						if(rec.length==0){
							this$.layout.setActiveItem(24);
						}
						if (rec.length > 0) {							
							baseController.toggleGridSummaryRow(tab,true);
						}else{
							baseController.toggleGridSummaryRow(tab,false);
						}
					}
				});
				break;
			case 'hostelProgramBatchId':
				var loggedInfacultyId = null;
				if(portalId == 2){
					loggedInfacultyId = userId;
				}
				store.getProxy().extraParams = {
					/*startDate:dates.startDate,
					endDate:dates.endDate,*/
					facultyId: loggedInfacultyId
			};
				store.load({
					params:extraparams,
					scope:this$,
					callback: function(rec, operation, success) {

						if(rec.length==0){
							this$.layout.setActiveItem(24);
						}
						if (rec.length > 0) {							
							baseController.toggleGridSummaryRow(tab,true);
						}else{
							baseController.toggleGridSummaryRow(tab,false);
						}
					}
				});
				break;
			case 'hostelRoomCountInfoId':
				store.getProxy().extraParams = {
					//startDate:this$.getParams().startDate,
					//endDate:this$.getParams().endDate,
					buildingResourceId:extraparams.buildingResourceId
			};
				store.load({
					params:extraparams,
					callback: function(rec, operation, success) {
						if(rec.length==0){
							this$.layout.setActiveItem(24);
						}
					}
				});
				break;
			case 'hostelBedCountInfoId':
				store.getProxy().extraParams = {
					startDate:this$.getParams().startDate,
					endDate:this$.getParams().endDate,
					buildingResourceId:extraparams.buildingResourceId,
			};
				store.load({
					params:extraparams,
					callback: function(rec, operation, success) {
						if(rec.length==0){
							this$.layout.setActiveItem(24);
						}
					}
				});
				break;
			case 'hostelOccupiedBedsInfoId':
				store.getProxy().extraParams = {
					startDate:this$.getParams().startDate,
					endDate:this$.getParams().endDate,
					buildingResourceId:extraparams.buildingResourceId,
			};
				store.load({params:extraparams,
					callback: function(rec, operation, success) {
						if(rec.length==0){
							this$.layout.setActiveItem(24);
						}
					}
				});
				break;
			case 'hostelAvailableBedsInfoId':
				store.getProxy().extraParams = {
					startDate:this$.getParams().startDate,
					endDate:this$.getParams().endDate,
					buildingResourceId:extraparams.buildingResourceId,
			};
				store.load({params:extraparams,
					callback: function(rec, operation, success) {
						if(rec.length==0){
							this$.layout.setActiveItem(24);
						}
					}
				});
				break;
			case  'hostelOccupantInfoId':
				store.getProxy().extraParams = {
					startDate:this$.getParams().startDate,
					endDate:this$.getParams().endDate,
					buildingResourceId:extraparams.buildingResourceId,
					resourceId:extraparams.buildingResourceId
			};
				store.load({
					params:extraparams,
					callback: function(rec, operation, success) {
						if(rec.length==0){
							this$.layout.setActiveItem(24);
						}
					}
				});
				break;
			case  'hostelOccupantProgBatchInfoId':
				store.getProxy().extraParams = {
					startDate:this$.getParams().startDate,
					endDate:this$.getParams().endDate,
					academyLocationId:extraparams.academyLocationId,
					programId1:extraparams.programId1,
					batchId1:extraparams.batchId1,
					periodId1:extraparams.periodId1
			};
				store.load({
					params:extraparams,
					callback: function(rec, operation, success) {
						if(rec.length==0){
							this$.layout.setActiveItem(24);
						}
					}
				});
				break;
			}
			/*this$.resetPageSetting(store);
			store.load({params:extraparams,
				callback: function(rec, operation, success) {
					if(rec.length==0){
						this$.layout.setActiveItem(24);
					}
				}
			});*/
    		
    		
    	}
    	
    },
	defaults: {
		cls:'panelNoSpace'
    },
    items:[{ /*Hostel Building level info, active tab = 0 */
    	xtype:'griddashlet',
    	itemId:'hostelBuildingId',
    	title: getCommonTranslation('HOSTEL_BUILDING'),
    	header: false,
		model:'Academia.model.enquiry.reports.HostelDashletModel',
    	//fields:['hostelCode','buildingCode','noOfBeds','noOfOccupiedBeds','noOfAvailableBeds'],
		url : SERVERURL.PATH_FIND_DASHLET_HOSTEL_BUILDING,
    	addPagingToolbar : true,
    	features: [{
    		ftype: 'summary',
    		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
    	}],
    	columns : [{
    		text : getHostelTranslation('HOSTEL_CODE_NAME'),
    		dataIndex : 'hostelCode',
    		sortable : true,
    		flex:0.6,
    		renderer:function(value,record){
    			var hostelCodeName='';
    			if(!isNullOrEmpty(record.record.get("hostelCode") )){
    				var hostelCode = record.record.get("hostelCode");
    				var hostelName = record.record.get("hostelName");
    				hostelCodeName = hostelCode+ '/' +hostelName;
    			}
    			return  hostelCodeName;			 
    		},
    		summaryRenderer: function(value, summaryData, dataIndex) {
    			return getFeeAndPaymentCommonTranslation('TOTAL');
    		}
    	}, {
    		text : getHostelTranslation('BUILDING_NAME'),
    		dataIndex : 'buildingName',
    		sortable : true,
    		flex:0.4
    		/*renderer:function(value,record){
    			var buildingCodeName='';
    			if(!isNullOrEmpty(record.record.get("buildingCode") )){
    				var buildingCode = record.record.get("buildingCode");
    				var buildingName = record.record.get("buildingName");
    				buildingCodeName = buildingCode+ '/' +buildingName;
    			}
    			return  buildingCodeName;			 
    		}*/
    	}, {
    		text : getHostelTranslation('TOTAL_ROOMS'),
    		dataIndex : 'noOfRooms',
    		sortable : true,
    		flex:0.4,
    		summaryType: 'sum',
    		renderer:function(value){
    			if(value>0){
    				return  '<a href="#">'+value+'</a>';
    			}else{
    				return value;
    			}
    		},
    		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
    			return  value;
    		}
    	}, {
    		text : getHostelTranslation('TOTAL_NO_OF_BEDS'),
    		dataIndex : 'noOfBeds',
    		sortable : true,
    		flex:0.4,
    		summaryType: 'sum',
    		renderer:function(value){
    			if(value>0){
    				return  '<a href="#">'+value+'</a>';
    			}else{
    				return value;
    			}
    		},
    		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
    			return  value;
    		}
    	}, {
    		text : getHostelTranslation('OCCUPIED_BEDS'),
    		dataIndex : 'noOfOccupiedBeds',
    		sortable : true,
    		flex:0.4,
    		summaryType: 'sum',
    		renderer:function(value){
    			if(value>0){
    				return  '<a href="#">'+value+'</a>';
    			}else{
    				return value;
    			}
    		},
    		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
    			return  value;
    		}
    	}, {
    		text : getHostelTranslation('AVAILABLE_BEDS'),
    		dataIndex : 'noOfAvailableBeds',
    		sortable : true,
    		flex:0.4,
    		summaryType: 'sum',
    		renderer:function(value){
    			if(value>0){
    				return  '<a href="#">'+value+'</a>';
    			}else{
    				return value;
    			}
    		},
    		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
    			return  value;
    		}
    	}/*, {
    		text : 'Floor',
    		dataIndex : 'floorNo',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : 'Room',
    		dataIndex : 'roomNo',
    		sortable : true,
    		flex:0.4
    	}*/],
    	listeners:{
    		activate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');
    			hosteldashlet.activeTab = 0;    			
    			hosteldashlet.addForHostelAcademyLocation(hosteldashlet,portlet);
    			hosteldashlet.addForHostelProgramBatch(hosteldashlet,portlet);
    			hosteldashlet.addExportToPdf(hosteldashlet,portlet);
    			hosteldashlet.addExportToExcel(hosteldashlet,portlet);
    			//hosteldashlet.addForBuilding(hosteldashlet,portlet);
    			hosteldashlet.down('#hostalTbarContainerItemId').setVisible(false); // for hide tbar display field
    		},
    		deactivate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');    			
    			hosteldashlet.removeHostelAcademyLocation(hosteldashlet,portlet);
    			hosteldashlet.removeHostelProgramBatch(hosteldashlet,portlet);
    			hosteldashlet.removeExportToPdf();
    			hosteldashlet.removeExportToExcel();
    		},
    		/*hostelBuildingGrid*/
    		cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    			if(e.target.tagName == 'A'){
    				
    				var hostelDashletGrid = cell.up('grid');
    				var columnName = hostelDashletGrid.columnManager.columns[cellIndex].dataIndex;
    				var buildingCode = record.get('buildingCode');
    				var hostelCode = record.get('hostelCode');
    				var buildingResourceId = record.get('buildingResourceId');
					var hostelDashletCount=hostelDashletGrid.up('hosteldashlet');
					var tbarContainer = hostelDashletCount.down('#hostalTbarContainerItemId');
					if(tbarContainer.down('#innerContainer'))tbarContainer.down('#innerContainer').removeAll();
    				
    				if(columnName == 'noOfBeds'){
//    					var selectedRecord = hostelDashletGrid.getSelectionModel().getSelection()[0];
//    					var hostelDashletCount=hostelDashletGrid.up('hosteldashlet');
    					hostelDashletCount.getLayout().setActiveItem(3);
    					hostelDashletCount.params={
    							buildingResourceId:buildingResourceId,
    							//allCurrentStatus:true
    					};
    					var paramsObj={
    							buildingResourceId:buildingResourceId,
    							//allCurrentStatus:true
    					};
//    					hostelDashletCount.loadDashlet(paramsObj);
    					
    					
    				}else if(columnName == 'noOfRooms'){

    					hostelDashletCount.getLayout().setActiveItem(8);
    					hostelDashletCount.params={
    							buildingResourceId:buildingResourceId,
    					};
    					var paramsObj={
    							buildingResourceId:buildingResourceId,
    					};
    				} else if(columnName == 'noOfOccupiedBeds'){
//    					var selectedRecord = hostelDashletGrid.getSelectionModel().getSelection()[0];
//    					var hostelDashletCount=hostelDashletGrid.up('hosteldashlet');
    					//hostelDashletCount.down('#hostalTbarContainerItemId').setVisible(true);
    					hostelDashletCount.getLayout().setActiveItem(4);
    					hostelDashletCount.params={
    							buildingResourceId:buildingResourceId,
    					};
    					var paramsObj={
    							buildingResourceId:buildingResourceId,
    					};
//    					hostelDashletCount.loadDashlet(paramsObj);
    				} else if(columnName == 'noOfAvailableBeds'){
//    					var selectedRecord = hostelDashletGrid.getSelectionModel().getSelection()[0];
//    					var hostelDashletCount=hostelDashletGrid.up('hosteldashlet');
    					hostelDashletCount.getLayout().setActiveItem(5);
    					hostelDashletCount.params={
    							buildingResourceId:buildingResourceId,
    					};
    					var paramsObj={
    							buildingResourceId:buildingResourceId,
    					};
//    					hostelDashletCount.loadDashlet(paramsObj);
    				}
					hostelDashletCount.loadDashlet(paramsObj);
					// added for single row display field top on grid
					var pnlItems = {
						xtype: 'container',
						layout:'hbox',
						width:'50%',
						itemId: 'innerContainer',
						defaults:{

							tdAttrs: { style: 'padding: 5px;' }
						},
						items:[{
							xtype:'displayfield',
							fieldLabel:getHostelTranslation('HOSTEL'),
							flex:1,
							value:hostelCode,
							labelStyle:'padding-top:2px;',
							labelWidth:50
						}, { 
							xtype: 'tbspacer', 
							width: 10 
						},{
							xtype:'displayfield',
							fieldLabel:getHostelTranslation('BUILDING_NAME'),
							flex:1,
							value:buildingCode,
							labelStyle:'padding-top:2px;',
							//labelWidth:50
						}]
					};
					tbarContainer.add(pnlItems);
    			}
    		}
    	}
    },{ /*Group by academy location grid active tab = 1*/
    	xtype:'griddashlet',
    	itemId:'hostelAcademyLocationId',
    	title: getCommonTranslation('GROUP_BY_ACADEMY_LOCATION'),
    	header: false,
		model:'Academia.model.enquiry.reports.HostelDashletModel',
    	url : SERVERURL.PATH_FIND_DASHLET_GROUPBY_ACADEMY_LOCATION,
    	addPagingToolbar : true,
    	features: [{
    		ftype: 'summary',
    		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
    	}],
    	columns : [{
    		text : getHostelTranslation('ACADEMY_LOCATION'),
    		dataIndex : 'academyDisplayCode',
    		sortable : true,
    		flex:0.6,
    		summaryRenderer: function(value, summaryData, dataIndex) {
    			return getFeeAndPaymentCommonTranslation('TOTAL');
    		}
    	}, {
    		text : getHostelTranslation('HOSTEL_CODE_NAME'),
    		dataIndex : 'hostelCode',
    		sortable : true,
    		flex:0.4,
    		renderer:function(value,record){
    			var hostelCodeName='';
    			if(!isNullOrEmpty(record.record.get("hostelCode") )){
    				var hostelCode = record.record.get("hostelCode");
    				var hostelName = record.record.get("hostelName");
    				hostelCodeName = hostelCode+ '/' +hostelName;
    			}
    			return  hostelCodeName;			 
    		},
    	}, {
    		text : getHostelTranslation('NO_OF_OCCUPANTS'),
    		dataIndex : 'noOfAllotted',
    		sortable : true,
    		flex:0.4,
    		summaryType: 'sum',
    		renderer:function(value){
    			if(value>0){
    				return  '<a href="#">'+value+'</a>';
    			}else{
    				return value;
    			}
    		},
    		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
    			return  value;
    		}
    	}],
    	listeners:{
    		activate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');
    			hosteldashlet.activeTab = 1;    			
    			hosteldashlet.addForBuilding(hosteldashlet,portlet);
    			hosteldashlet.addForHostelProgramBatch(hosteldashlet,portlet);
    			hosteldashlet.addExportToPdf(hosteldashlet,portlet);
    			hosteldashlet.addExportToExcel(hosteldashlet,portlet);
    			hosteldashlet.down('#hostalTbarContainerItemId').setVisible(false); // for hide tbar display field
    		},
    		deactivate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');    			
    			hosteldashlet.removeHostelProgramBatch(hosteldashlet,portlet);
    			hosteldashlet.removeBuilding(hosteldashlet,portlet);
    			hosteldashlet.removeExportToPdf();
    			hosteldashlet.removeExportToExcel();
    		},
    		/*Group by academy location grid*/
    		cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    			if(e.target.tagName == 'A'){
    				
    				var hostelDashletGrid = cell.up('grid');
    				
    				var columnName = hostelDashletGrid.columnManager.columns[cellIndex].dataIndex;
    				var academyLocationName = record.get('academyCode');
    				var hostelCode = record.get('hostelCode');
    				var buildingResourceId = record.get('buildingResourceId');
					var hostelDashletCount=hostelDashletGrid.up('hosteldashlet');
					var tbarContainer = hostelDashletCount.down('#hostalTbarContainerItemId');
					if(tbarContainer.down('#innerContainer'))tbarContainer.down('#innerContainer').removeAll();
    				
    				if(columnName == 'noOfAllotted'){
    					var selectedRecord = hostelDashletGrid.getSelectionModel().getSelection()[0];
    					var hostelDashletCount=hostelDashletGrid.up('hosteldashlet');
    					hostelDashletCount.getLayout().setActiveItem(6);
    					hostelDashletCount.params={
    							buildingResourceId:buildingResourceId,
    							resourceId:buildingResourceId
    					};
    					var paramsObj={
    							buildingResourceId:buildingResourceId,
    							resourceId:buildingResourceId
    					};
    					hostelDashletCount.loadDashlet(paramsObj);
    					// added for single row display field top on grid
    					var pnlItems = {
    							xtype: 'container',
    							layout:'hbox',
    							width:'60%',
    							itemId: 'innerContainer',
    							defaults:{

    								tdAttrs: { style: 'padding: 5px;' }
    							},
    							items:[{
    								xtype:'displayfield',
    								fieldLabel:getHostelTranslation('ACADEMY_LOCATION'),
    								flex:1,
    								value:academyLocationName,
    								labelStyle:'padding-top:2px;',
    								labelWidth:120
    							}, { 
    								xtype: 'tbspacer', 
    								width: 10 
    							},{
    								xtype:'displayfield',
    								fieldLabel:getHostelTranslation('HOSTEL'),
    								flex:1,
    								value:hostelCode,
    								labelStyle:'padding-top:2px;',
    								labelWidth:50
    							}]
    						};
    						tbarContainer.add(pnlItems);
    				}
    			}
    		}    		
    	}
    },{ 
    	xtype:'griddashlet',
    	itemId:'hostelProgramBatchId',
    	title: getCommonTranslation('GROUP_BY_PROGRAM_GROUP'),
    	header: false,
		model:'Academia.model.enquiry.reports.HostelDashletModel',
    	url : SERVERURL.FIND_DASHLET_GROUPBY_PROG_BATCH_PERIOD,
    	addPagingToolbar : true,
    	features: [{
    		ftype: 'summary',
    		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
    	}],
    	columns : [{
    		text : getHostelTranslation('ACADEMY_LOCATION'),
    		dataIndex : 'academyDisplayCode',
    		sortable : true,
    		flex:0.6,
    		summaryRenderer: function(value, summaryData, dataIndex) {
    			return getFeeAndPaymentCommonTranslation('TOTAL');
    		}
    	}, {
    		text : getHostelTranslation('PROGRAM'),
    		dataIndex : 'programName',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('BATCH'),
    		dataIndex : 'batchName',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('PERIOD'),
    		dataIndex : 'periodName',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('TOTAL_OCCUPANT'),
    		dataIndex : 'occupantCount',
    		sortable : true,
    		flex:0.4,
    		summaryType: 'sum',
    		renderer:function(value){
    			if(value>0){
    				return  '<a href="#">'+value+'</a>';
    			}else{
    				return value;
    			}
    		},
    		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
    			return  value;
    		}
    	}],
    	listeners:{
    		activate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');
    			hosteldashlet.activeTab = 2;
    			//hosteldashlet.addGraphViewButton(hosteldashlet);    			
    			hosteldashlet.addForHostelAcademyLocation(hosteldashlet,portlet);
    			hosteldashlet.addForBuilding(hosteldashlet,portlet);
    			hosteldashlet.addExportToPdf(hosteldashlet,portlet);
    			hosteldashlet.addExportToExcel(hosteldashlet,portlet);
    			hosteldashlet.down('#hostalTbarContainerItemId').setVisible(false); // for hide tbar display field
    		},
    		deactivate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');    		
    			hosteldashlet.removeHostelAcademyLocation(hosteldashlet,portlet);
    			hosteldashlet.removeBuilding(hosteldashlet,portlet);
    			hosteldashlet.removeExportToPdf();
    			hosteldashlet.removeExportToExcel();
    		},
    		cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
    			if(e.target.tagName == 'A'){
    				
    				var hostelDashletGrid = cell.up('grid');
    				var columnName = hostelDashletGrid.columnManager.columns[cellIndex].dataIndex;
    				
    				var academyLocationName = record.get('academyCode');
    				var programName = record.get('programName');
    				var batchName = record.get('batchName');
    				var periodName = record.get('periodName');
					var hostelDashletCount=hostelDashletGrid.up('hosteldashlet');
					var tbarContainer = hostelDashletCount.down('#hostalTbarContainerItemId');
					if(tbarContainer.down('#innerContainer'))tbarContainer.down('#innerContainer').removeAll();
    				
    				if(columnName == 'occupantCount'){
    					var selectedRecord = hostelDashletGrid.getSelectionModel().getSelection()[0];
    					var hostelDashletCount=hostelDashletGrid.up('hosteldashlet');
    					hostelDashletCount.getLayout().setActiveItem(7);
    					hostelDashletCount.params={
    							academyLocationId:selectedRecord.data.academyLocationId,
    							programId1:selectedRecord.data.programId,
    							batchId1:selectedRecord.data.batchId,
    							periodId1:selectedRecord.data.periodId
    					};
    					var paramsObj={
    							academyLocationId:selectedRecord.data.academyLocationId,
    							programId1:selectedRecord.data.programId,
    							batchId1:selectedRecord.data.batchId,
    							periodId1:selectedRecord.data.periodId
    					};
    					hostelDashletCount.loadDashlet(paramsObj);
    					
    					var pnlItems = {
    							xtype: 'container',
    							layout:'hbox',
    							width:'100%',
    							itemId: 'innerContainer',
    							defaults:{
    								tdAttrs: { style: 'padding: 5px;' }
    							},
    							items:[{
    								xtype:'displayfield',
    								fieldLabel:getHostelTranslation('ACADEMY_LOCATION'),
    								flex:1,
    								value:academyLocationName,
    								labelStyle:'padding-top:2px;',
    								labelWidth:120
    							}, { 
    								xtype: 'tbspacer', 
    								width: 5 
    							},{
    								xtype:'displayfield',
    								fieldLabel:getHostelTranslation('PROGRAM'),
    								flex:1,
    								value:programName,
    								labelStyle:'padding-top:2px;',
    								labelWidth:60
    							},{ 
    								xtype: 'tbspacer', 
    								width: 5 
    							},{
    								xtype:'displayfield',
    								fieldLabel:getHostelTranslation('BATCH'),
    								flex:1,
    								value:batchName,
    								labelStyle:'padding-top:2px;',
    								labelWidth:40
    							},{ 
    								xtype: 'tbspacer', 
    								width: 5 
    							},{
    								xtype:'displayfield',
    								fieldLabel:getHostelTranslation('PERIOD'),
    								flex:1,
    								value:periodName,
    								labelStyle:'padding-top:2px;',
    								labelWidth:40
    							}]
    						};
    						tbarContainer.add(pnlItems);

    				}
    			}
    		}    		
    	}    
    },
    
   /* start hyperlink grids*/
    
    {	/*bedInfogrid active tab=3*/
    	xtype:'griddashlet',
    	itemId:'hostelBedCountInfoId',
    	title: getHostelTranslation('TOTAL_NO_OF_BEDS'),
    	header: false,
		model:'Academia.model.enquiry.reports.HostelDashletModel',
    	url : SERVERURL.FIND_DASHLET_NO_OF_BEDS_INFO,
    	addPagingToolbar : true,
    	columns : [{
    		text : getHostelTranslation('FLOOR_NO'),
    		dataIndex : 'floorNo',
    		sortable : true,
    		flex:0.6
    	}, {
    		text : getHostelTranslation('ROOM_TYPE'),
    		dataIndex : 'roomType',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('ROOM_NO'),
    		dataIndex : 'roomNo',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('BED_NO'),
    		dataIndex : 'bedNo',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('BED_DESCRIPTION'),
    		dataIndex : 'bedDetail',
    		sortable : true,
    		flex:0.4
    	}],
    	listeners:{
    		activate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');
    			hosteldashlet.activeTab = 3;
    			hosteldashlet.addExportToPdf(hosteldashlet,portlet);
    			hosteldashlet.addExportToExcel(hosteldashlet,portlet);
    			hosteldashlet.addTool(Ext.create('Ext.panel.Tool',{
   		         type: 'prev',
   		         handler: function(btn, target, header, tool){
   		        	 header.ownerCt.getLayout().setActiveItem(0);
   		        	 header.remove(tool);
   		        	hosteldashlet.params={};
   		        	 // reset the page param after going previous page
   		        	 var itemStore = hosteldashlet.items.get(2).getStore();
   		        	 itemStore.currentPage = 1;
   		        	hosteldashlet.loadDashlet();
   		        	 }
   			     }));
    			hosteldashlet.down('#hostalTbarContainerItemId').setVisible(true); // for show tbar display field
    		},
    		deactivate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');
    			hosteldashlet.removeExportToPdf();
    			hosteldashlet.removeExportToExcel();    			
    		}    		
    	}
    
    
    },{/*occupied beds info active tab = 4*/
	    	xtype:'griddashlet',
	    	itemId:'hostelOccupiedBedsInfoId',
	    	title: getHostelTranslation('OCCUPIED_BEDS'),
	    	header: false,
			model:'Academia.model.enquiry.reports.HostelDashletModel',
	    	url : SERVERURL.FIND_DASHLET_OCCUPIED_BEDS_INFO,
	    	addPagingToolbar : true,
	    	columns : [{
	    		text : getHostelTranslation('FLOOR_NO'),
	    		dataIndex : 'floorNo',
	    		sortable : true,
	    		flex:0.5
	    	}, {
	    		text : getHostelTranslation('ROOM_NO'),
	    		dataIndex : 'roomNo',
	    		sortable : true,
	    		flex:0.5
	    	}, {
	    		text : getHostelTranslation('ROOM_TYPE'),
	    		dataIndex : 'roomType',
	    		sortable : true,
	    		flex:0.5
	    	},	{
	    		text : getHostelTranslation('USER_TYPE'),
	    		dataIndex : 'userType',
	    		sortable : true,
	    		flex:0.5
	    	}, {
	    		text : getHostelTranslation('OCCUPANTID'),
	    		dataIndex : 'userCode',
	    		sortable : true,
	    		flex:1.2
	    	}, {
	    		text : getHostelTranslation('OCCUPANT_NAME'),
	    		dataIndex : 'userName',
	    		sortable : true,
	    		flex:1.2
	    	}, {
	    		text : getHostelTranslation('BED_NO'),
	    		dataIndex : 'bedNo',
	    		sortable : true,
	    		flex:0.4
	    	}, {
	    		text : getHostelTranslation('STATUS'),
	    		dataIndex : 'currentStatus',
	    		sortable : true,
	    		flex:0.6
	    	}, {
	    		text : getHostelTranslation('FEE_STATUS'),
	    		dataIndex : 'status',
	    		sortable : true,
	    		flex:0.6,
	    		renderer:function(value){
	    			if (!isNullOrEmpty(value)) {
	    				if(value == 'DONE' || value == 'Done'){
	    					return '<span style="color:green;">' + getHostelTranslation('PAID') + '</span>';
	    				}else if(value == 'PENDING' || value == 'Pending'){
	    					return '<span style="color:red;">' + getHostelTranslation('NOT_PAID') + '</span>';
	    				} 
	    			}
	    		}
	    	}],
	    	listeners:{
	    		activate:function(portlet){
	    			var hosteldashlet=portlet.up('hosteldashlet');
	    			hosteldashlet.activeTab = 4;
	    			hosteldashlet.addExportToPdf(hosteldashlet,portlet);
	    			hosteldashlet.addExportToExcel(hosteldashlet,portlet);
	    			hosteldashlet.down('#hostalTbarContainerItemId').setVisible(true); // for show tbar display field
	    			hosteldashlet.addTool(Ext.create('Ext.panel.Tool',{
	   		         type: 'prev',
	   		         handler: function(btn, target, header, tool){
	   		        	 header.ownerCt.getLayout().setActiveItem(0);
	   		        	 header.remove(tool);
	   		        	hosteldashlet.params={};
	   		        	 // reset the page param after going previous page
	   		        	 var itemStore = hosteldashlet.items.get(2).getStore();
	   		        	 itemStore.currentPage = 1;
	   		        	hosteldashlet.loadDashlet();
	   		        	 }
	   			     }));
	    		},
	    		deactivate:function(portlet){
	    			var hosteldashlet=portlet.up('hosteldashlet');
	    			hosteldashlet.removeExportToPdf();
	    			hosteldashlet.removeExportToExcel();    			
	    		}    		
	    	}
    	},{	/*occupied beds info active tab = 5*/
    	xtype:'griddashlet',
    	itemId:'hostelAvailableBedsInfoId',
    	title: getHostelTranslation('AVAILABLE_BEDS'),
    	header: false,    	
		model:'Academia.model.enquiry.reports.HostelDashletModel',
    	url : SERVERURL.FIND_DASHLET_AVAILABLE_BEDS_INFO,
    	addPagingToolbar : true,
    	columns : [{
    		text : getHostelTranslation('FLOOR_NO'),
    		dataIndex : 'floorNo',
    		sortable : true,
    		flex:0.6
    	}, {
    		text : getHostelTranslation('ROOM_TYPE'),
    		dataIndex : 'roomType',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('ROOM_NO'),
    		dataIndex : 'roomNo',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('BED_NO'),
    		dataIndex : 'bedNo',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('BED_DESCRIPTION'),
    		dataIndex : 'bedDetail',
    		sortable : true,
    		flex:0.4
    	}],
    	listeners:{
    		activate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');
    			hosteldashlet.activeTab = 5;
    			hosteldashlet.addExportToPdf(hosteldashlet,portlet);
    			hosteldashlet.addExportToExcel(hosteldashlet,portlet);
    			hosteldashlet.addTool(Ext.create('Ext.panel.Tool',{
   		         type: 'prev',
   		         handler: function(btn, target, header, tool){
   		        	 header.ownerCt.getLayout().setActiveItem(0);
   		        	 header.remove(tool);
   		        	hosteldashlet.params={};
   		        	 // reset the page param after going previous page
   		        	 var itemStore = hosteldashlet.items.get(2).getStore();
   		        	 itemStore.currentPage = 1;
   		        	hosteldashlet.loadDashlet();
   		        	 }
   			     }));
    			hosteldashlet.down('#hostalTbarContainerItemId').setVisible(true); // for show tbar display field
    		},
    		deactivate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');
    			hosteldashlet.removeExportToPdf();
    			hosteldashlet.removeExportToExcel();    			
    		}    		
    	}    
    },{	//occupants info active tab = 6
    	xtype:'griddashlet',
    	itemId:'hostelOccupantInfoId',
    	title: getHostelTranslation('NO_OF_OCCUPANTS'),
    	header: false,    	
		model:'Academia.model.enquiry.reports.HostelDashletModel',
    	url : SERVERURL.FIND_DASHLET_OCCUPANTS_INFO,
    	addPagingToolbar : true,
    	columns : [{
    		text : getHostelTranslation('BUILDING_NAME'),
    		dataIndex : 'buildingName',
    		sortable : true,
    		flex:1.1
    	}, {
    		text : getHostelTranslation('FLOOR_NO'),
    		dataIndex : 'floorNo',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('ROOM_NO'),
    		dataIndex : 'roomNo',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('ROOM_TYPE'),
    		dataIndex : 'roomType',
    		sortable : true,
    		flex:0.4
    	},	{
    		text : getHostelTranslation('USER_TYPE'),
    		dataIndex : 'userType',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('OCCUPANTID'),
    		dataIndex : 'userCode',
    		sortable : true,
    		flex:1.1
    	}, {
    		text : getHostelTranslation('OCCUPANT_NAME'),
    		dataIndex : 'userName',
    		sortable : true,
    		flex:1.1
    	}, {
    		text : getHostelTranslation('BED_NO'),
    		dataIndex : 'bedNo',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('STATUS'),
    		dataIndex : 'currentStatus',
    		sortable : true,
    		flex:0.5
    	}, {
    		text : getHostelTranslation('FEE_STATUS'),
    		dataIndex : 'status',
    		sortable : true,
    		flex:0.5,
    		renderer:function(value){
    			if (!isNullOrEmpty(value)) {
    				if(value == 'DONE' || value == 'Done'){
    					return '<span style="color:green;">' + getHostelTranslation('PAID') + '</span>';
    				}else if(value == 'PENDING' || value == 'Pending'){
    					return '<span style="color:red;">' + getHostelTranslation('NOT_PAID') + '</span>';
    				} 
    			}
    		}
    	}],
    	listeners:{
    		activate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');
    			hosteldashlet.activeTab = 6;
    			hosteldashlet.addExportToPdf(hosteldashlet,portlet);
    			hosteldashlet.addExportToExcel(hosteldashlet,portlet);
    			hosteldashlet.addTool(Ext.create('Ext.panel.Tool',{
   		         type: 'prev',
   		         handler: function(btn, target, header, tool){
   		        	 header.ownerCt.getLayout().setActiveItem(1);
   		        	 header.remove(tool);
   		        	hosteldashlet.params={};
   		        	 // reset the page param after going previous page
   		        	 var itemStore = hosteldashlet.items.get(2).getStore();
   		        	 itemStore.currentPage = 1;
   		        	hosteldashlet.loadDashlet();
   		        	 }
   			     }));
    			hosteldashlet.down('#hostalTbarContainerItemId').setVisible(true); // for show tbar display field
    		},
    		deactivate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');
    			hosteldashlet.removeExportToPdf();
    			hosteldashlet.removeExportToExcel();    			
    		}    		
    	}    
    },  {
    	//occupantsby program batch period info active tab = 7
    	xtype:'griddashlet',
    	itemId:'hostelOccupantProgBatchInfoId',    	
    	title: getHostelTranslation('TOTAL_OCCUPANT'),
    	header: false,
		model:'Academia.model.enquiry.reports.HostelDashletModel',
    	url : SERVERURL.FIND_DASHLET_OCCUPANT_PROG_BATCH_PERIOD,
    	addPagingToolbar : true,
    	columns : [{
    		text : getHostelTranslation('OCCUPANTID'),
    		dataIndex : 'userCode',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('OCCUPANT_NAME'),
    		dataIndex : 'userName',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('HOSTEL'),
    		dataIndex : 'hostelCode',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('BUILDING_NAME'),
    		dataIndex : 'buildingName',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('FLOOR_NO'),
    		dataIndex : 'floorNo',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('ROOM_NO'),
    		dataIndex : 'roomNo',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('BED_NO'),
    		dataIndex : 'bedNo',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('FEE_STATUS'),
    		dataIndex : 'status',
    		sortable : true,
    		flex:0.4,
    		renderer:function(value){
    			if (!isNullOrEmpty(value)) {
    				if(value == 'DONE' || value == 'Done'){
    					return '<span style="color:green;">' + getHostelTranslation('PAID') + '</span>';
    				}else if(value == 'PENDING' || value == 'Pending'){
    					return '<span style="color:red;">' + getHostelTranslation('NOT_PAID') + '</span>';
    				} 
    			}
    		}
    	}],
    	listeners:{
    		activate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');
    			hosteldashlet.activeTab = 7;
    			hosteldashlet.addExportToPdf(hosteldashlet,portlet);
    			hosteldashlet.addExportToExcel(hosteldashlet,portlet);
    			hosteldashlet.addTool(Ext.create('Ext.panel.Tool',{
   		         type: 'prev',
   		         handler: function(btn, target, header, tool){
   		        	 header.ownerCt.getLayout().setActiveItem(2);
   		        	 header.remove(tool);
   		        	hosteldashlet.params={};
   		        	 // reset the page param after going previous page
   		        	 var itemStore = hosteldashlet.items.get(2).getStore();
   		        	 itemStore.currentPage = 1;
   		        	hosteldashlet.loadDashlet();
   		        	 }
   			     }));
    			hosteldashlet.down('#hostalTbarContainerItemId').setVisible(true); // for show tbar display field
    		},
    		deactivate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');
    			hosteldashlet.removeExportToPdf();
    			hosteldashlet.removeExportToExcel();    			
    		}    		
    	}     
    },  {
    	//occupantsby program batch period info active tab = 8
    	xtype:'griddashlet',
    	itemId:'hostelRoomCountInfoId',    	
    	title: getHostelTranslation('TOTAL_ROOMS'),
    	header: false,
		model:'Academia.model.enquiry.reports.HostelDashletModel',
    	url : SERVERURL.FIND_DASHLET_NO_OF_ROOM_INFO,
    	addPagingToolbar : true,
    	columns : [{
    		text : getHostelTranslation('ROOM_NO'),
    		dataIndex : 'roomNo',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('TOTAL_NO_OF_BEDS'),
    		dataIndex : 'noOfBeds',
    		sortable : true,
    		flex:0.4
    	}, {
    		text : getHostelTranslation('AVAILABLE_BEDS'),
    		dataIndex : 'noOfAvailableBeds',
    		sortable : true,
    		flex:0.4
    	},{
	    	text : getHostelTranslation('STATUS'),
	    	dataIndex : 'status',
	    	sortable : true,
	    	flex:0.6,
	    	renderer:function(value){
				if (!isNullOrEmpty(value)) {
					if(value == 'ACTIVE' || value == 'Active'){
						return '<span style="color:green;">' + getHostelTranslation('ACTIVE') + '</span>';
					}else{
						return '<span style="color:red;">' + getHostelTranslation('IN_ACTIVE') + '</span>';
					} 
				}
	    	}
    	}],
    	listeners:{
    		activate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');
    			hosteldashlet.activeTab = 8;
    			hosteldashlet.addExportToPdf(hosteldashlet,portlet);
    			hosteldashlet.addExportToExcel(hosteldashlet,portlet);
    			hosteldashlet.addTool(Ext.create('Ext.panel.Tool',{
   		         type: 'prev',
   		         handler: function(btn, target, header, tool){
   		        	 header.ownerCt.getLayout().setActiveItem(0);
   		        	 header.remove(tool);
   		        	hosteldashlet.params={};
   		        	 // reset the page param after going previous page
   		        	 var itemStore = hosteldashlet.items.get(2).getStore();
   		        	 itemStore.currentPage = 1;
   		        	hosteldashlet.loadDashlet();
   		        	 }
   			     }));
    			hosteldashlet.down('#hostalTbarContainerItemId').setVisible(true); // for show tbar display field
    		},
    		deactivate:function(portlet){
    			var hosteldashlet=portlet.up('hosteldashlet');
    			hosteldashlet.removeExportToPdf();
    			hosteldashlet.removeExportToExcel();    			
    		}    		
    	}     
    }],
    tbar: {
		cls: 'hostalDashlateTbar',
		itemId: 'hostalTbarContainerItemId',
		height:30,
		style:{
			//marginLeft:'-10px',
			'background': '#C4D6A0 !important',
			'background-color': '#C4D6A0 !important',
	    	'padding': '0px 10px !important',
		},
		hidden:true,
		items: []
	}
});

