/*
 * @Author priyanshi sharma
 */
Ext.define('Academia.view.dashboard.dashlets.RequestedDocumentsDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.requesteddocumentsdashlet',
	layout:'card',
	activeItem: 0,
	autoScroll : false,
	cls:'requesteddocumentDashletCLS dashlet horizontalScrollingFixed',
	loadDashlet :function(paramObj){
		var this$=this;
		var view= this.layout.getActiveItem();
		if(view.xtype=='griddashlet'){
			var store= view.getStore();
			var personId = this$.getCurrentlyLoggedInDashletUser().personId;
			var extraParams = {
					personId: personId
			};
			store.load({
				params: extraParams,
				callback: function(rec, operation, success) {
					if (rec != null && rec.length == 0) {
						this$.layout.setActiveItem(0);
					}
				}
			});
			store.proxy.extraParams = {
					personId: personId
			};
		}
	},
	defaults: {
		cls:'panelNoSpace'

	},

	items:[{
		xtype:'griddashlet',
		itemId:'EmployeeRequestedDocumentsId',
		model:'Academia.model.dashboard.EmployeeRequestedDocumentsModel',
		url : SERVERURL.PATH_DOCUMENT_GROUP_MASTER_BY_PERSON_ID,
		//addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('DOCUMENT_GROUP'),
			dataIndex: 'groupName',
			sortable : false,
			flex:0.3,
			renderer: function(value, metadata, record) {
				return '<a href="#">' +record.data.groupName+'</a>';
			}
		}, {
			text : getCommonTranslation('REQUESTED_ON'),
			dataIndex : 'requestedOn',
			sortable : false,
			flex:0.3,
			renderer: function(value){
				return dateRender(value);
			}
		}, {
			text : getCommonTranslation('SUBMISSION_LAST_DATE'),
			dataIndex : 'dueOn',
			sortable :false,
			flex:0.2,
			renderer: function(value){
				return dateRender(value);
			}
		},  {
			text : getCommonTranslation('STATUS'),
			dataIndex: 'documentStatus',
			sortable : false,
			flex:0.2,
			renderer : function(value) {
				var val = '';
				if(value == 'Completed') {
					val = '<span style="color:Green;">' +'Completed'+ '</span>';
				}else if(value == 'Pending') {
					val = '<span style="color:red;">' +'Pending'+ '</span>';
				}else if(value == 'Partially Completed') {
					val = '<span style="color:orange;">' +'Partially Uploaded'+ '</span>';
				}
				return val;
			}

		}],
		listeners:{

			activate:function(portlet){
				var requesteddocumentsdashlet=portlet.up('requesteddocumentsdashlet');
				requesteddocumentsdashlet.activeTab = 1;
				requesteddocumentsdashlet.addRequestedDocuments(requesteddocumentsdashlet,portlet);
			},
			deactivate:function(portlet){
				var requesteddocumentsdashlet=portlet.up('requesteddocumentsdashlet');

				requesteddocumentsdashlet.removeRequestedDocuments(requesteddocumentsdashlet,portlet);

			},

			cellclick: function( cell, td, cellIndex,record) {

				var requestedDocumentsDashletGrid = cell.up('grid');
				var columnName = requestedDocumentsDashletGrid.columnManager.columns[cellIndex].dataIndex;
				if(columnName == 'groupName') {
					var selectedRecord = requestedDocumentsDashletGrid.getSelectionModel().getSelection()[0];
					var docID = selectedRecord.get('id');
					if(!isNullOrEmpty(docID)) {

						var studentcountdashlet=requestedDocumentsDashletGrid.up('requesteddocumentsdashlet');
						studentcountdashlet.getLayout().setActiveItem(1);
						var store = studentcountdashlet.getLayout().getActiveItem().getStore();
						store.getProxy().extraParams = {
							documentGroupMasterId : docID,
						};
						studentcountdashlet.loadDashlet();
					}
				}
			}
		}
	},{

		xtype:'griddashlet',
		selType:'checkboxmodel',
		//title : getProgramandcourseTranslation('LIST_OF_DOCUMENTS'),
		header:false,
		model:'Academia.model.dashboard.EmployeeRequestedDocumentsModel',
		url : SERVERURL.PATH_EMPLOYEE_REQUESTED_DOCUMENT_ID,
		//addPagingToolbar : true,
		itemId:'ListOfDocument',
		tbar: [{
			xtype : 'button',				
			itemId : 'btnDelete',
			cls: 'CustomToolbarBtnReject',
			tooltip :getCommonTranslation('DELETE'),
			glyph: ICONGLYPH.DELETEGLYPH
		},'->',{
			xtype : 'button',
			itemId : 'downloadDocumentItemId',
			tooltip : getCommonTranslation('DOWNLOAD_ALL'),
			text : getCommonTranslation('DOWNLOAD_ALL'),
			formBind:true,
		}],
		columns : [{
			text : getCommonTranslation('S_NO'),
			dataIndex: 'serialNo',
			sortable : false,
			flex:0.2
		}, {
			text :  getCommonTranslation('DOCUMENTS'),
			dataIndex : 'name',
			sortable : false,
			flex:0.2
		},{
			text :  getCommonTranslation('FILE_TYPE'),
			dataIndex : 'documentFormat',
			sortable : false,
			flex:0.2
		},{
			text :getCommonTranslation('UPLOADED_ON'),
			dataIndex: 'submissionDate',
			sortable : false,
			renderer: function(value){
				return dateRender(value);
			},
			flex:0.2
		}, {
			text : getCommonTranslation('STATUS'),
			dataIndex: 'documentStatus',
			sortable : false,
			flex:0.2
		},{
			text :  getCommonTranslation('REFERENCE_DOCUMENT'),
			dataIndex : 'referenceDocumentId',
			sortable : false,
			flex:0.2,
			renderer: function(value, metadata, record) {
	    		var msg = "";
	    		if(!isNullOrEmpty(record.raw.referenceDocumentName)) {
	    			msg = '<a href="#">' +record.raw.referenceDocumentName + '</a>';
	    		}
	    		return msg;
	    	}
		},{
			text : getCommonTranslation('UPLOAD'),
			dataIndex: 'upload',
			sortable : false,
			flex:0.25,
			renderer : function(value) {
				return '<span><button style="background-color:green;color:white;font-size:10.5px;">Upload Document</button>';
			}
		}],
		listeners:{
			activate:function(portlet){
				var requesteddocumentsdashlet=portlet.up('requesteddocumentsdashlet');
				requesteddocumentsdashlet.activeTab = 2
				requesteddocumentsdashlet.addRequestedDocuments(requesteddocumentsdashlet,portlet);
			},
			deactivate:function(portlet){
				var requesteddocumentsdashlet=portlet.up('requesteddocumentsdashlet');
				requesteddocumentsdashlet.removeRequestedDocuments(requesteddocumentsdashlet,portlet);
			}
		}

	}]
});
