/**
 * @author Akshay Sharma
 * 
 */
var studentAttendancetype = "null";
var periodId = null;
var sectionId = null;
var programWise = false;
var courseWise = false;
var sessionWise = false;
var attendanceType = [];
var permissionList=null;
var defaultView = null;
Ext.define('Academia.view.dashboard.dashlets.StudentAttendanceDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.studentattendancedashlet',
	graphView:false,
	layout:'card',
	activeItem: 0, 
	autoScroll: true,
	cls:'StudentAttendanceDashletCLS dashlet',
	loadDashlet :function(){
		var this$=this;
		var view = this.layout.getActiveItem();
		programWise = false;
		courseWise = false;
		sessionWise = false;
		admissionId = this$.getCurrentlyLoggedInUserInfoForPortalDashlet().admissionDetails[0].id;
		studentId =  this$.getCurrentlyLoggedInUserInfoForPortalDashlet().student.id;
		academyLocationId = this$.getUserCurrentAcademyLocation();
		var permissionsMap = new Ext.util.HashMap();
		var baseCtrl = Academia.app.getController('Academia.controller.base.BaseController');
		var portalId = baseCtrl.getCurrentLoggedPortalId();
		if (portalId == 3) {
			permissionsMap = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_DASHBOARD_PRIVILEGES');
		} else {
			permissionsMap = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_ATTENDANCE_DASHBOARD_PRIVILEGES');
		}
		var associatedAcadLocationIds = new Array();
	    associatedAcadLocationIds.push(academyLocationId);
		permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			
		defaultView = null;
		Ext.Ajax.request({
			type : 'rest',
			async: false,
			url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
			params : {
				academyLocatonId : academyLocationId
			},
			method : 'GET',
			success : function(f, action) {
				if(isNullOrEmpty(f.responseText))
				{
					showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
				}else{
					var res = Ext.JSON.decode(f.responseText);
					var view = this$.layout.getActiveItem();
					attendanceType = [];
					Ext.each(res, function(data) {
						attendanceType.push(data.studentAttendanceType);
					});
					//--checking for the visible tabs
					if((Ext.Array.contains(permissionList, 'PROGRAM_WISE')) && ((Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day')) && (view.itemId=="completeMainItemId" || view.itemId=="completeSummaryItemId"))){
						programWise = true; //calendarPanel 0
						studentAttendanceType = 'COMPLETE_DAY';
					}
					else if((Ext.Array.contains(permissionList, 'COURSE_WISE')) && ((Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level')) && (view.itemId=="courseMainItemId" || view.itemId=="courseSummaryItemId"))){
						courseWise=true; //stackbarchartverticaldashlet 2
						studentAttendanceType = 'COURSE_LEVEL';
					}
					else if((Ext.Array.contains(permissionList, 'SESSION_WISE')) && ((Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session')) && (view.itemId=="multiMainItemId" || view.itemId=="multiSummaryItemId"))){
						sessionWise=true; //calendarPanel 0
						studentAttendanceType = 'MULTIPLE_SESSION';
					}
					else if((Ext.Array.contains(permissionList, 'PROGRAM_WISE')) && ((Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day')))){
						programWise = true; //calendarPanel 0
						studentAttendanceType = 'COMPLETE_DAY';
						defaultView = 'COMPLETE_DAY';
					}
					else if((Ext.Array.contains(permissionList, 'COURSE_WISE')) && ((Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level')))){
						courseWise=true; //stackbarchartverticaldashlet 2
						studentAttendanceType = 'COURSE_LEVEL';
						defaultView = 'COURSE_LEVEL';
					}
					else if((Ext.Array.contains(permissionList, 'SESSION_WISE')) && ((Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session')))){
						sessionWise=true; //calendarPanel 0
						studentAttendanceType = 'MULTIPLE_SESSION';
						defaultView = 'MULTIPLE_SESSION';
					}
					
					if(!programWise && !courseWise && !sessionWise){
						programWise = true; //calendarPanel 0
						studentAttendanceType = 'COMPLETE_DAY';
						defaultView = 'COMPLETE_DAY';
					}
					Ext.Ajax.request({
						type : 'rest',
						async: false,
						url : SERVERURL.PLACEMENT_PROGRAM_STORE,
						params : {
							studentId : studentId
						},
						method : 'GET',
						success : function(f, action) {
							if(f.responseText == 'ENTRY_NOT_FOUND')
							{
								showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
							}else{
								var view = this$.layout.getActiveItem();
								var data = Ext.JSON.decode(f.responseText);
								periodId = data[0].periodId;
								sectionId = data[0].sectionId;
								
								if(programWise){
									if(view.xtype=='calendarpanel'){
										var params = new Object();
										view.eventStore.getProxy().actionMethods.read = 'GET';
										params.admissionId = admissionId;
										params.attendanceType = studentAttendanceType;
										params.periodId = periodId;
										params.sectionId = sectionId;
										view.eventStore.removeAll();
										view.eventStore.getProxy().url =  SERVERURL.GET_STUDENT_ATTENDANCE_CALENDAR_DATA;
										view.eventStore.getProxy().extraParams = params;
										view.eventStore.load();
									}else if(view.xtype == 'piechartattendancereport'){
										var store = view.getStore();
										var extraparams=this$.getParams();
										var submitURL=SERVERURL.GET_STUDENT_ATTENDANCE_SUMMARY_PIE_CHART;
										store.getProxy().api.read=submitURL;
										store.getProxy().extraParams = {
											admissionId : admissionId,
											attendanceType : studentAttendanceType,
											periodId : periodId,
											sectionId : sectionId
										};
										store.load({params:extraparams,
											callback: function(rec, operation, success) {
												if(rec != null){
													if(rec.length==0){
														this$.layout.setActiveItem(0);
													}
												}
											}
										});
									}
								}else if(courseWise){
									if(view.xtype=='calendarpanel' || view.xtype=='stackbarchartverticaldashlet'){
										this$.layout.setActiveItem(2);
										var view = this$.layout.getActiveItem();
										if(view.xtype=='stackbarchartverticaldashlet'){
											var store = view.getStore();
											var extraparams=this$.getParams();
											store.getProxy().extraParams = {
												admissionId : admissionId
											};
											store.load({params:extraparams,
												callback: function(rec, operation, success) {
													if(rec != null){
														if(rec.length==0){
															this$.layout.setActiveItem(2);
														}
													}
												}
											});
										}
									}else if(view.xtype == 'piechartattendancereport'){
										//this$.layout.setActiveItem(1);
										var store = view.getStore();
										var extraparams=this$.getParams();
										var submitURL=SERVERURL.GET_STUDENT_COURSE_ATTENDANCE_SUMMARY_PIE_CHART;
										store.getProxy().api.read=submitURL;
										store.getProxy().extraParams = {
											admissionId : admissionId
										};
										store.load({params:extraparams,
											callback: function(rec, operation, success) {
												if(rec != null){
													if(rec.length==0){
														this$.layout.setActiveItem(1);
													}
												}
											}
										});
									}
								}
								else if(sessionWise){
									if(view.xtype=='calendarpanel'){
										if(defaultView == 'MULTIPLE_SESSION'){
											this$.layout.setActiveItem(4);
										}
										var params = new Object();
										view.eventStore.getProxy().actionMethods.read = 'GET';
										params.admissionId = admissionId;
										params.attendanceType = studentAttendanceType;
										params.periodId = periodId;
										params.sectionId = sectionId;
										view.eventStore.removeAll();
										view.eventStore.getProxy().url =  SERVERURL.GET_STUDENT_ATTENDANCE_CALENDAR_DATA;
										view.eventStore.getProxy().extraParams = params;
										view.eventStore.load();
									}else if(view.xtype == 'piechartattendancereport'){
										var store = view.getStore();
										var extraparams=this$.getParams();
										var submitURL=SERVERURL.GET_STUDENT_ATTENDANCE_SUMMARY_PIE_CHART;
										store.getProxy().api.read=submitURL;
										store.getProxy().extraParams = {
											admissionId : admissionId,
											attendanceType : studentAttendanceType,
											periodId : periodId,
											sectionId : sectionId
										};
										store.load({params:extraparams,
											callback: function(rec, operation, success) {
												if(rec != null){
													if(rec.length==0){
														this$.layout.setActiveItem(4);
													}
												}
											}
										});
									}
								}
							}
						}
					});
				}
			}
		});
	},
	defaults: {
		cls:'panelNoSpace',
		xtype: 'piechartattendancereport'
	},
	items:[{ 
		xtype: 'calendarpanel', //0
		itemId: 'completeMainItemId',
		layout: 'fit',
		toolBarDateTitleWidth: '50%',
		toolBarDateTitleHeight: '2%',
		border: true,
		width: '100%',
		height: '100%',
		minHeight: 400,
		padding:0,
		margin:0,
		flex:1,
		region: 'center',
		activeItem: 3,
		eventStore:new Ext.create('Ext.calendar.data.MemoryEventStore', {}),
		calendarStore:new Ext.create('Ext.calendar.data.MemoryCalendarStore', {}),
		showDayView:false,
		showWeekView:false,
		showMonthView:true,
		showNavBar: true,
		listeners:{
			activate:function(portlet){
				var studentattendancedashlet=portlet.up('studentattendancedashlet');
				studentattendancedashlet.down('label').up().setVisible(false);
				var grid = studentattendancedashlet.getLayout().getActiveItem();
				studentattendancedashlet.activeTab = 0;
				studentattendancedashlet.addAttendanceSummaryList1(studentattendancedashlet,portlet);
				
				if((Ext.Array.contains(permissionList, 'COURSE_WISE')) && (Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
					studentattendancedashlet.addCourseWiseList(studentattendancedashlet,portlet);
				}
				
				if((Ext.Array.contains(permissionList, 'SESSION_WISE')) && (Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
					studentattendancedashlet.addSessionWiseList(studentattendancedashlet,portlet);
				}
				portlet.doLayout();
			},
			deactivate:function(portlet){
				var studentattendancedashlet=portlet.up('studentattendancedashlet');
				studentattendancedashlet.removeAttendanceSummaryList1();
				
				if((Ext.Array.contains(permissionList, 'COURSE_WISE')) && (Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
					studentattendancedashlet.removeCourseWiseList();
				}
				
				if((Ext.Array.contains(permissionList, 'SESSION_WISE')) && (Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
					studentattendancedashlet.removeSessionWiseList();
				}
			},
		}
	},{
		xtype: 'piechartattendancereport', //1
		itemId: 'completeSummaryItemId',
		title: 'Attendance Summary',
		width : 450,
		minHeight : 240,
		store: 'Academia.store.attendance.PendingAttendanceGridStore',
		numericField: 'totalDays',
		categoryField: 'attendanceStatus',
		listeners:{
			activate:function(portlet){
				var studentattendancedashlet=portlet.up('studentattendancedashlet');
				studentattendancedashlet.down('label').up().setVisible(true);
				var grid = studentattendancedashlet.getLayout().getActiveItem();
				studentattendancedashlet.activeTab = 1;
				studentattendancedashlet.addExportToPng(studentattendancedashlet,portlet);
				studentattendancedashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(0);
						header.remove(tool);
						studentattendancedashlet.params={};
						// reset the page param after going previous page
						studentattendancedashlet.loadDashlet();
					}
				}));
				//studentattendancedashlet.addCourseWiseList(studentattendancedashlet,portlet);
				//studentattendancedashlet.addSessionWiseList(studentattendancedashlet,portlet);
			},
			deactivate:function(portlet){
				var studentattendancedashlet=portlet.up('studentattendancedashlet');
				studentattendancedashlet.removeAttendanceSummaryList1();
				studentattendancedashlet.removeExportToPng();
				//studentattendancedashlet.removeCourseWiseList();
				//studentattendancedashlet.removeSessionWiseList();
			},
		}
	},{
		xtype:'stackbarchartverticaldashlet', //2
		itemId:'courseMainItemId',
		yAxesNumericField :['Present','Leave','Absent'],
		xAxesCategoryField : ['courseName'],
		titleLegend:[getProgramandcourseTranslation('PRESENT'), getProgramandcourseTranslation('Leave'), getProgramandcourseTranslation('Absent')],
		yAxesNumericTitle :getCommonTranslation('ATTENDANCCE_PER'),
		xAxesCategoryTitle :getProgramandcourseTranslation('COURSE'),
		model:'Academia.model.attendance.PendingAttendanceGridModel',
		url : SERVERURL.GET_STUDENT_COURSE_ATTENDANCE_BAR_CHART,
		listeners:{
			activate:function(portlet){
				var studentattendancedashlet=portlet.up('studentattendancedashlet');
				studentattendancedashlet.down('label').up().setVisible(false);
				studentattendancedashlet.activeTab = 2;
				studentattendancedashlet.addAttendanceSummaryList2(studentattendancedashlet,portlet);
				studentattendancedashlet.addExportToPng(studentattendancedashlet,portlet);
				
				if((Ext.Array.contains(permissionList, 'PROGRAM_WISE')) && (Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
					studentattendancedashlet.addProgramWiseList(studentattendancedashlet,portlet);
				}
				
				if((Ext.Array.contains(permissionList, 'SESSION_WISE')) && (Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
					studentattendancedashlet.addSessionWiseList(studentattendancedashlet,portlet);
				}
			},
			deactivate:function(portlet){
				var studentattendancedashlet=portlet.up('studentattendancedashlet');
				studentattendancedashlet.removeAttendanceSummaryList2();
				studentattendancedashlet.removeExportToPng();
				
				if((Ext.Array.contains(permissionList, 'PROGRAM_WISE')) && (Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
					studentattendancedashlet.removeProgramWiseList();
				}
				
				if((Ext.Array.contains(permissionList, 'SESSION_WISE')) && (Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
					studentattendancedashlet.removeSessionWiseList();
				}
			}
		}
	},{
		xtype: 'piechartattendancereport', //3
		itemId: 'courseSummaryItemId',
		title: 'Attendance Summary',
		width : 450,
		minHeight : 240,
		store: 'Academia.store.attendance.PendingAttendanceGridStore',
		numericField: 'totalDays',
		categoryField: 'attendanceStatus',
		listeners:{
			activate:function(portlet){
				var studentattendancedashlet=portlet.up('studentattendancedashlet');
				studentattendancedashlet.down('label').up().setVisible(true);
				var grid = studentattendancedashlet.getLayout().getActiveItem();
				studentattendancedashlet.activeTab = 3;
				studentattendancedashlet.addExportToPng(studentattendancedashlet,portlet);
				studentattendancedashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(2);
						header.remove(tool);
						studentattendancedashlet.params={};
						// reset the page param after going previous page
						studentattendancedashlet.loadDashlet();
					}
				}));
				//studentattendancedashlet.addProgramWiseList(studentattendancedashlet,portlet);
				//studentattendancedashlet.addSessionWiseList(studentattendancedashlet,portlet);
			},
			deactivate:function(portlet){
				var studentattendancedashlet=portlet.up('studentattendancedashlet');
				studentattendancedashlet.removeAttendanceSummaryList2();
				studentattendancedashlet.removeExportToPng();
				//studentattendancedashlet.removeProgramWiseList();
				//studentattendancedashlet.removeSessionWiseList();
			},
		}
	},{ 
		xtype: 'calendarpanel',
		itemId: 'multiMainItemId',
		layout: 'fit',
		toolBarDateTitleWidth: '50%',
		toolBarDateTitleHeight: '2%',
		border: true,
		width: '100%',
		height: '100%',
		minHeight: 400,
		padding:0,
		margin:0,
		flex:1,
		region: 'center',
		activeItem: 3,
		eventStore:new Ext.create('Ext.calendar.data.MemoryEventStore', {}),
		calendarStore:new Ext.create('Ext.calendar.data.MemoryCalendarStore', {}),
		showDayView:false,
		showWeekView:false,
		showMonthView:true,
		showNavBar: true,
		listeners:{
			activate:function(portlet){
				var studentattendancedashlet=portlet.up('studentattendancedashlet');
				studentattendancedashlet.down('label').up().setVisible(false);
				var grid = studentattendancedashlet.getLayout().getActiveItem();
				studentattendancedashlet.activeTab = 4;
				studentattendancedashlet.addAttendanceSummaryList3(studentattendancedashlet,portlet);
				if((Ext.Array.contains(permissionList, 'PROGRAM_WISE')) && (Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
					studentattendancedashlet.addProgramWiseList(studentattendancedashlet,portlet);
				}
				
				if((Ext.Array.contains(permissionList, 'COURSE_WISE')) && (Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
					studentattendancedashlet.addCourseWiseList(studentattendancedashlet,portlet);
				}

				portlet.doLayout();
			},
			deactivate:function(portlet){
				var studentattendancedashlet=portlet.up('studentattendancedashlet');
				studentattendancedashlet.removeAttendanceSummaryList3();
				if((Ext.Array.contains(permissionList, 'PROGRAM_WISE')) && (Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
					studentattendancedashlet.removeProgramWiseList();
				}
				
				if((Ext.Array.contains(permissionList, 'COURSE_WISE')) && (Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
					studentattendancedashlet.removeCourseWiseList();
				}
			},
		}
	},{
		xtype: 'piechartattendancereport',
		itemId: 'multiSummaryItemId',
		title: 'Attendance Summary',
		width : 450,
		minHeight : 240,
		store: 'Academia.store.attendance.PendingAttendanceGridStore',
		numericField: 'totalDays',
		categoryField: 'attendanceStatus',
		listeners:{
			activate:function(portlet){
				var studentattendancedashlet=portlet.up('studentattendancedashlet');
				studentattendancedashlet.down('label').up().setVisible(true);
				var grid = studentattendancedashlet.getLayout().getActiveItem();
				studentattendancedashlet.activeTab = 5;
				studentattendancedashlet.addExportToPng(studentattendancedashlet,portlet);
				studentattendancedashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(4);
						header.remove(tool);
						studentattendancedashlet.params={};
						// reset the page param after going previous page
						studentattendancedashlet.loadDashlet();
					}
				}));
				//studentattendancedashlet.addProgramWiseList(studentattendancedashlet,portlet);
				//studentattendancedashlet.addCourseWiseList(studentattendancedashlet,portlet);
			},
			deactivate:function(portlet){
				var studentattendancedashlet=portlet.up('studentattendancedashlet');
				studentattendancedashlet.removeAttendanceSummaryList3();
				studentattendancedashlet.removeExportToPng();
				//studentattendancedashlet.removeProgramWiseList();
				//studentattendancedashlet.removeCourseWiseList();
			},
		}
	}],
	tbar: {
		height : 40,
		hidden :true,
		itemId:'labelItemId',
		items: [{
			xtype: 'label',
			width : '100%',
			text: getProgramandcourseTranslation('ATTENDANCE_SUMMERY'),
			style: {
				color : 'black',
				'text-align': 'center',
				'font-weight': 'bold',
				'font-size': '16px',
				'margin-top':'13px'
			},
			//style:{marginLeft:'10px'},
		}]
	}
});
