/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.dashboard.dashlets.StudentMyDocumentsDashlet', {
    extend: 'Academia.view.dashboard.DashboardDashlet',
    alias: 'widget.studentmydocumentsdashlet',
    graphView: false,
    layout: 'card',
    activeItem: 0,
    autoScroll : false,
    cls:'StudentMyDocumentsDashletCLS dashlet horizontalScrollingFixed',
    loadDashlet: function() {
        var this$ = this;
        var view = this.layout.getActiveItem();
        if (view.xtype == 'griddashlet') {
            var store = view.getStore();
            var extraparams = this$.getParams();
            var userId = this$.getCurrentlyLoggedInDashletUser().id;
            if(portalId==7){
            	 var portalInfo = Academia.model.authentication.PortalInfoModel;
				 var student = portalInfo.get('student');
				 userId = student.id
            }
            store.getProxy().extraParams = {
                userId: userId
            };
            store.load({
                params: extraparams,
                callback: function(rec, operation, success) {
                    if (rec != null && rec.length == 0) {
                        this$.layout.setActiveItem(0);
                    }
                    if(view.getStore().data.items.length>0){
                    	var terminology = view.getStore().data.items[0].data.terminology;
                    	if(terminology =="School"){
                    		view.columns[4].setVisible(false);
                        }
                    }
                }
            });
            
        }
    },
    defaults: {
        cls: 'panelNoSpace',
        xtype: 'griddashlet'
    },
    items: [{
        fields: ['reportType', 'publishDate', 'documentName', 'documentPath','programName','batchName','periodName','templateType','terminology','marksheetPublishDate'],
        url: SERVERURL.GET_STUDENT_MYDOCUMENTS_DASHLET,
        addPagingToolbar: true,
        //cls: "fontSizeChangeForMarksheetDashletForStudent",
        columns: [{
            text: getExaminationTranslation("DOCUMENT_TYPE"),
            dataIndex: "reportType",
            sortable: true,
            flex: 1.5,
            renderer: function(b) {
                if (b == "HALL_TICKET") {
                    return getExaminationTranslation("HALL_TICKET")
                } else {
                    if (b == "MARKSHEET") {
                        return getExaminationTranslation("MARKSHEET")
                    } else {
                        if (b == "SIS Assessment Report P3-P6 Excel") {
                            return getExaminationTranslation("SIS_ASSESSMENT_REPORT_P3_P6_EXCEL")
                        } else {
                            if (b == "SIS Assessment Report P3-P6 PDF") {
                                return getExaminationTranslation("SIS_ASSESSMENT_REPORT_P3_P6_PDF")
                            } else {
                                if (b == "SIS Assessment Report S1-S4 Excel") {
                                    return getExaminationTranslation("SIS_ASSESSMENT_REPORT_S1_S4_EXCEL")
                                } else {
                                    if (b == "SIS Assessment Report S1-S4 PDF") {
                                        return getExaminationTranslation("SIS_ASSESSMENT_REPORT_S1_S4_PDF")
                                    } else {
									if (b == "SIS Assessment Report P3-P6 Excel New") {
										return getExaminationTranslation("SIS_ASSESSMENT_REPORT_P3_P6_EXCEL_NEW")
									} else {
									if (b == "SIS Assessment Report P3-P6 PDF New") {
										return getExaminationTranslation("SIS_ASSESSMENT_REPORT_P3_P6_PDF_NEW")
									} else {
									if (b == "SIS Assessment Report S1-S4 Excel New") {
										return getExaminationTranslation("SIS_ASSESSMENT_REPORT_S1_S4_EXCEL_NEW")
									} else {
									if (b == "SIS Assessment Report S1-S4 PDF New") {
										return getExaminationTranslation("SIS_ASSESSMENT_REPORT_S1_S4_PDF_NEW")
									}else 
									if (b == "SIS JC IB Student Assessment Report") {
										return getExaminationTranslation("SIS_JC_IB_STUDENT_ASSESSMENT_REPORT_PDF_NEW")
									}
									else {
                                        return b
                                    }
                                }
							}
						}
					}
				}
                            }
                        }
                    }
                }
            }
        }, {
            text: getExaminationTranslation('PUBLISH_DATE'),
            dataIndex: 'marksheetPublishDate',
            sortable: true,
            flex: 1.5,
            renderer: function(date) {
                return date;
            }
        },
        {
            text: getExaminationTranslation('CNTRL_ERL_PROGRAM'),
            dataIndex: 'programName',
            sortable: true,
            flex: 1,
        },{
            text: getExaminationTranslation('BATCH'),
            dataIndex: 'batchName',
            sortable: true,
            flex: 1,
        },{
            text: getExaminationTranslation('PERIOD'),
            dataIndex: 'periodName',
            sortable: true,
            flex: 1,
        },{
            text: getExaminationTranslation('DOC'),
            dataIndex: 'documentName',
            sortable: true,
            flex: 1,
            renderer: function(value, meta, record) {
                if (!isNullOrEmpty(value)) {
                	if(value=="Hold Applied"){
                		return getCommonTranslation('HOLD_APPLIED');
                	} else{
                		return "<a href='#'>" + value + "</a>";
                	}
                }
                return '';
            }
        }],
        listeners: {
            activate: function(portlet) {
            	
                var studentmydocumentsdashlet = portlet.up('studentmydocumentsdashlet');
                var grid = studentmydocumentsdashlet.getLayout().getActiveItem();
                
                var alinfomodel = Academia.model.authentication.ALInfoModel;
                var whetherSchool = alinfomodel.get('wheatherSchool');
                if(whetherSchool){
                	grid.columns[4].setVisible(false);
                  }
                
                studentmydocumentsdashlet.addExportToPdf(studentmydocumentsdashlet);
                studentmydocumentsdashlet.activeTab = 1;
                studentmydocumentsdashlet.addExportToPdf(studentmydocumentsdashlet, portlet);
                studentmydocumentsdashlet.addExportToExcel(studentmydocumentsdashlet, portlet);
                portlet.doLayout();
            },
            deactivate: function(portlet) {
                var studentmydocumentsdashlet = portlet.up('studentmydocumentsdashlet');
                studentmydocumentsdashlet.removeExportToPdf();
                studentmydocumentsdashlet.removeExportToExcel();
            },
            cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
                var studentCountGrid = View.up('grid');
                var columnName = studentCountGrid.columnManager.columns[ColIdx].dataIndex;
                if (e.target.tagName == 'A') {
                    if (columnName == 'documentName') {
                        var selectedRecord = studentCountGrid.getSelectionModel().getSelection()[0];
                        var reportType = selectedRecord.get('reportType');
                        var templateType = selectedRecord.get('templateType');
                        var docPath = selectedRecord.get('documentPath');
                        var documentPath = null;
                        var submitUrl
                        if(reportType =='MARKSHEET' && templateType == 'EVALUATION_EVENT'){
                        	var fields = docPath.split('.pdf');
                            var docAtcualPath = fields[0];
                            docAtcualPath = docAtcualPath+'_ForStudentPortal' + '.pdf';
                        	documentPath = window.btoa(unescape(encodeURIComponent(docAtcualPath)))
                        }else{
                        	documentPath = window.btoa(unescape(encodeURIComponent(docPath)))
                        }
                        /** For Both Hall Ticket and Marksheet download */
                        var submitUrl = SERVERURL.MARKSHEET_DOWNLOAD_URL;
                        var csvForm = Ext.create('Ext.form.Panel');
                       
                        csvForm.getForm().submit({
                            url: submitUrl + "?filePath=" + documentPath,
                            method: 'POST',
                            target: '_blank',
                            params: {
                                access_token: Ext.Ajax.defaultHeaders.access_token
                            },
                            headers: {
                                'Authorization': Ext.Ajax.defaultHeaders.Authorization
                            },
                            standardSubmit: true
                        });
                    }
                }
            }
        }
    }]
});