/**
 * @author Raghavendra.Soni
 */

var studentRegDetailsTemplate = new Ext.XTemplate('<tpl for="."><div>', 
		'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
			'<tr>', 
				'<td style="color:#273043; font-weight:600; vertical-align: top; width:33%;padding-bottom: 10px;">'+ getCommonTranslation('REGISTRATION') +' -</td>',
				'<td style="color:#273043; font-weight:600; vertical-align: top; width:66%;padding-bottom: 10px;"><a href="/student-portal/#/login?dashboardId={dashboardId}" target="_blank">'+ getCommonTranslation('OPEN_REGISTRATION_PORTAL') +'</a></td>',
			'</tr>',
		'</table></div></tpl>');

var emptymessege= '<span style="color:red; font-weight:600; vertical-align: top; width:100%;padding-bottom: 10px;">'+ getCommonTranslation('STUDENT_ID_IS_INACTIVE') +'</span>';

Ext.define('Academia.view.dashboard.dashlets.StudentRegistrationDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.studentregistrationdashlet',
    graphView:true,
    layout:'card',
    activeItem: 0, 
    cls:'StudentPersonalDashletCLS dashlet',
    loadDashlet :function(){
    	var this$=this;
    	var userInfo = Academia.model.authentication.UserInfoModel;
    	var portal =  userInfo.get('portalId');
 		var studentId = "";
 		var personId = "";
 		var studentCode= "";
 		var status="";
 		
    	var studentField = this$.down('#studentIdName');
		if(!isNullOrEmpty(studentField.valueModels[0])){
			studentId = studentField.valueModels[0].get("id");
 			personId = studentField.valueModels[0].get("personId");
 			studentCode=studentField.valueModels[0].get('studentCode');
 			status=studentField.valueModels[0].get('status');
		}
 		if(!isNullOrEmpty(studentId)){
			var studentRegDetailsDataview = this$.down("#studentRegDetailsDataview");
			var studentRegDetailsDataviewStore= studentRegDetailsDataview.getStore();
 			this.down('#pnlStudentRegDetails2').setVisible(true);
 			this.down('#noRecordFoundImagePanelItemId').setVisible(false);
 			this.down('#noRecordFoundImagePanelItemId').up().setAutoScroll(true);
 			if(!isNullOrEmpty(status) && !status){
 				studentRegDetailsDataviewStore.removeAll();
 				return false;
 			}else{
 			
 			$.ajax({
 	            url : CONST.URL_TOKEN,
 	            method: 'POST',
 	            headers: {
 	                'Accept': 'application/json'
 	            },
 	            data: {
 	                portal_code : 'REG_DESHLET',
 	                grant_type: 'password',
 	                client_id:'regdeshletclient', // Consumer Key
 	                client_secret: CONST.CSFP, // Consumer Secret
 	                username: studentCode, // UserName
 	                password: encryptPassword('password') // Password (if your IP address,
 	            },
 	            success : function(result) {
 	            	try{
 	            		studentRegDetailsDataviewStore.removeAll();
 	            		studentRegDetailsDataviewStore.loadData([{"dashboardId":result.access_token}], false);
 	            	}
 	            	catch(e){
 	            		//--
 	            	}
 	            	
 	            },
 	            error:function(response){
 	                //---
 	            }
 	        });
 			}
 			
			/*var userType = "STUDENT";
			studentRegDetailsDataviewStore.getProxy().extraParams = {
				studentId: studentId,
				personId: personId,
				studentCode: studentCode
			};
			studentRegDetailsDataviewStore.load();*/
		}
 		else{
 			this.down('#pnlStudentRegDetails2').setVisible(false);
 			this.down('#noRecordFoundImagePanelItemId').setVisible(true);
 			this.down('#noRecordFoundImagePanelItemId').up().setAutoScroll(false);
 		}
 		var userInfo = Academia.model.authentication.UserInfoModel;
    },
	defaults: {
		cls: 'horizontalScrollingFixed',
    },
    items: [{
    	xtype:'panel',
    	border: true,
    	autoScroll:true,
    	layout:'hbox',
    	itemId:'pnlStudentRegDetails',
    	margin : 0,
    	width:'100%',
    	items:[{
    		xtype: 'panel',
    		width:'100%',
    		layout:'vbox',
    		itemId:'pnlStudentRegDetails2',
    		items:[{
    			xtype:'panel',
    			border:false,
    			frame:false,
    			cls:'panelNoSpace',
    			layout:'fit',
    			width:'95%',
    			items: [{
    				xtype:'dataview',
    				itemId:'studentRegDetailsDataview',
    				store :Ext.create('Ext.data.ArrayStore', {
    				    storeId: 'studentRegDetailsDataviewStore',
    				    fields: ['dashboardId']
    				}),
    				tpl: studentRegDetailsTemplate,
    				emptyText:emptymessege,
    				multiSelect:true,
    				autoHeight:true,
    				itemSelector:'div.innerGrid'
    			}]
    		}]
    	},{
    	xtype: 'panel',
		width: '100%',
		itemId:'noRecordFoundImagePanelItemId',
		height: '100%',
		html: '<div><div class ="studentlookupdashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
		style:{
		    left: '-12%;'
		}
    	}]
    }],
    tbar: {
        cls: 'studentregistrationdashbordTbar',
        style:{marginLeft:'-10px'},
        items: [{
			xtype: 'customcombobox',
			name: 'studentIdName',
			itemId:'studentIdName',
			fieldLabel: getCommonTranslation('STUDENT_ID_NAME'),
			labelWidth:125,
			width:'90%',
			height:'32px',
			style:{marginLeft:'15px'},
			store: 'Academia.store.feeandpayment.managebill.Student',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			emptyText: getCommonTranslation('SEARCH_STUDENT'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.minWidth = picker.minWidth-110;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			},
			listeners:{
				afterrender: function(cmb){
					var comboStore = cmb.getStore();
					comboStore.on('beforeload', function(store){
						store.getProxy().extraParams.allStudents = true;
					});
				}
			}
        }]
    }
});

