Ext.define('Academia.view.dashboard.dashlets.SurveyDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.surveydashlet',

	requires : ['Academia.model.enquiry.SurveyDashletMdl'],
	graphView:true,
	layout:'card',
	activeItem: 0, 
	cls:'SurveyDashletCLS dashlet',
	loadDashlet :function(){
		var this$=this;
		var view= this.layout.getActiveItem();
		if(view.xtype=='griddashlet' || view.xtype=='columnchartdashlet'){
			var store= view.getStore();
			var extraparams=this$.getParams();
			store.load({params:extraparams,
				callback: function(rec, operation, success) {
					if(rec.length==0){
						this$.layout.setActiveItem(2);
					}
				}
			});
		}
	},
	defaults: {
		cls:'panelNoSpace',
		xtype:'griddashlet'
	},

	items:[{
		xtype:'griddashlet',
		model:'Academia.model.enquiry.SurveyDashletMdl',
		url : SERVERURL.SURVEY_LIST,
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('SURVEY_TITLE'),
			dataIndex : 'surveyTitle',
			sortable : true,
			flex:0.1,
			renderer:function(val){
				if(!isNullOrEmpty(val)) {
					return '<a href="#">'+val+'</a>';
				}
			}
		}, {
			text : getCommonTranslation('COMPLETED_RESPONSES'),
			dataIndex : 'completedResponses',
			sortable : true,
			flex:0.1
		},{
			text : getCommonTranslation('INCOMPLETE_RESPONSES'),
			dataIndex : 'incompleteResponses',
			sortable : true,
			flex:0.1
		},{
			text : getCommonTranslation('START_DATE'),
			dataIndex : 'surveyStartDate',
			sortable : true,
			flex:0.1,
			renderer:function(val){		
				return dateRender(val);
			}
		},{
			text : getCommonTranslation('END_DATE_LABEL'),
			dataIndex : 'surveyExpiredDate',
			sortable : true,
			flex:0.1,
			renderer:function(val){		
				return dateRender(val);
			}

		},{
			text : getCommonTranslation('PARTICIPANT_COUNT'),
			dataIndex : 'toatalDistributionCount',
			sortable : true,
			flex:0.1

		}],
		listeners:{
			activate:function(portlet){
				var surveydashlet=portlet.up('surveydashlet');
				surveydashlet.addExportToPdf(surveydashlet);
				surveydashlet.activeTab =1;
				surveydashlet.addGraphViewButton(surveydashlet);
				surveydashlet.addExportToPdf(surveydashlet,portlet);
				surveydashlet.addExportToExcel(surveydashlet,portlet);
				portlet.doLayout();
			},
			deactivate:function(portlet){
				var surveydashlet=portlet.up('surveydashlet');
				surveydashlet.removeGraphViewButton(surveydashlet);
				surveydashlet.removeExportToPdf();
				surveydashlet.removeExportToExcel();
			},	
			cellclick: function( cell, td, cellIndex,record) {
				var surveyGrid = cell.up('grid');
				var columnName = surveyGrid.columnManager.columns[cellIndex].dataIndex;
				if(columnName == 'surveyTitle') {
					window.open(record.data.url);
				}
			}
		}
	},{
		xtype:'columnchartdashlet',
		xAxesCategoryField :['completedResponses'],
		yAxesNumericField : ['incompleteResponses'],
		xAxesCategoryTitle :'completedResponses',
		yAxesNumericTitle :'incompleteResponses',
		model:'Academia.model.enquiry.SurveyDashletMdl',
		//url : SERVERURL.SURVEY_LIST +'?page=1&start=0&limit=10',
		url : SERVERURL.SURVEY_LIST,
		listeners:{
			activate:function(portlet){
				var surveydashlet=portlet.up('surveydashlet');
				surveydashlet.activeTab = 0;
				surveydashlet.addGridViewButton(surveydashlet);
				surveydashlet.addExportToPng(surveydashlet,portlet);
			},
			deactivate:function(portlet){
				var surveydashlet=portlet.up('surveydashlet');
				surveydashlet.removeGridViewButton(surveydashlet);
				surveydashlet.removeExportToPng();
			}
		}
	},{
		xtype: 'panel',
		width: '100%',
		height: '100%',
		html: '<div><div class ="dashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
		//src: CONSTANTS.NO_DATA_DISPALY_DASHBORD_IMAGE_SRC,//'resources/images/no_data_to_display.png',
		listeners:{
			activate:function(portlet){
				var surveydashlet=portlet.up('surveydashlet');
				surveydashlet.addExportToPdf(surveydashlet);
				surveydashlet.activeTab =1;
				surveydashlet.addGraphViewButton(surveydashlet);
				surveydashlet.addExportToPdf(surveydashlet,portlet);
				surveydashlet.addExportToExcel(surveydashlet,portlet);
			},
			deactivate:function(portlet){
				var surveydashlet=portlet.up('surveydashlet');
				surveydashlet.removeGraphViewButton(surveydashlet);
				surveydashlet.removeExportToPdf();
				surveydashlet.removeExportToExcel();
			}
		}
	}]
});
