/**
 * @author prathamesh.sheth
 * 
 * This component is used for to defining ID format details in Dialog box.
 */
Ext.define('Academia.view.datasetting.IdFormatFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.idformatFormwindow',
    modal: true,
    resizable: false,
    //maxHeight:500,
    autoScroll: true,
    layout:'fit',
    width: 720,
    cls: 'selectedDataIdFormat',
    title: getCommonTranslation('DEFINE_ID_FORMAT'), //Define ID Format
    items: [{
        xtype: 'form',
        itemId: 'idFormatForm',
        plugins: "formlabelrequired",
        items: [{
            xtype: 'hidden',
            itemId: 'Id',
            name: 'id'
        },{
            xtype: 'hidden',
            itemId: 'Version',
            name: 'version'
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            itemId: 'radioButtonsrPanel',
            items: [{
                xtype: 'radiogroup',
                width: '100%',
                itemId: 'isOriginalRadio',
                items: [{
                	boxLabel: getCommonTranslation('RUNNING_NUMBER') , //Running Number
                	name: 'idFormatType',
                    inputValue: 'RUNNING_NUMBER',
                    itemId: 'runningNumberIdFormat'
                }, {
                	boxLabel: getCommonTranslation('ALPHA_NUMERIC'), //Alpha numeric
                    name: 'idFormatType',
                    inputValue: 'ALPHA_NUMERIC',
                    itemId: 'alphaNumericIdFormat'
                },{
                	boxLabel: getCommonTranslation('DYNAMIC'), //Dynamic Fields
                    name: 'idFormatType',
                    inputValue: 'DYNAMIC',
                    itemId: 'dynamicIdFormat'
                },{
                	boxLabel: getCommonTranslation('DROOL'), //Dynamic Fields
                    name: 'idFormatType',
                    inputValue: 'DROOL',
                    itemId: 'droolFormat'
                }]
            }]
        }, {
            xtype: 'form',
            itemId: 'runningNumberPanel',
            disabled:true,
            hidden:true,
            header: false,
            border: false,
            width: '100%',
        	items: [{
    			xtype:'fieldcontainer',
    			layout:'hbox',
    			width: 'auto',
    			defaults: {
    				width: 300,
    				labelAlign: 'top'
    			},
    			style:{marginLeft:'5px'},
    			items: [{
                    xtype: 'textfield',
                    name: 'startFrom',
                    itemId: 'runningNumberStartFrom',
                    fieldLabel: getCommonTranslation('START_FROM'), //Start From
                    allowBlank: false,
                    maskRe:/\d/,
                    value: 0000
                },{
                	xtype: 'numberfield',
                    name: 'numberOfDigit',
                    fieldLabel: getCommonTranslation('ENTER_NUMBER_OF_DIGIT'), //Numeric Counter Start From
                    minValue: 1
                }]}
    			]
        	
        }, {
            xtype: 'form',
            itemId: 'alphaNumericPanel',
            disabled:true,
            hidden:true,
            header: false,
            border: false,
            items: [{
    			xtype:'fieldcontainer',
    			layout:'hbox',
    			width: 'auto',
    			defaults: {
    				width: 300,
    				labelAlign: 'top'
    			},
    			style:{marginLeft:'10px'},
            items: [{
                xtype: 'textfield',
                name: 'prefix',
                fieldStyle: 'text-transform:uppercase', // This does the trick
                fieldLabel: getCommonTranslation('PREFIX'), //Prefix
            }, {
                xtype: 'textfield',
                name: 'suffix',
                fieldStyle: 'text-transform:uppercase', // This does the trick
                fieldLabel: getCommonTranslation('SUFFIX'), //Suffix
            } ]
            },
            {
    			xtype:'fieldcontainer',
    			layout:'hbox',
    			width: 'auto',
    			defaults: {
    				width: 300,
    				labelAlign: 'top'
    			},
    			style:{marginLeft:'10px'},
            items: [{
                xtype: 'numberfield',
                name: 'startFrom',
                fieldLabel: getCommonTranslation('NUMERIC_COUNTER_START'), //Numeric Counter Start From
                minValue: 0,
                allowBlank: false
            },{
            	xtype: 'numberfield',
                name: 'numberOfDigit',
                fieldLabel: getCommonTranslation('ENTER_NUMBER_OF_DIGIT'), //Numeric Counter Start From
                minValue: 0
            } ]
            }]
        }, {
            xtype: 'form',
            itemId: 'dynamicPanel',            
            header: false,
            border: false,
            //margin:0,
            items: [{ 
            	xtype:'fieldcontainer',
    			layout:'hbox',
    			width: 'auto',
    			defaults: {
    				width: 160,
    				labelAlign: 'top'
    			},
    			style:{marginLeft:'5px'},
                items: [{
                    xtype: 'customcombobox',
                    name: 'idFormat',
                    itemId: 'cmbIdFormatType',
                    store: 'datasetting.DynamicComboStore',
                    valueField: 'id',
                    displayField: 'value',
                    //fieldLabel:getCommonTranslation('ADD_ATTRIBUTE'), //Add Attribute                    
                    value:1,  //Dynamic Field
                    editable: false,
                    queryMode: 'local',
                    triggerAction: 'all',
                    forceSelection: true,
                    allowBlank: false
                }, {
                    xtype: 'numberfield',
                    itemId: 'numCounter',
                    name: 'counter',                    
                    allowBlank: false,
                    //fieldLabel:getCommonTranslation('RUNNING_NUMBER'), //Running Number           
                    hidden: true,
                    disabled:true,
                    minValue: 0
                },{
                	xtype: 'numberfield',
                	itemId: 'numberOfDigit',
                    name: 'numberOfDigit',
                    //fieldLabel: getCommonTranslation('ENTER_NUMBER_OF_DIGIT'), //Numeric Counter Start From
                    hidden: true,
                    disabled:true,
                    minValue: 0
                }, {
                    xtype: 'textfield',
                    itemId: 'txtAlphaNumeric',
                    name: 'alphanumeric',                    
                    allowBlank: false,
                    //fieldLabel: getCommonTranslation('ALPHA_NUMERIC'), //Alpha numeric
                    hidden: true,
                    disabled:true,
                    fieldStyle: 'text-transform:uppercase'
                }, {
                    xtype: 'customcombobox',
                    name: 'entity',
                    itemId: 'cmbDynamicEntity',
                    store: 'datasetting.DataSettingDynamicEntityStore',
                    valueField: 'id',                    
                    displayField: 'displayCode',
                    //fieldLabel: getCommonTranslation('ENTITY'), //Entity
                    editable: false,
                    queryMode: 'local',
                    triggerAction: 'all',
                    forceSelection: true,
                    allowBlank: false
                }, {
                    xtype: 'customcombobox',
                    name: 'field',
                    itemId: 'cmbDynamicField',
                    store: 'datasetting.DataSettingDynamicFieldStore',                    
                    valueField: 'id',                        
                    displayField: 'displayCode',                    
                    //fieldLabel: getCommonTranslation('FIELD'), //Field
                    editable: false,
                    queryMode: 'local',
                    triggerAction: 'all',
                    forceSelection: true,
                    allowBlank: false
                },
                {
                    xtype: 'fieldcontainer',
                    //width: '100%',
                    
                    defaults: {                                            
                        width: 100
                    }, 
                    items: [{
		                    xtype: 'button',
		                    tooltip: getCommonTranslation('ADD'), //Add				    	      	   
		                    style: {
		                    	//padding: '10px',
		                        marginTop: '0px !important'
		                    },
		                    //ui: 'CustomBtnSubmit',
		                    cls:'customBtnAdd',
		                    scale: CONSTANTS.BUTTONSIZE,                    
		                    itemId: 'btnAddIDFormatType',
		                    text: getCommonTranslation('ADD') //Add
		                }/*, {
		                    xtype: 'button',
		                    tooltip: getCommonTranslation('DELETE'), //Delete				    	      	   
		                    style: {
		                        marginTop: '0px !important'
		                    },
		                    ui: 'CustomBtnCancel',
		                    scale: CONSTANTS.BUTTONSIZE,
		                    itemId: 'btnDeleteIDFormatType',
		                    text: getCommonTranslation('DELETE') //Delete
		                }*/]
                }]
            }, /*{
                xtype: 'idformatselectedpanel',                
                width: 300,
                height: 150
           
            },*/
            {
            	xtype:'panel',
            	//extend: 'Ext.grid.Panel',
            	//width:'',
            	//height:'200',
    			items:[{
    				xtype: 'idformatselectedgrid',
    				itemId: 'idformatselectedgrid',
    			}]
                
            }]
        },{
            xtype: 'form',
            itemId: 'droolPanel',
            disabled:true,
            hidden:true,
            header: false,
            border: false,
            defaults: {
				width: 300,
				labelAlign: 'top'
			},
			style:{marginLeft:'5px'},
            items: [{
                xtype: 'customcombobox',
                name: 'field',
                itemId: 'droolName',
                store:Ext.create('Academia.store.program.programDetails.programBatches.programPeriod.ProgramPeriodOtherRuleStore'),                    
                valueField: 'id',                        
                displayField: 'value',                    
                fieldLabel: getCommonTranslation('NAME'), //Field
                editable: false,
                labelAlign: 'top',
                queryMode: 'remote',
                triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
                triggerAction: 'all',
                forceSelection: true,
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            height:50,
            style:{marginTop:'10px'},
            items: [{
                xtype: 'button',
                itemId: 'btnSaveIdFormatForm',
                text: getCommonTranslation('SUBMIT'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                itemId: 'btnCancelIdFormatForm',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});