/**
 * @author Saket.Puranik
 * 
 * This component is used for to show HOD History Details.
 */
Ext.define('Academia.view.department.HODHistoryGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.hodhistorygrid',
			store : 'department.HODHistoryStore',
			title :  getCommonTranslation('LIST_OF_HOD'),//List Of HOD
			collapsible:false,
			border: true,
			viewConfig : {
				stripeRows : CONSTANTS.STRIPEROWS
			},
			style:{
		    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
		    },
			columns : [ {
				header : getCommonTranslation('USER_ID'),//User Id	
				dataIndex : 'userId',
				sortable : false,	
			    flex : .6
			}, {
				header : getCommonTranslation('HOD_NAME'),//HOD Name
				dataIndex : 'hodName',	
				sortable : false,	
				flex : .4
			}, {
				header : getCommonTranslation('FROM_DATE'),//From Date
				dataIndex : 'fromDate',	
				sortable : false,	
				flex : .4,
				renderer:function(val){		
					return dateRender(val);
				}
			}, {
				header : getCommonTranslation('TO_DATE'),//To Date
				dataIndex : 'tillDate',	
				sortable : false,	
				flex : .4,
				renderer:function(val){		
					return dateRender(val);
				}
			}],
			dockedItems : [ {
				xtype : 'toolbar',
				dock : 'bottom',
				items : [ {
					xtype: 'custompagingtoolbar',
		            plugins:['pagesize'],
					store : 'department.HODHistoryStore',
					emptyMsg : getCommonTranslation('EMPTY_HOD_DETAILS_MESSAGE'),//No hod details  to display
					displayInfo : true
				} ]
			} ]			
		});