/**
 * @author sakdet.puranik
 * 
 * This component is used for to show sub department details Dialog box.
 */
Ext.define('Academia.view.department.SubDepartmentFormWindow',
		{
			extend : 'Ext.window.Window',
			alias : 'widget.subdepartmentformwindow',			
			modal : true,
			resizable:false,
			title : getCommonTranslation('SUB_DEPARTMENT_DETAILS'),//Sub Department Details		
			margin:0,
			items : [{
				xtype: 'form',
				itemId:'subdepartmentForm',
				plugins : "formlabelrequired",
			    method : 'POST',
			    margin:0,
			    bodyPadding:'10 10 10 10',			   				
			    standardSubmit : false,
			    items : [{
			    	xtype:'hidden',
			    	itemId : 'subDepartmentId',
					name : 'id'	
			    },{
			    	xtype:'hidden',
			    	itemId : 'parentDepartmentId',
					name : 'parentDepartment'	
			    },{
			    	xtype:'hidden',
			    	itemId : 'parentDepartmentType',
					name : 'departmentType'	
			    },{
			    	xtype:'hidden',
			    	itemId : 'academyLocationId',
					name : 'academyLocationId'	
			    },{
			    	xtype: 'fieldcontainer',
				    width: 'auto',
				    defaults: {
				    	labelAlign: 'top',
				    	width: 256
				    },
				    layout: {
				    	type: 'hbox'
				    },
					items: [{
						fieldLabel :getCommonTranslation('SUB_DEPARTMENT_ID'),//Sub Deparetment ID
						xtype : 'textfield',
						itemId : 'subDeptId',
						name : 'serialId',
						allowBlank:false
					},{
						fieldLabel : getCommonTranslation('SUB_DEPARTMENT_NAME'),//Sub Department Name	
						xtype : 'textfield',
						itemId : 'subDeptName',
						name : 'name',
						allowBlank:false
					}]
				},{
					xtype: 'fieldcontainer',
				    width: 'auto',
				    defaults: {
				    	labelAlign: 'top',
				    	width: 256
				    },
				    layout: {
				    	type: 'hbox'
				    },
					items: [{
						fieldLabel : getCommonTranslation('SHORTCODE'),//Short Code
						xtype : 'textfield',
						itemId : 'subShortCode',
						maxLength:10,
						name : 'shortCode'
					},
					{
						xtype:'statusCombo',
						name:'status',											
						itemId:'cmbStatus',
						editable: false,
						emptyText:getCommonTranslation('SELECT_TEXT'),//---Select---						
						allowBlank:false
					}]
				},{
		        	xtype:'fieldcontainer',
		        	width:'100%',
		        	cls:'windowBtnPos',
		            items: [{
		            	xtype : 'button',				
						itemId:'btnSaveSubDepartmentForm',
						text : getCommonTranslation('SAVE'), //Submit
						ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE,
		                formBind:true
					},{
						xtype : 'button',
						itemId:'btnCancelSubDepartmentForm',						
						text : getCommonTranslation('CANCEL'), //Cancel
						ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
					}]
				}]
			}]		
		});