/**
 * @author <a href="mailto:vidhi.shah@serosoft.in">Vidhi Shah</a>
 *
 */
Ext.define('Academia.view.document.ApplicantBulkDocUpdateForm', {
	extend: 'Ext.window.Window',
	alias : 'widget.applicantbulkdocupdateform',
	autoScroll : true,
	title:getCommonTranslation('BULK_DOCUMENT_DETAILS'),
	modal:true,
	frame: true,
	items : [ {
		xtype: 'idgeneratorformwin',

		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
		},
		standardSubmit: false,
		items: [{
			xtype : 'hidden',
			itemId : 'document_hidden_field',
			name : 'id'
		}, {
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top'
			},
			items : [ {
				xtype:'panel',
				cls : 'panelNoSpace',
				items:[{
					xtype: 'textareafield',
					name: 'documentName',
					itemId : 'documentNameId',
					fieldLabel: getCommonTranslation('DOCUMENT_NAME'),
					labelAlign: 'top',
					width: 536,
					height: 75,
					allowBlank : false
				}]
			} ]
		}, {
			xtype : 'fieldcontainer',
			layout : 'hbox',
			style:{'margin-top':'-22px !important'},
			defaults : {
				labelAlign : 'top',
				width: 256
			},
			items : [ {
				xtype : 'customcombobox',
				itemId : 'documentStatus',
				fieldLabel : getPersonModuleTranslation('STATUS'),
			    store: 'common.DocumentStatusCSMStore',
			    name: 'documentStatusCSM',
	            valueField: 'id',
	            displayField: 'value',
				editable : false,
				allowBlank : false
			},{
				xtype : 'radiogroup',
				itemId : 'inspectionDoneRadioGroupField',
				fieldLabel : getPersonModuleTranslation('INSPECTION_DONE'),
				labelWidth : 105,
				columns : 2,
				vertical : true,
				name : 'isInspectionDone',
				items : [ {
					itemId : 'isInspectionDoneYesField',
					boxLabel : getPersonModuleTranslation('YES'),
					name : 'isInspectionDone',
					inputValue : true
				}, {
					itemId : 'isInspectionDoneNoField',
					boxLabel : getPersonModuleTranslation('NO'),
					name : 'isInspectionDone',
					inputValue : false,
					checked : true
				} ]
			} ]
		}, {
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top',
				width: 256
			},
			items : [{
				xtype : 'datefield',
				itemId : 'inspectionDateField',
				fieldLabel : getPersonModuleTranslation('INSPECTED_DATE'),
				name : 'inspectionDate',
				allowBlank : false,
				disabled : true,
				listeners: {
	                render: function(obj) {
	                    obj = dateFormatRender(obj);
	                }
	            }
			}, {
				xtype : 'livesearchcombo',
				itemId : 'inspectionDoneByField',
				fieldLabel : getPersonModuleTranslation('INSPECTED_BY'),
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				name : 'inspectionDoneBy',
				allowBlank : false,
				disabled : true
			} ]
		},{
			xtype : 'fieldcontainer',
			layout : 'vbox',
			defaults : {
				labelAlign : 'top',
			},
			items: [{
		       xtype: 'textareafield',
		       name: 'documentNote',
		       itemId : 'documentNoteId',
		       fieldLabel: getCommonTranslation('NOTE'),
		       labelAlign: 'top',
		       width: 536,
		       height: 100,
		       maxLength: 500
		  },
		  {
	  		xtype: 'checkboxfield',
	  		name: 'visibleNoteOnPortal',
	  		boxLabel: getCommonTranslation('VISIBLE_NOTE_ON_PORTAL'),
	  		itemId:'visibleNoteOnPortal',
	  		inputValue : true,
	  		width: 536,
	  		style: {marginTop:'15px'},
	  		uncheckedValue: false
	  	}]
	}, {
		xtype:'fieldcontainer',
	   	width:'auto',
		layout : 'hbox',
		items: [{
				xtype : 'button',
				text : getCommonTranslation('SUBMIT'),
				itemId : 'documentFormSubmitButtonId',
				buttonAlign : 'right',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}, {
				xtype : 'button',
				buttonAlign : 'right',
				text : getCommonTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				itemId : 'documentCancelButtonId',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		}]
	}]

});
