/**
 * @author pritam.patil
 * this is used to add template form  
 */
Ext.define('Academia.view.documentmanagement.AddTemplateForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.addtemplateform',
    cls : 'panelNoSpace',
	autoScroll : true,
	defaults: {
		padding: 10
	},
	plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        name: 'templateId',
        itemId: 'template_hidden_id'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'configLevel',
            fieldLabel: getDocumentTranslation('DOCUMENT_CATEGORY'),
            itemId: 'document_category',
            editable: false,
            allowBlank: false,
            submitValue: false,
            displayField: 'value',
            valueField: 'name',
            queryMode: 'local',
            msgTarget: 'qtip',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.documentmanagement.DocumentCategorys');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'documentTypeId',
            fieldLabel: getDocumentTranslation('DOCUMENT_NAME'),
            itemId: 'document_type',
            allowBlank: false,
            editable: false,
            displayField: 'typeName',
            valueField: 'documentTypeId',
            queryMode: 'local',
            msgTarget: 'qtip',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.documentmanagement.DocumentTypes');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'textfield',
            name: 'templateName',
            allowBlank: false,
            fieldLabel: getDocumentTranslation('TEMPLATE_NAME'),
            itemId: 'template_name',
            msgTarget: 'qtip'
        },{
            xtype: 'checkboxfield',
            boxLabel: getCommonTranslation('IS_HINDI'), //Recurring
            name: 'isHindi',
            inputValue: 'true',
            uncheckedValue: 'false',
            itemId: 'isHindi',
            style:{
            	marginTop:'27px'
            }
        }]
    }, {
        xtype: 'radiogroup',
        vertical: true,
        hidden: true,
        name: 'templateType',
        items: [{
            xtype: 'radiofield',
            boxLabel: getDocumentTranslation('HTML'),
            name: 'templateType',
            itemId: 'htmlTypeTemplate',
            inputValue: 'HTMLTEMPLATE',
            checked: true
        }, {
            xtype: 'radiofield',
            boxLabel: getDocumentTranslation('JASPER'), //Alpha numeric
            name: 'templateType',
            inputValue: 'JASPERTEMPLATE',
            itemId: 'jasperTypeTemplate'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: 1150,
        autoScroll : false,
        items: [{
            xtype: 'ckeditor',
            itemId: 'templateCKEditor',		        
            autoHeight: true,
            submitValue: false,
            width: 700,
            height: 400,
            maxLength: 9999999,
            name: 'templateContent'
        }, {
        	xtype: 'tabpanel',
        	itemId: 'dynamicTemplateDataTab',
        	plain: true,
        	layout: 'fit',
        	border: true,
        	activeTab: 0,
        	padding: 0,
        	width: 400,
        	height:200,
        	items: [{
        		xtype: 'dynamictemplatedataform',
        		itemId: 'dynamicTemplateDataForm',
        		title: getDocumentTranslation('TEMPLATE_DATA'),
        		closable: false,
        		border: false,
        		cls: 'panelNoSpace'
        	}]
    	}]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            itemId: 'submitButtonId',
            text: getCommonTranslation('SUBMIT'), //Submit
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
//            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});