/**
 * @author Deepak S
 * 
 */
Ext.define('Academia.view.documentmanagement.DocumentTemplateMappingApplyToCommunityGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.documenttemplatemappingapplytocommunitygrid',
	store : 'documentmanagement.DocumentTemplateMappingApplyToCommunityGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	//autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'documentmanagement.DocumentTemplateMappingApplyToCommunityGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [{
		header:  getDocumentTranslation("COMMUNITY_LEVEL"),
		dataIndex: 'communityName',
		flex:1
	}]
});
