/**
 * @author pritam.patil
 * this form is used for Document Listing search form 
 */
Ext.define('Academia.view.documentmanagement.TemplateListSearchForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.templatelistsearchform',
   // frame: false,
    cls: 'customSearchPanel',
    plugins: "formlabelrequired",
   // padding: 10,
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'configLevel',
            fieldLabel: getDocumentTranslation('DOCUMENT_CATEGORY'),
            itemId: 'document_category',
            editable: false,
            allowBlank: false,
            displayField: 'value',
            valueField: 'name',
            queryMode: 'local',
            msgTarget: 'qtip',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.documentmanagement.DocumentCategorys');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'documentTypeId',
            fieldLabel: getDocumentTranslation('DOCUMENT_NAME'),
            itemId: 'document_type',
            allowBlank: false,
            editable: false,
            displayField: 'typeName',
            valueField: 'documentTypeId',
            queryMode: 'local',
            msgTarget: 'qtip',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.documentmanagement.DocumentTypes');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'textfield',
            name: 'templateName',
            fieldLabel: getDocumentTranslation('TEMPLATE_NAME'),
            itemId: 'template_type',
            msgTarget: 'qtip'
        }]
    }, {
        xtype: 'fieldcontainer',
     //   width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getDocumentTranslation('SEARCH'),
            itemId: 'searchButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getDocumentTranslation('RESET'),
            itemId: 'resetButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});