/**
 * @author Amit Gupta
 * 
 */
Ext.define('Academia.view.dynamicformrendering.DynamicFormRenderingSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.dynamicformrenderingsearch',  
	plugins : "formlabelrequired",
    //autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    //layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items :[{
                    	xtype: 'customcombobox',
                    	fieldLabel: getCommonTranslation('ACADEMYLOCATION'),
                    	name:'academyLocation',
                    	itemId: 'academyLocationId',
                    	store:'dynamicformrendering.DynamicFormAcademyLocation',
                    	displayField:'value',
                    	valueField: 'id',
                    	queryParam:'name',
        				minChars:3,
        				//hideTrigger:false,
        				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        				enableKeyEvents  : 'true',
        				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	            triggerAction: '',
        	            //typeAhead:true,
                    	allowBlank:false,
                    	forceSelection:true,
                    	listConfig: {
    						listeners: {
    							beforeshow: function(picker) {
    								picker.minWidth = picker.up('combobox').getSize().width;
    								picker.width = picker.up('combobox').getSize().width;
    							}
    						},
    						loadingText: getCommonTranslation('SEARCHING'),
    						emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    					}
                    }, {
                    	xtype: 'customcombobox',
                    	fieldLabel: getCommonTranslation('SCREENNAME'),
                    	name:'screenName',
                    	itemId: 'screenNameId',
                    	//store:'dynamicformrendering.ScreenNames',
                    	displayField: 'value',
                    	valueField: 'id',
                    	queryParam:'screenName',
        				minChars:3,
        				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        				enableKeyEvents  : 'true',
        				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	            triggerAction: 'all',
                    	forceSelection:true,
                        listeners: {
                            render: function(combo) {
                                var store = Ext.create('Academia.store.dynamicformrendering.ScreenNames');
                                combo.bindStore(store);
                            }
                        },
                        listConfig: {
    						listeners: {
    							beforeshow: function(picker) {
    								picker.minWidth = picker.up('combobox').getSize().width;
    								picker.width = picker.up('combobox').getSize().width;
    							}
    						},
    						loadingText: getCommonTranslation('SEARCHING'),
    						emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    					}
                    },{
                    	xtype: 'customcombobox',
                    	fieldLabel: getCommonTranslation('SCREENMODE'),
                    	name:'screenMode',
                    	itemId: 'ScreenMode',
                    	store:'dynamicformrendering.ScreenModes',
                    	displayField: 'value',
                    	valueField: 'id',
                    	typeAhead:true,
                    	disabled:true,
                    	forceSelection:true,
                    	editable:false
                    }]
				},{
		            xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
		                width: 256,
		                labelAlign: 'top'
		            },
		            items :[{
                    	xtype: 'customcombobox',
                    	fieldLabel: getCommonTranslation('LANGAUGE'),
                    	name:'langauge',
                    	itemId: 'langauge',
                    	store:'dynamicformrendering.DynamicFormLanguages',
                    	displayField: 'value',
                    	valueField: 'id',
                    	typeAhead:true,
                    	forceSelection:true,
                    	editable:false
                    }]
				},{
		            xtype: 'fieldcontainer',
		            width: 'auto',
		    		layout : {
		    			type : 'hbox'
		    		},
		    		cls: 'customSearchPanelBtnsFieldContainerCls',
		            items: [{
		                xtype: 'button',
		                text: getCommonTranslation('SEARCH'),
		                itemId: 'searcBtn',
		                buttonAlign: 'left',
		                ui: 'CustomBtnSubmit',
		                formBind:true,
		                scale: CONSTANTS.BUTTONSIZE
		            },{
		                xtype: 'button',
		                text: getCourseTxCommonTranslation('RESET'),
		                itemId: 'resetBtn',
		                buttonAlign: 'left',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
		        }]
    	//}]
});