/**
 * @author sachin.bangar
 * Education History Form 
 */
Ext.define('Academia.view.enquiry.Education.EducationDetailForm', {
    //extend:'Ext.window.Window',
    extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.educationdetailform',
    modal:true,
	height: '90%',
	width: '65%',
    autoScroll: true,
    cls:'horizontal-scrolling-fix',
    //title:getEnquiryTranslation('EXAMTITLE'),
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
		},
		standardSubmit: false,
    items: [{
        xtype: 'hidden',
        itemId: 'education_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
    	xtype:'hidden',
    	name:'marksOrGradeObtained'
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype: 'nestedJsonCombo',
            itemId: 'examPassed',
            fieldLabel: getEnquiryTranslation('EXAM_PASSED'),
            store: 'common.ExamPassedStore',
            valueField: 'id',
            displayField: 'value',
            name: 'examPassed',
            editable : true,
            allowBlank:false,
            minChars:3,
			typeAhead:true,
            hideTrigger:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: 'all',
            forceSelection:false
        },{
        	 xtype: 'textfield',
             fieldLabel: getEnquiryTranslation('EXAM_CONDUCTED_BY_COLLAGE'),
             name: 'examConductedBy',
             allowBlank:false,
             width: 536,
             itemId: 'examConductedById'
        }]
    },{
    	 xtype: 'fieldcontainer',
         layout: 'hbox',
         defaults: {
             labelAlign: 'top',
             width: 256
         },
         items: [{
         	 xtype: 'textfield',
              fieldLabel: getEnquiryTranslation('INSTITUTE_NAME'),
              name: 'instituteName',
              allowBlank:false,
              width: 536,
              itemId: 'instituteNameId'
         },{
        	 xtype: 'nestedJsonCombo',
             itemId: 'studyMode',
             fieldLabel: getEnquiryTranslation('MODE_OF_STUDY'),
             store: 'admission.applications.history.StudyModes',
             valueField: 'id',
             displayField: 'value',
             name: 'studyMode',
             editable : false
         }]
    },{
     	 xtype: 'fieldcontainer',
         layout: 'hbox',
         defaults: {
             labelAlign: 'top',
             width: 256
         },
         items: [{
        	 xtype: 'datefield',
        	 name: 'yearOfExam',
        	 itemId:'yearOfExam',
        	 vtype: 'daterange',
        	 editable:false,
        	 fieldLabel: getCommonTranslation('DATE_OF_EXAM'),
        	listeners: {
       		 render: function(field) {
       			 return dateFormatRender(field);
       		 }
       	 }
         },{
             xtype: 'customcombobox',
             fieldLabel: getCommonTranslation('MONTH_OF_EXAM'),
             name: 'monthOfExamination',
             itemId: 'monthItemId',
             editable: false,
             store: Ext.create('Academia.store.personinfo.common.pasthistory.ApplicantEducationMonthStore'),
             displayField: 'value',
             valueField: 'code',
             queryMode: 'local',
             labelAlign: 'top',
             width: 256
     },{
         xtype: 'customcombobox',
         fieldLabel: getCommonTranslation('YEAR_OF_EXAM'),
         name: 'yearOfExamination',
         itemId: 'yearItemId',
         editable: false,
         store: Ext.create('Academia.store.personinfo.common.pasthistory.ApplicantEducationYearStore'),
         displayField: 'value',
         valueField: 'id',
         queryMode: 'local',
         labelAlign: 'top',
         width: 256
     }]
     }, {
         xtype: 'fieldcontainer',
         layout: 'hbox',
         itemId:'marksgradecontainerId',
         defaults: {
             labelAlign: 'top',
             width: 256,
         },
         items: [{
             xtype: 'customcombobox',
             itemId: 'gradeMark',
             store: 'admission.applications.history.EducationGradAndMarks',
             fieldLabel: getEnquiryTranslation('GRADE_MARKS'),
             name: 'gradeMark',
             valueField: 'id',
             displayField: 'value',
             editable : false
         }, {
             xtype: 'textfield',
             fieldLabel: getEnquiryTranslation('GRADE_OBTAINED'),
             itemId: 'gradeObtained',
             name: 'gradeObtained'
         },{
         	 xtype: 'numberfield',
              fieldLabel: getEnquiryTranslation('MARKS_OBTAINED'),
              itemId: 'marksObtained',
              name: 'marksObtained',
              hidden:true,
              //width: 109,
              keyNavEnabled: false,
              mouseWheelEnabled: false,
              hideTrigger: true,
              minValue:0
         },{
         	 xtype: 'numberfield',
              fieldLabel: getEnquiryTranslation('MAXIMUM_MARKS'),
              itemId: 'maximumMarks',
              name: 'maximumMarks',
              hidden:true,
              width: 108,
              keyNavEnabled: false,
              mouseWheelEnabled: false,
              hideTrigger: true,
              minValue:0,
              listeners: {
             	 change: function(obj, eOpts) {
             		 this.previousSibling().setMaxValue(obj.getValue());
             		 this.previousSibling().validate();
             	 }
              }
         }, {
         	 xtype: 'numberfield',
         	 fieldLabel: getEnquiryTranslation('GPA_PERCENTAGE'),
              itemId: 'percentage',
              name: 'percentage',
              hideTrigger: true,
              keyNavEnabled: false,
              mouseWheelEnabled: false,
              minValue:0
         }]
     },{
    	 xtype: 'fieldcontainer',
         layout: 'hbox',
         defaults: {
             labelAlign: 'top',
             width: 256
         },
         items: [{
        	 xtype: 'textfield',
             fieldLabel: getEnquiryTranslation('SPECIALIZATION'),
             itemId: 'specialization',
             name: 'specialization'
         },{
             xtype: 'nestedJsonCombo',
             fieldLabel: getEnquiryTranslation('RESULT_STATUS'),
             itemId:'resultStatusId',
             store:'admission.applications.history.ResultStatus',
             name: 'resultStatus',
             editable : false,
             allowBlank:false,
             displayField:'value',
     		 valueField:'id'
     		 
         }]
    }, {
        xtype: 'panel',
        itemId: 'subjectMarkPanel',
       // margin: '0px',
        autoScroll:true,
        style:{
        	marginLeft:'0px !important'
        },
        items: [{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox',
                align: 'bottom'
            },
            items: [{
                xtype: 'hidden',
                itemId: 'subjectId',
                name: 'subjectId'
            }, {
                xtype: 'hidden',
                itemId: 'subjectVersion',
                name: 'subjectVersion'
            }, {
                xtype: 'nestedJsonCombo',
                itemId: 'subject',
                fieldLabel: getPersonModuleTranslation('SUBJECT'),
                labelAlign: 'top',
                width: 256,
                store: 'common.SubjectTypeStore',
                valueField: 'id',
                displayField: 'value',
                name: 'subject',
                editable : false,
                rowIndx:0
            },{
            	xtype: 'numberfield',
            	fieldLabel: getPersonModuleTranslation('MAXIMUM_MARKS'),
            	labelAlign: 'top',
            	itemId: 'subMaximumMarks',
            	name: 'subMaximumMarks',
            	disabled: true,
            	width: 113,
            	maxLength:5,
            	keyNavEnabled: false,
            	mouseWheelEnabled: false,
            	hideTrigger: true,
            	minValue:0,
            	validator: function(value){
                	var res = true;
                	var maxMarkvalidText = null;
                	if(!this.nextSibling().isHidden()){
                		if(!isNullOrEmpty(this.nextSibling().getValue())){
                			if(!isNullOrEmpty(this.getValue())){
                				if(this.getValue()<this.nextSibling().getValue()){
                				    maxMarkvalidText = getCommonTranslation('MAXIMUM_MARK_MARKS_OBTAINED_VALIDATION');
                				    res = false;
                				}	
                			}
            			}
                        if(res) {
                            return true;
                        } else {
                        	if(!isNullOrEmpty(maxMarkvalidText)){
                        		return maxMarkvalidText;	
                        	}
                        }
                	}else{
                		return true;
                	}
                }
            }, {
                xtype: 'textfield',
                itemId: 'marks',
                name:'marks',
                fieldLabel: getPersonModuleTranslation('MARKS_GRADE'),
                labelAlign: 'top',
                width: 256,
                disabled: true,
                allowBlank:false,
                name: 'marks',
                maxLength:7,
                decimalPrecision:2,
                validator: function(value){
                	var validText = getPersonModuleTranslation('MARKS_GRADE_VALID_TYPE');
                	var patt = new RegExp('(^[A-Z]{1}[+]{1}$)|(^[A-Z]{1}[+]{2}$)|(^[A-Z]{1}[-]{1}$)|(^[A-Z]{1}[-]{2}$)|(^[A-Z]{1}[0-9]{1}$)|(^[A-Z]{1}$)|(^[0-9]{1,3}$)|(^[0-9]{1,3}[\.]{1}[0-9]{1,5}$)');
                	var res = patt.test(value);
                	var maxMarkvalidText = null;
                	if(!this.previousSibling().isHidden()){
                		if(!isNullOrEmpty(this.previousSibling().getValue())){
                			if(!isNullOrEmpty(this.getValue())){
                				if(this.getValue()>this.previousSibling().getValue()){
                				    maxMarkvalidText = getCommonTranslation('MAXIMUM_MARK_MARKS_OBTAINED_VALIDATION');
                				    res = false;
                				}	
                			}
            			}
                	}
                    if(res) {
                        return true;
                    } else {
                    	if(!isNullOrEmpty(maxMarkvalidText)){
                    		return maxMarkvalidText;	
                    	}else{
                    		return validText;
                    	}
                    }
                }
            }, {
        		xtype : 'button',
        		itemId: 'btnDeleteSubjectMarks0',
        		glyph: ICONGLYPH.DELETEGLYPH,
	   			cls: 'CustomBodyBtnReject',
	   			tooltip: getCommonTranslation('DELETETOOLTIP')
        	}, {
        		xtype : 'button',
        		itemId: 'btnAddSubjectMarks0',
        		cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD')
        	}]
        }]
    }, {
    	xtype:'panel',
    	style:{
        	marginLeft:'0px !important',
        	marginTop:'-10px !important'
        },
    	items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 536
        },
        items: [{
            xtype: 'textarea',
            fieldLabel: getPersonModuleTranslation('REMARKS'),
            name: 'remarks'
        }]
    	 }]
    }, {
        xtype: 'fieldcontainer',
       // width: '100%',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'EdusubmitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
	}]
});
