Ext.define('Academia.view.enquiry.EnquiryForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	customFieldEntity:CONSTANTS.ENQUIRY_RAISE_CF_DATA,
	columns: 1,
	title: getCommonTranslation('ENQUIRY_FORM_TITLE'),
	alias: 'widget.enquiryform',
	autoScroll: true,
	frame: true,
	method: 'POST',
	standardSubmit: false,
	plugins : "formlabelrequired",
	layout:'anchor',
	cls:'horizontalScrollingFixed', 
	defaults: {
		width: 256,
		labelAlign: 'top',
		tdAttrs: { style: 'padding: 5px;' }
	},
	items: [{
		xtype: 'hidden',
		name: 'id'
	},{
		xtype: 'hidden',
		name: 'status',
		value:'O'
	},{	
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'textfield',
			readOnly:true,
			name: 'users',
			fieldLabel: getCommonTranslation('ENQUIRY_CREATED_BY') 

		},{
			xtype: 'datefield',
			name: 'enquiryDate',
			//--submitFormat: 'd-m-Y',
			itemId:'enquiryDateItemId',
			fieldLabel: getCommonTranslation('ENQUIRY_DATE'),
//			value: new Date(),
			maxValue:new Date(),
			allowBlank:false,
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}

		},{
			xtype: 'customcombobox',
			name: 'enquiryType',
			allowBlank:false,
			store: 'enquiry.EnquiryTypeStore',
			fieldLabel: getCommonTranslation('ENQUIRY_TYPE_1'),
			valueField: 'id',
			displayField: 'enquiryTypeName',
			itemId: 'enquiryTypeCombo',
			typeAhead:true,
			forceSelection:true
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'enquirySource',
			minChars:3,
			fieldLabel: getCommonTranslation('ENQUIRY_SOURCE'),
			store: 'enquiry.EnquirySourceStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'campaign',
			fieldLabel: getCommonTranslation('ENQUIRY_CAMPAIGN_NAME'),
			store: 'campaign.CampaignComboStore',
			typeAhead: true, 
			minChars: 3,
			valueField: 'id',
			displayField: 'value',
			forceSelection:true
		}]
	},{	
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'referredType',
			allowBlank:false,
			store: 'enquiry.ReferredTypeStore',
			fieldLabel: getCommonTranslation('REFERRER_TYPE'),
			valueField: 'id',
			displayField: 'value',
			itemId: 'referredType',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'referrerName',
			itemId:'referrerName',
			fieldLabel: getCommonTranslation('REFERRER_NAME'),
			hidden:true,
			store: 'enquiry.ReferredIdStore',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			editable:true,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
			xtype: 'textfield',
			name: 'refUserName',
			fieldLabel: getCommonTranslation('REFERRER_NAME'),
			allowBlank:true,
			disabled:true
		}]   
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top',
			regex: /[a-zA-Z0-9]+/
		},
		items:[{
			xtype: 'customcombobox',
			name: 'registeredBy',
			itemId: 'registeredBy',
			fieldLabel: getCommonTranslation('ENQUIRY_REGISTERED_BY'),
			store: 'enquiry.EnquiryRegisteredBy',
			allowBlank:false,
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		}, {
			xtype: 'customcombobox',
			name: 'enqRegByStudent',
			itemId:'enqRegByStudent',
			fieldLabel: getCommonTranslation('STUDENT_CODE_NAME'),
			hidden:true,
			store: 'enquiry.ReferredStudentId',
			valueField: 'studentId',
			displayField: 'printName',
			queryParam:'name',
			minChars:3,
			editable:true,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,  
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{printName}' +
					'</div>';
				}
			}
		}, {
			xtype: 'textfield',
			name: 'enqRegByStudentUserName',
			fieldLabel: getCommonTranslation('STUDENT_NAME'),
			allowBlank:true,
			disabled:true
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top',
			//regex: /[a-zA-Z0-9]+/
		},
		items:[{
			xtype: 'textfield',
			name: 'enquirerFirstName',
			fieldLabel: getCommonTranslation('ENQUIRER_FIRST_NAME'),
			allowBlank:false,
			maxLength:100,
			maskRe:/^[a-zA-Z]+$/,
			enforceMaxLength : true
		},{
			xtype: 'textfield',
			name: 'enquirerMiddleName',
			fieldLabel: getCommonTranslation('ENQUIRER_MIDDLE_NAME'),
			maxLength:53,
			maskRe:/^[a-zA-Z]+$/,
			enforceMaxLength : true

		},{
			xtype: 'textfield',
			name: 'enquirerLastName',
			fieldLabel: getCommonTranslation('ENQUIRER_LAST_NAME'),
			//allowBlank:false,
			maxLength:100,
			maskRe:/^[a-zA-Z]+$/,
			enforceMaxLength : true
		}]  

	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top',
			regex: /[a-zA-Z0-9]+/
		},
		items:[{
			xtype: 'textfield',
			name: 'companyName',
			fieldLabel: getCommonTranslation('COMPANY_NAME'),
			allowBlank:true, // if entered not allow blank
			hidden:true
		},{
			xtype: 'textfield',
			name: 'contactPerson',
			fieldLabel: getCommonTranslation('ENQUIRY_CONTACT_PERSON'),
			hidden:true

		},{
			xtype: 'numberfield',
			name: 'totalSeats',
			fieldLabel: getCommonTranslation('ENQUIRY_TOTAL_SEAT'),
			hideTrigger:true,
			mouseWheelEnabled:false,
			allowDecimals:false,
			allowExponential:false,
			maxLength:3,
			allowBlank:true, // if entered not allow blank
			hidden:true
		}]  

	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name : 'country',
			itemId:'country',
//			allowBlank:false,
			fieldLabel: getCommonTranslation('ADDRESS_COUNTRY'),
			store:'common.CountryStoreSmartSearch',
			valueField : 'id',
			displayField : 'countryName',
			queryParam:'countryName',
			minChars:3,
			typeAhead:true,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{countryName}' +
					'</div>';
				}
			}
		},{
    		xtype : 'customcombobox',
    		fieldLabel : getCommonTranslation('COUNTRY_REGION'),
//    		name : 'genericField1',
    		itemId : 'genericFieldId1',
    		store:'organization.CountryRegionStore',
    		valueField : 'id',
    		displayField : 'countryRegionName',
    		name : 'parentCountryRegion',
    		//editable : false,
    		valueNotFoundText:"",        		        						
			forceSelection :true,
			allowBlank:false,
			typeAhead : true,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{countryRegionName}'  +
	                    '</div>';
	                }
	            }
    	},{
			xtype: 'customcombobox',
			name : 'city',
			itemId : 'city',
			allowBlank:false,
			fieldLabel: getCommonTranslation('ADDRESS_CITY'),
//			store:'organization.CityStore',
			store:'organization.CityByCountryRegion',
			valueField : 'id',
//			displayField : 'cityName',
			displayField : 'value',
			typeAhead:true,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{cityName}' +
					'</div>';
				}
			}
		}]
	},{   
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',  
			fieldLabel: getCommonTranslation('COUNTRY_CODE'),
			valueField: 'isdCode',
			displayField: 'isdCode',
			store: 'common.CountryStore',
			triggerAction: 'all',
			name: 'cellCountrycode',
			itemId:'cellCountryCode',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'numberfield',
			name: 'cellNumber',
			itemId:'cellNumber',
			fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
			minLength: 6,
			maxLength: 11,
			allowBlank:false,
			hideTrigger:true,
			mouseWheelEnabled:false,
			maxLength:11,
			enforceMaxLength : true,
			//allowDecimals : false,
		//	regex:new RegExp('^\\d{1}[.05]*$')
			//regex:new RegExp('^\\d{1,}[.05]*$')
		//regexText: 'decimal are not allowed'
		},{
			xtype: 'textfield',
			name: 'regdEmail',
			itemId:'regdEmail',
			fieldLabel: getCommonTranslation('EMAIL'),
			vtype:'email',
			allowBlank:false,
			maxLength:100,
			enforceMaxLength : true
		}]  
	},{   
		xtype: 'fieldcontainer',
		width: '100%',
		//fieldLabel: getCommonTranslation('OTHER_CONTACT'),
		itemId:'otherContactId',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign: 'top'
		},

		items: [{
			xtype: 'customcombobox',
			valueField: 'isdCode',
			displayField: 'isdCode',
			fieldLabel: getCommonTranslation('OTHER_CONTACT'),
			store: 'common.CountryStore',
			itemId:'phoneCountryCode',
			triggerAction: 'all',
			name: 'phoneCountryCode',
			width: 100,
			typeAhead:true,
			forceSelection:true

		}, {
			xtype: 'numberfield',
			name: 'areaCode',
			store: 'common.CountryStore',
			width: 115 ,//Do not put in defaults for IE
			minLength: 2,
			//allowBlank:false,
			hideTrigger:true,
			mouseWheelEnabled:false,
			maxLength:5,
			enforceMaxLength : true,
			//regex:new RegExp('^\\d{1}[.05]*$'),

			style:{
				marginTop:'27px'
			}
		},{
			xtype: 'numberfield',
			name: 'regdPhoneNo',
			itemId : 'regdPhoneNo',
			minLength: 7,
			//allowBlank:false,
			hideTrigger:true,
			mouseWheelEnabled:false,
			maxLength:15,
			enforceMaxLength : true,
			//allowDecimals : false,
			//regex:new RegExp('^\\d{1}[.05]*$'),

			style:{
				marginTop:'27px'
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'followUpUser',
			store: 'enquiry.FollowUpUserWithDepartment',
			fieldLabel: getCommonTranslation('FOLLOW_UP_USER'),
			valueField: 'id',
			displayField: 'value',
			itemId:'followUpUser',
			queryParam:'name',
			minChars:3,
			editable:true,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'+
					'</div>';
				}
			}
		},{
			xtype: 'datefield',
			name: 'followUpDate',
			//--submitFormat: 'd-m-Y',
			minValue:new Date(),
			itemId:'followUpDateItemId',
			fieldLabel: getCommonTranslation('FOLLOW_UP_DATE'),
//			value: new Date(),
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}
		}]
	},{
		xtype: 'textareafield',
		labelAlign: 'top',
		name: 'remark',
		width:CONSTANTS.DEFAULT_TEXTAREA_SIZE,
		fieldLabel: getCommonTranslation('ENQUIRY_REMARKS'),
		maxLength:255,
		enforceMaxLength : true
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype:'panel',
			cls: 'panelNoSpace',
			items:[{
				xtype: 'radiogroup',
				name: 'retainEnquiryInformation',
				labelAlign: 'top',
				columns: 2,
				vertical: true,
				itemId:'RetainForm_radioBtn',
				id:'enquiryform _retainform',
				fieldLabel : getCommonTranslation('RETAIN_ENQUIRY_INFORMATION'),
				items:[
				       { boxLabel: getCommonTranslation('YES'), name: 'radio', inputValue: 1},
				       { boxLabel: getCommonTranslation('NO'), name: 'radio', inputValue: 2,checked:true}
				       ]
			}]

		}]
	}, {
		xtype: 'panel',
		width:'100%',
		cls: 'panelNoSpace',
		items: [{
			xtype : 'enquirygrid',
			margin: '8 0 25 0'
		}]
	}, {
		xtype:'fieldcontainer',
		width:'auto',
		layout: {
			type: 'hbox'
		},
		items: [{

			xtype: 'button',
			action: 'Submit',
			text: getCommonTranslation('SAVE'),
			formBind: true,
			itemId: 'enquiryform_submitbuttonId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId:'enquiryform_cancelbuttonId',
			scale: CONSTANTS.BUTTONSIZE

		},{
			xtype: 'button',
			text: getCommonTranslation('VIEW_PAST_RECORD'),
			itemId: 'viewPastRecord',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			hidden:true
		}]
	}]
});
