/**
 * @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.view.enquiry.Reports.summaryreport.SummaryReportGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.summaryreportgrid',
    store : 'enquiry.reports.SummaryReportForPBST',
	title : getEnquiryTranslation('ENQUIRY_STUDENT_DETAILS'),
	border : true,
	autoScroll : true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
		    store : 'enquiry.reports.SummaryReportForPBST',
		    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
		    displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	columns : [/*{
				hidden:true,
				dataIndex:'id'
			},*/{
				header : getEnquiryTranslation('ENQUIRY_TYPE_1'),
				dataIndex : 'enquiryType',
				flex : 1,
				sortable : true	
			},{
				header : getEnquiryTranslation('NO_OF_ENQUIRIES_RECIEVED'),
				dataIndex : 'noOfEnquiryReceived', //noOfEnqRceived
				flex : 1,
				sortable : true,
				renderer:function(val){
					if(val>0){
						return '<a href=#>'+val+'</a>';						
					}else{
						return '0';
					}
				}
			}, {
			    header : getEnquiryTranslation('NO_OF_ENQUIRIES_CLOSED_SUCCESFULLY'),
			    dataIndex : 'noOfEnquiriesClosedSuccesfully',
			    flex : 1,
			    sortable : true,
				renderer:function(val){
					if(val>0){
						return '<a href=#>'+val+'</a>';						
					}else{
						return '0';
					}
				}
			}, {
			    header : getEnquiryTranslation('NO_OF_ENQUIRIES_CLOSED_UNSUCCESFULLY'),
			    dataIndex : 'noOfEnquiriesClosedUnsuccesfully',
			    flex : 1,
			    sortable : true,
				renderer:function(val){
					if(val>0){
						return '<a href=#>'+val+'</a>';						
					}else{
						return '0';
					}
				}
			}, {
			    header : getEnquiryTranslation('NO_OF_PENDING_ENQUIRIES'),
			    dataIndex : 'noOfPendingEnquiry',
			    flex : 1,
			    sortable : true,
				renderer:function(val){
					if(val>0){
						return '<a href=#>'+val+'</a>';						
					}else{
						return '0';
					}
				}
			},{
			    header : getEnquiryTranslation('TOTAL_NO_OF_FOLLOW_UP'),
			    dataIndex : 'totalNoOfFollowup',
			    flex : 1,
			    sortable : true
			}]
});