/**
 * @author Rajkumar
 * @author seshagiri
 */
Ext.define('Academia.view.enquiry.TrackEnquiryForm', {   
	//extend : 'Ext.form.Panel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias : 'widget.trackenquiryform',
	frame: false,
	cls:'customSearchPanel',
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
		},
		items: [{
		    xtype: 'radiogroup',
		    itemId: 'showEnquiriewByTypeItemId',
		    hidden: true,
		    items: [{
		        boxLabel: getEnquiryTranslation('ME_MY_ENQUIRIES'),
		        name: 'showEnquiriewByType',
		        inputValue: 'MY_ENQUIRIES',
		        checked: true

		    },{
		        boxLabel: getEnquiryTranslation('ME_ALL_ENQUIRIES'),
		        name: 'showEnquiriewByType',
		        inputValue: 'ALL_ENQUIRIES'
		    }]
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[
		       {
			xtype: 'customcombobox',
			name:'enquiryCode',
			itemId:'trackEnquiry_enquiryCode',
//			store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
			store:'enquiry.EnquiryCodeSearchStore',
			fieldLabel:getEnquiryTranslation('ENQUIRY_ID_OR_STUDENT_NAME'),
			width: 256,
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:5,
			typeAhead:false,
            hideTrigger:true,
            emptyText: 'Enter 5 char to auto search ',
            triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'  +
	                    '</div>';
	                }
	            }
		}/*{
			xtype: 'textfield',
			name: 'code',
			hidden:true,
			//name:'enquiryNo',
			fieldLabel:getEnquiryTranslation('TRACK_ENQUIRY_NO'),
			itemId:'trackEnquiry_enquiryNo'
		}*//*,{
			xtype: 'textfield',
			name: 'enquiryCode',
			//name:'enquiryNo',
			fieldLabel:getEnquiryTranslation('TRACK_ENQUIRY_NO'),
			itemId:'trackEnquiry_enquiryCode'
		}*/,{
			xtype: 'customcombobox',
			name: 'enquiryType',
			fieldLabel:getEnquiryTranslation('ENQUIRY_TYPE'),
			store: 'enquiry.EnquiryTypeStore',
			valueField: 'id',
			displayField: 'enquiryTypeName',
			itemId: 'trackEnquiry_enquiryType',
			typeAhead:true,
			forceSelection:true,
			allowBlank:false,
			editable: false,
		},{		
			xtype: 'customcombobox',	               
			name: 'intermediateType',
			itemId:'trackEnquiry_intermediateType',
			editable: false,
			fieldLabel: getEnquiryTranslation('INTERMEDIATE_STAGE'),
			store:'enquiry.EnqIntermediateType',
			displayField: 'value',
			valueField: 'id',
			typeAhead:true,
			forceSelection:true
		}]
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		style: {
			//marginTop: '40px!important',
			marginLeft:'-0px !important'
		},
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name:'enquiryFirstName',
			itemId:'trackEnquiry_enquiryFirstName',
			store:'enquiry.EnquirerSmartSearchStore',
			fieldLabel:getEnquiryTranslation('TRACK_ENQUIRER_NAME'),
			width: 256,
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
            hideTrigger:true,
            emptyText: 'Enter 3 char to auto search ',
            triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
		},{
			xtype: 'datefield',
			name:'dateFrom',
			itemId:'trackEnquiry_dateFrom',
			fieldLabel:getEnquiryTranslation('TRACK_ENQUIRY_DATE_FROM'),
			vtype: 'daterange',
			endDateField: 'trackEnquiry_enquiryDateTo',
			listeners: {
				render: function(field) {
				var obj = dateFormatRender(field);
                 var c = "04/01/" + (new Date().getFullYear());
                 obj.setValue(new Date(c))

		         return obj;
				}
			},
			
			
		},{
			xtype: 'datefield',
			name:'enquiryDateto',
			itemId:'trackEnquiry_enquiryDateTo',
			fieldLabel:getEnquiryTranslation('TRACK_ENQUIRY_DATE_TO'),
			vtype: 'daterange',
			startDateField: 'trackEnquiry_dateFrom',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			
		}]  
	},{ 
		xtype:'fieldset',
		title:getEnquiryTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		//width:'100%',
		cls: 'spaceIssueForFields',
		items:[{						
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
				name:'academyLocation',
				itemId:'academyLocationCombo',
				store: 'user.UserAcademyLocationStore',
				displayField: 'value',
				valueField: 'id',
				width: 536,
//				typeAhead : true,
				queryParam:'qry',
//				forceSelection:true,
//				hideTrigger:false,
//				triggerAction: 'all',
				minChars:3,
			//	queryMode: 'local',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			},{
				 xtype: 'customcombobox',
				 name: 'enquiryOwner',
				 store: 'enquiry.FollowUpUserWithDepartment',
				 fieldLabel: getEnquiryTranslation('ENQUIRY_OWNER'),
				 valueField: 'id',
				 displayField: 'value',
				 itemId:'enquiryOwner',
				 queryParam:'name',
				 minChars:3,
				 editable:true,
				 typeAhead:true,
				 triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				 enableKeyEvents  : 'true',
				 hideTrigger:false,
				 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				 triggerAction: '',
				 forceSelection:true,
				 allowBlank:true,
				 listConfig: {
					 listeners: {
						 beforeshow: function(picker) {
							 picker.minWidth = picker.up('combobox').getSize().width;
						 }
					 },
					 loadingText: getCommonTranslation('SEARCHING'),
					 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					 getInnerTpl: function() {
						 return '<div class="search-item">' +
						 '{value}'+
						 '</div>';
					 }
				 }
			 	},{
					xtype : 'customcombobox',
					fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
					name : 'intakeYear',
					itemId : 'intakeYear',
					displayField:'value',
					valueField:'id',
					width: 256,
					//typeAhead:true,
					forceSelection:true,
		            editable: false,
					//minChars:3,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}'  +
							'</div>';
						}
					},
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.common.IntakeYearStore');
							combo.bindStore(store)
						}
					}
			 	}/*{
				xtype: 'textfield',
				name:'enquiryFirstName',
				fieldLabel:getEnquiryTranslation('TRACK_ENQUIRER_NAME'),
				itemId:'trackEnquiry_enquiryFirstName'
			}*/]  
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
		 		xtype: 'customcombobox',
		 		fieldLabel: getAdmissionTranslation('PROGRAM_GROUP'),
		 		name: 'programGroup',
		 		itemId: 'programGroup',
		 		editable: false,
		 		store: 'admission.applicationFormSale.ProgramGroupComboStore',
		 		valueField: 'id',
		 		displayField: 'value'			 	
		 	}, {
			    xtype: 'customcombobox',
			    name: 'programId',
			    itemId:'programId',
			    fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			    displayField:'valueCode',
			    valueField:'id',
			    typeAhead:true,
			    disabled:true,
			    store: Ext.create('Academia.store.program.ProgramByGroupIdStore'),
			    //forceSelection:true,
			    minChars:3,
                queryParam:'qry',
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
                /*listeners: {
                    render: function(combo) {
                    	var store = Ext.create('Academia.store.program.ProgramByGroupIdStore');
                        combo.bindStore(store);
                    }
                },*/
                    listConfig: {
    	 				listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	 				loadingText: getCommonTranslation('SEARCHING'),
    	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	 				getInnerTpl: function() {
    	 					return '<div class="search-item">' +
    	 					'{code} / {value}'+ 
    	 					'</div>';
    	 				}
    	 			}
			},{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'batchId',
				fieldLabel: getEnquiryTranslation('BATCH'),
				store: Ext.create('Academia.store.enquiry.AcademicBatchStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				disabled:true,
				forceSelection:true
			},{
			    xtype: 'customcombobox',
			    name: 'seatTypeId',
			    itemId:'seatTypeId',
			    disabled:true,
			    fieldLabel: getEnquiryTranslation('SEAT_TYPE'),
			    store: Ext.create('Academia.store.enquiry.ProgramBatchSeatTypeStore'),
			    valueField: 'id',
			    displayField: 'value',
			    typeAhead:true,
			    forceSelection:true
			}]  
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'email',
				itemId:'trackEnquiry_email',
				fieldLabel: getEnquiryTranslation('EMAIL'),
				vtype:'email'
			},{
				xtype: 'numberfield',
				name: 'MobileNo',
				itemId : 'trackEnquiry_mobileNo',
				fieldLabel: getEnquiryTranslation('ADDRESS_MOBILE_NO'),
				minLength: 6,
				maxLength: 11,
				minValue:0,
				hideTrigger:true 
			},{
				xtype: 'textfield',
				name: 'companyName',
				fieldLabel: getEnquiryTranslation('COMPANY_NAME'),
				itemId:'trackEnquiry_companyName',
				hidden:true,
				regex: /[a-zA-Z0-9]+/
			},{
				xtype: 'textfield',
				name: 'contactPerson',
				fieldLabel: getEnquiryTranslation('ENQUIRY_CONTACT_PERSON'),
				itemId:'trackEnquiry_contactPerson',
				hidden:true,
				regex: /[a-zA-Z0-9]+/

			}]
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'numberfield',
				name: 'alternateMobileNo',
				itemId : 'trackEnquiry_alternateMobileNo',//trackEnquiry_alternateMobileNo
				fieldLabel: getCommonTranslation('ALTERNATE_MOBILE_NO'),
				minLength:5,
				minValue:0,
				hideTrigger:true 
			},{
				xtype: 'customcombobox',
				name: 'followUpUser',
				store: 'enquiry.FollowUpUserWithDepartment',
				fieldLabel: getEnquiryTranslation('FOLLOW_UP_USER'),
				valueField: 'id',
				displayField: 'value',
				itemId:'followUpUser',
				queryParam:'name',
				minChars:3,
				editable:true,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'+
						'</div>';
					}
				}
			},{
				xtype: 'numberfield',
				name:'followUpNumber',
				itemId:'trackEnquiry_followUpNumber',
				fieldLabel: getEnquiryTranslation('NO_OF_FOLLOWUPS'),
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				hideTrigger: true
			},{
				xtype: 'customcombobox',
				name: 'enquiryStatus',
				itemId:'trackEnquiry_enquiryStatus',
				fieldLabel: getEnquiryTranslation('TRACK_ENQUIRY_STATUS'),
				valueField: 'id',
				displayField: 'value',
				typeAhead: true,
				forceSelection: true,
				store: {
					fields: ['text', 'value', 'code'],
					data : [
					        {"id":"O", "value":"Open", "code": "O"},
					        {"id":"C", "value":"Closed", "code": "C"},
//					        {"id":"M", "value":"Marketing", "code": "M"}
					        ]
				}
			}]  
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name:'campaignName',
				itemId:'trackEnquiry_capaignName',
				store: Ext.create('Academia.store.campaign.CampaignCodeOrNameSmartSearch'),
				fieldLabel: getEnquiryTranslation('TRACK_ENQUIRY_CAMPAIGN_NAME'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'codeOrName',
				minChars:3,
				typeAhead:true,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				regex : /^[a-zA-Z0-9%\-\/\\\s]+$/,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'  +
						'</div>';
					}
				}
			}, {
				xtype: 'customcombobox',
				name: 'enquirySource',
				itemId: 'enquirySourceId',
				minChars:3,
				fieldLabel: getEnquiryTranslation('ENQUIRY_SOURCE'),
				store: 'enquiry.EnquirySourceStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'referredType',
				itemId:'trackEnquiry_referredType',
				store: Ext.create('Academia.store.enquiry.ReferredTypeStore'),
				fieldLabel: getEnquiryTranslation('REFERRER_TYPE'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'countryFilter',
				fieldLabel: getCommonTranslation('ADDRESS_COUNTRY'),
				store: 'common.CountryStore',
				valueField: 'id',
				displayField: 'countryName',
				itemId: 'countryFilterId',
				editable:false,
				forceSelection:true

			}]  
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('COUNTRY_REGION'),
				name : 'countryRegionFilter',
				itemId : 'countryRegionFilterId',
				store:Ext.create('Academia.store.organization.CountryRegionStore'),
				valueField : 'id',
				displayField : 'countryRegionName',
				editable : false,
				valueNotFoundText:"",        		        						
				forceSelection :true,
				disabled:true
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('ADDRESS_CITY'),
				name: 'cityFilter',
				editable: false,
				itemId: 'cityFilterId',
				store: Ext.create('Academia.store.organization.CityByCountryRegion'),
				valueField: 'id',
				displayField: 'value',
				disabled:true
			}, {
				xtype: 'customcombobox',	               
				name: 'priority',
				itemId:'trackEnquiry_priority',
				fieldLabel: getEnquiryTranslation('PRIORITY'),
				store:'enquiry.Priority',
				displayField: 'value',
				valueField: 'id',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'modeofDelivery',
				itemId: 'modeDeliveryId',
				fieldLabel: getCommonTranslation('MODE_OF_DELIVERY'),
				store: 'common.ModeOfDeliveryStore',
				
				valueField: 'id',
				displayField: 'value',
				//editable: false,
				forceSelection: true
			}]  
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'registrationType',
				itemId: 'registrationTypeId',
				fieldLabel: getCommonTranslation('REGISTRATION_TYPE'),
				//V2D-106145
				//store: 'common.RegistrationTypeStore',
				store: 'campaignnew.RegistrationTypeStore',
				valueField: 'id',
				displayField: 'value',
				//editable: false,
				forceSelection: true
			},{
				xtype: 'customcombobox',
				name: 'buzzManageCampaign',
				itemId: 'campaignNameId',
				fieldLabel : getCommonTranslation("BUZZ_MANAGE_CAMPAIGN"),
				valueField: 'id',
				displayField: 'value',
				queryParam:'campaignName',
				minChars:3,
				typeAhead:false,
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				maxLength:1000,
				store:Ext.create('Academia.store.campaignnew.CampaignNameFilterStore'),
	/*			listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.campaignnew.CampaignNameFilterStore');
						combo.bindStore(store)
					}
				},*/
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'schoolPriority',
				itemId: 'schoolPriorityId',
				fieldLabel: getCommonTranslation('SCHOOL_PRIORITY'),
				store: Ext.create('Academia.store.enquiry.SchoolPriorityForCampaignStore'),
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'id',
				displayField: 'value',
				minChars:3,
				forceSelection: true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}, {
				xtype: 'customcombobox',
				name: 'school',
				itemId: 'schoolId',
				fieldLabel: getCommonTranslation("SCHOOL"),
				valueField: 'id',
				displayField: 'value',
				store: Ext.create('Academia.store.enquiry.SchoolByPriorityOrCampaignStore'),
				queryParam:'schoolName',
				minChars:3,
				typeAhead:false,
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		}, {
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
                xtype: "customcombobox",
                name: "POPIA_STATUS",
                itemId: "popiastatusId",
                fieldLabel: getCommonTranslation("POPIA_STATUS"),
                store: "enquiry.PopiaStatusStore",
                displayField: "value",
                valueField: "name",
                value: "",
                editable: false,
                queryMode: "local"
            },{
    			xtype: 'textfield',
    			name: 'NATIONAL_ID',
    			itemId: 'nationalId',
    			fieldLabel: getCommonTranslation('NATIONAL_ID')  
    		}, {
				xtype: 'checkboxfield',
				style:{marginTop:'30px'},
				labelAlign: 'right',
				itemId:'trackEnquiry_whetherDeleted',
				boxLabel: getCommonTranslation('INCLUDE_DELETED_RECORDS'),
				name: 'whetherDeleted',
				inputValue : true,
				uncheckedValue: false
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'trackenquiry_search',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});