/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.enquiry.ViewPastSearchForm', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.viewpastsearchform',
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    layout: 'vbox',
    items: [{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
	                width: 256,
	                labelAlign: 'top'
	            },
			items:[{
				xtype: 'textfield',
				name:'enquiryFirstName',
				fieldLabel:getCommonTranslation('ENQUIRER_FIRST_NAME'),
				itemId:'trackEnquiry_enquiryFirstName'
			},{
				xtype: 'textfield',
				name:'enquirerMiddleName',
				itemId:'trackEnquiry_enquiryMiddleName',
				fieldLabel:getCommonTranslation('ENQUIRER_MIDDLE_NAME')
			},{
				xtype: 'textfield',
				name:'enquirerLastName',
				itemId:'trackEnquiry_enquiryLastName',
				fieldLabel:getCommonTranslation('ENQUIRER_LAST_NAME')
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
                width: 256,
                labelAlign: 'top'
            },
			items:[{
				 xtype: 'textfield',
	        	 name: 'email',
	        	 itemId:'trackEnquiry_email',
	        	 fieldLabel: getCommonTranslation('EMAIL'),
	        	 vtype:'email'
			  },{
				   xtype: 'numberfield',
	        	   name: 'MobileNo',
	        	   itemId : 'trackEnquiry_mobileNo',
	        	   fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
					minLength: 6,
					maxLength: 11,
	        	   minValue:0,
	        	   hideTrigger:true 
			    },{
				   xtype: 'numberfield',
	        	   name: 'phoneNo',
	        	   itemId : 'trackEnquiry_phoneNo',
	        	   fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER'),
	        	   minLength:5,
	        	   minValue:0,
	        	   hideTrigger:true 
			    }]
        },{
			 xtype: 'fieldcontainer',
	         width: '100%',
	 		cls: 'customSearchPanelBtnsFieldContainerCls',
	         items: [{
		    	    xtype: 'button',
	                text: getCommonTranslation('SEARCH'),
	                itemId: 'searchBtn',
	                ui: 'CustomBtnSubmit',
	                scale: CONSTANTS.BUTTONSIZE               
			      },{
		    	    xtype: 'button',
	                text: getCommonTranslation('RESET'),
	                itemId: 'resetBtn',
	                ui: 'CustomBtnCancel',
	                scale: CONSTANTS.BUTTONSIZE   
			      }]	
     	   }]
});