/**
 * Rajkumar
 */

Ext.define('Academia.view.enquiry.admission.AdmissionReqmntDetailForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	customFieldEntity:CONSTANTS.ADMISSION_REQUIRMENT_DETAIL_CUSTOM_FIELD,
	alias: 'widget.admissionreqmntdetailform',
	autoScroll: false,
    frame: false,
    border:false,
    method: 'POST',
    standardSubmit: false,
	plugins : "formlabelrequired",
	items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'customcombobox',
				name : 'academyLocation',
				itemId:'academyLocationId',
				fieldLabel : getEnquiryTranslation('ACADEMY_LOCATION'),
				store:'common.AcademyLocationNameSeparated',
				valueField : 'id',
				displayField : 'value',
				allowBlank : false,
				queryParam:'qry',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'modeofDelivery',
				itemId: 'modeDeliveryId',
				fieldLabel: getCommonTranslation('MODE_OF_DELIVERY'),
				store: 'common.ModeOfDeliveryStore',
				valueField: 'id',
				displayField: 'value',
				allowBlank: true,
				editable: false,
			},{
				xtype: 'customcombobox',
				name: 'registrationType',
				itemId: 'registrationTypeId',
				fieldLabel: getCommonTranslation('REGISTRATION_TYPE'),
				store: 'campaignnew.RegistrationTypeStore',
				valueField: 'id',
				displayField: 'value',
				editable: false,
				allowBlank: true,
			}]
		},
		
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'program',
				itemId:'programId',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				allowBlank: false,
				store:'program.ProgrmaFromBeatchLevelModAndRegType',
				displayField:'valueCode',
				valueField:'id',
				typeAhead:true,
				forceSelection:true,
				queryParam:'qry',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'batch',
				itemId:'batchId',
				fieldLabel: getEnquiryTranslation('ACADEMIC_BATCH'),
				allowBlank: false,
				store: 'enquiry.AcademicBatchStore',
				valueField: 'id',
				displayField: 'value',
				editable: false,
				forceSelection:true
			},
			{
				xtype: 'textfield',
				name: 'fieldOfInterest',
				itemId:'fieldOfInterest',
				fieldLabel: getEnquiryTranslation('FIELD_OF_INTEREST'),
				disabled:true
			}]
		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [	{
				xtype: 'customcombobox',
				name: 'seatType',
				itemId : 'seatTypeId',
				fieldLabel: getEnquiryTranslation('SEAT_TYPE'),
				allowBlank: false, 
				store: 'enquiry.ProgramBatchSeatTypeStore',
				valueField: 'id',
				displayField: 'value',
				editable: false,
				forceSelection:true
			}]
		},
		{
			xtype : 'fieldcontainer',
			width:'100%',
			items : [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'ard_submitbuttonId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			}, {	
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId:'ard_cancelbuttonId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		
		}]
});