/**
 * Rajkumar
 */
var admissionRequirementDetail = Ext.create('Academia.store.enquiry.admission.AdmissionReqmntStore');
Ext.define('Academia.view.enquiry.admission.AdmissionReqmntDetailGrid', {
	 extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.admissionreqmntdetailgrid',
    store : admissionRequirementDetail,
    title: getEnquiryTranslation('LIST_OF_ADMISSION_REQUIREMENT_DETAILS'),
	border: true,
	autoScroll: false,
	id:'admissionrqmnt_grid',
	isGridConfigurable : true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			store : admissionRequirementDetail,
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	tbar : [{
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		 xtype: 'button',
         itemId: 'btnView',
         tooltip: getCommonTranslation('VIEW'),
         iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [{
		header : getCommonTranslation('ACADEMY'),
		dataIndex : 'academyName',
		flex : 1
	},{
		header : getCommonTranslation('LOCATION'),
		dataIndex : 'locationName',
		flex : 1
	},{
		header : getCommonTranslation('MODE_OF_DELIVERY'),
		dataIndex : 'modeOfDeliveryCSM',
		flex : 1,
		hidden:true,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value.value;	
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('REGISTRATION_TYPE'),
		dataIndex : 'batchPartTime',
		flex : 1,
		hidden:true,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				if(value){
					return 'Part Time'
				}else{
					return 'Full Time'
				}
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'program',
		flex :1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value.value;	
			}else{
				return '-';
			}
			
		}
	},{
		header : getCommonTranslation('ACADEMIC_INTAKE'),
		dataIndex:'batch',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value.value;	
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('FIELD_OF_INTEREST'),
		dataIndex : 'fieldOfInterest',
		flex : 1,
		hidden:true
	},{
		header : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatType',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value.value;	
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('RESERVATION_CATEGORY'),
		dataIndex:'reservationCategoryCode',
		flex : 1,
		hidden:true
	},{
		header:getCommonTranslation('CLOSURE_DATE'),
		dataIndex:'closureDate',
		flex : 1,
		renderer:function(date) {
			if(!isNullOrEmpty(date)){
				return dateRender(date);
			}else{
				return '-';
			}
			
		}
	},{
		header:getCommonTranslation('STATUS'),
		dataIndex:'status',
		flex : 1
	}]
});