/**
 * Rajkumar
 */

Ext.define('Academia.view.enquiry.closure.ClosureDetailForm', {   
	extend: 'Ext.window.Window',
	alias : 'widget.closuredetailform',
	title: getEnquiryTranslation('CLOSURE_TITLE'),
	autoScroll: true,
	frame: true,
	modal:true,
	items: [{
		xtype: 'form',
		bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items : [{
			xtype: 'radiogroup',
 		    name: 'programExam',
 		    itemId:'programExam_radioBtn',
			items:[
			       {boxLabel : getEnquiryTranslation('CLOSURE'),name:'programExam',inputValue: 0,checked:true},
			       {boxLabel : getEnquiryTranslation('REOPEN'),name:'programExam',inputValue: 1}
			   ]
		},{
			xtype: 'datefield',
			name: 'closureDate',
			itemId:'closureDate',
			//--submitFormat: 'd-m-Y',
			fieldLabel:getEnquiryTranslation('CLOSURE_DATE'),
			maxValue:new Date(),
//			value:new Date(),
			allowBlank: false,
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}

		},{
			xtype: 'customcombobox',
			name: 'closureReason',
			itemId:'closureReasonItemId',
			store: 'enquiry.followup.ClosureReasonStore',
			fieldLabel: getEnquiryTranslation('CLOSURE_REASON'),
			//emptyText:getCommonTranslation('SELECT'),
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			queryParam: 'code',
			allowBlank: false,
			name: 'applicationId',
			itemId: 'applicationCmp',
			hidden:true,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			triggerAction: '',
			forceSelection:true,
			fieldLabel: getCommonTranslation('APPLICATION_ID'),
			displayField: 'value',
			valueField: 'id',
			store: 'enquiry.followup.ApplicationSearchStore',
			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{value}' +
  					'</div>';
  				}
  			}
		    /* V2D-402841
			displayTpl: new Ext.XTemplate('<tpl for="."between=" ">', '{[typeof values === "string" ? values : values["value"]]}' + '</tpl>'),
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.enquiry.followup.ApplicationSearchStore');
					combo.bindStore(store);
				}
			}*/
		},{
			xtype: 'textarea',
			name: 'closureRemarks',
			itemId: 'closureRemarks',
			fieldLabel: getEnquiryTranslation('CLOSURE_REMARKS'),
			allowBlank: false,
			enforceMaxLength : true,
	      	maxLength:255
		},{
			xtype: 'datefield',
			name: 'reopenDate',
			itemId: 'reopenDate',
			hidden:true,
			//--submitFormat: 'd-m-Y',
			minValue:new Date(),
//			value:new Date(),
			fieldLabel:getEnquiryTranslation('REOPEN_DATE')	,
			allowBlank: false,
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}

		},{
			xtype: 'customcombobox',
			name: 'reopenReason',
			itemId : 'reopenReason',
			hidden:true,
			store: 'enquiry.closure.ReopenReasonStore',
			fieldLabel: getEnquiryTranslation('REOPEN_REASON'),
			//editable: false,
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'panel',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			style:{
				marginLeft:'0px !important',
				marginTop:'-5px !important'	
			},
			items: [{
			xtype: 'textarea',
			name: 'reopenRemarks',
			itemId:'reopenRemarks',
			hidden:true,
			fieldLabel: getEnquiryTranslation('REOPEN_REMARKS'),
			allowBlank: false
			}]
		},{
			xtype:'hidden',
			name:'id'
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			items: [{

				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				itemId: 'closureform_submitbuttonId',
				formBind:true,
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'closureform_cancelbuttonId',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}],
	listeners: {
        show: function (win) {
         var el = win.getEl();
         el.setOpacity(0);
         el.fadeIn({
           duration: 800
        });
     },
      beforeclose: function (win) {
       if (!win.shouldClose) {
           win.getEl().fadeOut({
               duration: 500,
               callback: function () {
                   win.shouldClose = true;
                   win.close();
               }
           });
       }
       return win.shouldClose ? true : false;
    }
  }

	});