/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.enquiry.dashboard.EnquiryClosureRateFilterForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.enquiryclosureratefilterform',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    //layout: 'vbox',
    plugins : "formlabelrequired",
	    items: [{
	    	xtype: 'fieldcontainer',
	    	width: 'auto',
	    	layout: 'hbox',
	    	defaults: {
	    		width: 256,
	    		labelAlign: 'top'
	    	},
	    	items : [{
				xtype : 'customcombobox',
				fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
				name : 'intakeYear',
				itemId : 'intakeYear',
				displayField:'value',
				valueField:'id',
				width: 256,
				//typeAhead:true,
				forceSelection:true,
	            editable: false,
				//minChars:3,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				},
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.IntakeYearStore');
						combo.bindStore(store)
					}
				}
	    	},{
				xtype : 'multiselectcombofield',
				cls:'commonAutoHeightMultiselectField',
				fieldLabel: getCommonTranslation('SEAT_TYPE'),
				name: 'seatType',
				itemId:'seatType',
				displayField: 'value',
				valueField: 'id',
				typeAhead : true,
				forceSelection : true,
				editable: false,
	            disableKeyFilter: false,
	            store:Ext.create('Academia.store.common.AllSeatTypeListStore'),
	            listConfig: {
	        		listeners: {
	        			beforeshow: function(picker) {
	        				picker.minWidth = picker.up('combobox').getSize().width;
	        			}
	        		},
	        		loadingText: getCommonTranslation('SEARCHING'),
	        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        		getInnerTpl: function() {
	        			return '<div class="search-item">' +
	        			'{code}'  + '{value}' +
	        			'</div>';
	        		}
	        	}
			}]
	    },{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
	                width: 256,
	                labelAlign: 'top'
	            },
			items:[{
				    xtype: 'datefield',
					name:'startDate',
					itemId:'startDateItemId',
	                fieldLabel: getEnquiryTranslation('FROM_DATE'),
	              //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
		    		editable:false,
		            allowBlank:false,
		            vtype: 'daterange',
		    		endDateField: 'endDateItemId',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					}
				},{
					xtype: 'datefield',
     				name:'endDate',
     				itemId:'endDateItemId',
                    fieldLabel: getEnquiryTranslation('TO_DATE'),
                  //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
		    		editable:false,
     	            allowBlank:false,
     	            vtype: 'daterange',
		    		startDateField: 'startDateItemId',
		    		maxValue:new Date(),	
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
				}]
        },{
			 xtype: 'fieldcontainer',
	         width: 'auto',
	         layout: 'hbox',
	 		cls: 'customSearchPanelBtnsFieldContainerCls',
	         items: [{
	                xtype: 'button',
	                text: getCommonTranslation('SEARCH'),
	                itemId: 'searchBtn',
	                formBind:true,
	                ui: 'CustomBtnSubmit',
	                scale: CONSTANTS.BUTTONSIZE               
			      },{
		    	    xtype: 'button',
	                text: getCommonTranslation('RESET'),
	                itemId: 'resetBtn',
	                ui: 'CustomBtnCancel',
	                scale: CONSTANTS.BUTTONSIZE   
			      }]	
	  }]
});