/**
 * @author Rajkumar.patidar
 */
var store = Ext.create('Ext.data.JsonStore', {
    fields: ['name', 'data1'],
    data: [
        {'name':'May', 'data1':300},
        {'name':'June', 'data1':500},
        {'name':'July', 'data1':100},
        {'name':'August', 'data1':300}
                                                        
    ]});


Ext.define('Academia.view.enquiry.dashboard.EnquiryDashBoardChart' ,{
	extend: 'Ext.chart.Chart',
	requires: ['Ext.chart.*', 'Ext.Window', 'Ext.layout.container.Fit', 'Ext.fx.target.Sprite', 'Ext.window.MessageBox'],
    style: 'background:#fff',
    alias : 'widget.enquirydashboardchart',
    animate: true,
    shadow: false,
    width: 400,
	height: 400,
    store: store,
    axes: [{
        type: 'Numeric',
        position: 'left',
        fields: ['data1'],
        label: {
            renderer: Ext.util.Format.numberRenderer('0,0')
        },
        title: 'Number of Enquiries',
        grid: true,
        minimum: 0
    }, {
        type: 'Category',
        position: 'bottom',
        fields: ['name'],
        title: 'Months of the Year'
    }],
    series: [{
        type: 'column',
        axis: 'left',
        highlight: true,
        tips: {
          trackMouse: true,
          width: 100,
          height: 28,
          renderer: function(storeItem, item) {
            this.setTitle(storeItem.get('name') + ': ' + storeItem.get('data1') + ' $');
          }
        },
        label: {
          display: 'insideEnd',
          'text-anchor': 'middle',
            field: 'data1',
            renderer: Ext.util.Format.numberRenderer('0'),
            orientation: 'vertical',
            color: '#333'
        },
        xField: 'name',
        yField: 'data1'
    }]
});
