/**
 * Rajkumar
 */
Ext.define('Academia.view.enquiry.followup.FollowUpDetailForm', {
	//extend: 'Ext.window.Window',
	//extend : 'Ext.form.Panel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.followupdetailform',
	autoScroll: true,
	title: getEnquiryTranslation('FOLLOW_UP_DETAIL'),
	cls: 'x-form-fixed-footer-parent',
	style: {
		'margin-right': '32px !important;'
	},
	//frame: true,
	id:'followUpDetailFormId',
	//modal: true,
	maxHeight: 600,
	items: [{
		xtype: 'form',
		plugins: "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [/*{
			xtype: 'displayfield',
			value: '<b class="menu-title">' + getEnquiryTranslation('FOLLOW_UP_DETAIL') + '</b>',
			style: {
				textDecoration: "underline"
			}
		}, */{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'displayfield',
				name: 'employeeId',
				value: '1',
				fieldLabel: getEnquiryTranslation('TRACK_ENQUIRY_EMPLOYEE_ID'),
				hidden:true
			}, {
				xtype: 'displayfield',
				name: 'employeeName',
				value: 'Admin',
				fieldLabel: getEnquiryTranslation('EMPLOYEE_NAME'),
				hidden:true
			}]
								},
								{
									xtype : 'fieldcontainer',
									width : 'auto',
									layout : {
										type : 'hbox'
									},
									defaults : {
										width: 256,
										labelAlign : 'top'
									},
									items : [/*
												 * { xtype: 'datefield', name:
												 * 'followUpDate', itemId:
												 * 'followUpdate', editable:
												 * false, readOnly: true,
												 * //--submitFormat:
												 * CONSTANTS.DATE_FORMAT,
												 * fieldLabel:
												 * getEnquiryTranslation('PLANNED_FOLLOW_UP_DATE'),
												 * listeners: { render:
												 * function(field) { return
												 * dateFormatRender(field); } } }
												 */
											{
												xtype : 'datefield',
												name : 'actualFollowUpDate',
												itemId : 'actualFollowUpDate',
												editable : false,
												value : new Date(),
												vtype : 'daterange',
												endDateField : 'nextFollowUpDateId',
												maxValue : new Date(),
												allowBlank : false,
												fieldLabel : getEnquiryTranslation('FOLLOW_UP_DATE'),
												listeners : {
													render : function(field) {
														return dateFormatRender(field);
														// return
														 //Ext.util.Format.dateRenderer('d/m/Y')
													}
												}
											},
											{
												xtype : 'timefield',
												name : 'followupTime',
												itemId : 'followupTime',
												editable : true,
												format : 'H:i',
												allowBlank : true,
												readOnly : false,
												value : new Date(),
												fieldLabel : getEnquiryTranslation('FOLLOW_UP_TIME')
											},
											{
												xtype : 'textfield',
												name : 'followupuser',
												id : 'followUpUser',
												fieldLabel : getEnquiryTranslation('FOLLOW_UP_USER'),
												store : 'enquiry.EnquiryRegisteredBy',
												valueField : 'id',
												displayField : 'value',
												editable : false,
												readOnly : true,
												allowBlank : true
											} ]
								},
								{
									xtype : 'fieldcontainer',
									width : '100%',
									layout : {
										type : 'hbox'
									},
									defaults : {
										width: 256,
										labelAlign : 'top',
										regex : /[a-zA-Z0-9]+/
									},
									items : [
											{
												xtype : 'textfield',
												name : 'followupActivityTo',
												id : 'followupactivityto',
												editable : false,
												readOnly : true,
												allowBlank : true,
												fieldLabel : getEnquiryTranslation('FOLLOW_UP_ACTIVITY_TO'),
												maxLength : 100,
												enforceMaxLength : true
											},
											{
												xtype : 'textfield',
												name : 'emailAdress',
												itemId : 'emailAdress',
												editable : false,
												readOnly : true,
												allowBlank : true,
												vtype : 'email',
												fieldLabel : getCommonTranslation('EMAIL'),
												maxLength : 100,
												enforceMaxLength : true
											},
											{
												xtype : 'fieldcontainer',
												labelSeparator : '',
												fieldLabel : getCommonTranslation('MOBILE_NO'),
												itemId : 'enquiryDetail_cellNumber',
												name : 'enquiryDetail_cellNumber',
												editable : false,
												readOnly : true,
												allowBlank : true,
												layout : 'hbox',
												width: 256,
												labelAlign : 'top',
												items : [
														{
															xtype : 'customcombobox',
															valueField : 'isdCode',
															displayField : 'isdCode',
															store : 'common.CountryStore',
															itemId : 'phoneCountryCode',
															triggerAction : 'all',
															name : 'phoneCountryCode',
															width : 80,
															typeAhead : true,
															editable : false,
															readOnly : true,
															emptyText : 'Code',
															allowBlank : true,
															minChars : 1
														},
														{
															xtype : 'numberfield',
															name : 'cellNo',
															id : 'enquiry_mobileno',
															minLength : 0,
															maxLength : 15,
															width : 150,
															readOnly : true,
															hideTrigger : true,
															
														} ]
											},{
												xtype: 'button',
												text: getCommonTranslation('CALL'),
												buttonAlign: 'left',
												itemId: 'callFollowupButton',
												ui: 'CustomBtnSubmit',
												hidden:true,
												scale: CONSTANTS.BUTTONSIZE,         
												style:{
													marginTop:'30px'
												}
											},{
												xtype: 'displayfield',
												html:'<span></span>',
												hidden:true,
												itemId:'callButtonMessage',
												name:'callButtonMessage',
												style:{
													marginTop:'35px',
													marginLeft:'-165px'
												}
											},
											{
												xtype:'hidden',
												id:'hiddenFollowUpUrl',
												itemId:'hiddenFollowUpUrl',
												name:'hiddenFollowUpUrl'
											} ]
								},
								{
									xtype : 'fieldcontainer',
									width : 'auto',
									layout : {
										type : 'hbox'
									},
									defaults : {
										width: 256,
										labelAlign : 'top'
									},
									items : [
											{
												xtype : 'customcombobox',
												name : 'followUpActivityType',
												itemId : 'followupactivitytypeId',
												store : 'enquiry.FollowupActivityType',
												fieldLabel : getEnquiryTranslation('FOLLOW-UP_ACTIVITY_TYPE'),
												valueField : 'id',
												displayField : 'value',
												allowBlank : false,
												typeAhead : true,
												forceSelection : true
											},
											{
												xtype : 'customcombobox',
												name : 'reasonForFollowUp',
												itemId : 'reasonforfollowup',
												fieldLabel : getEnquiryTranslation('REASON_FOR_FOLLOW-UP'),
												store : 'enquiry.ReasonForFollowup',
												displayField : 'value',
												valueField : 'id',
												typeAhead : true,
												forceSelection : true,
												allowBlank : false
											},
											{
												xtype: 'textfield',
												fieldLabel: getEnquiryTranslation('ADDITIONAL_REASON'),
												name: 'additionalReason',
												itemId:'additionalReason',
												allowBlank: true,
												disabled:true
											}
											 ]
								},
		
		{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype : 'customcombobox',
				name : 'followUpActivityStatus',
				itemId : 'followupactivitystatusId',
				fieldLabel : getEnquiryTranslation('FOLLOW_UP_ACTIVITY_STATUS'),
				store : 'enquiry.FollowupActivityStatus',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : false
			},{
				xtype: 'customcombobox',
				name: 'enqIntermediateStage',
				itemId: 'enqIntermediateStage',
				store: 'enquiry.EnqIntermediateType',
				fieldLabel: getEnquiryTranslation('INTERMEDIATE_STAGE'),
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				typeAhead: true,
				forceSelection: true
			}, {
				xtype: 'customcombobox',
				name: 'priority',
				itemId: 'trackEnquiry_priority',
				fieldLabel: getEnquiryTranslation('PRIORITY'),
				store: 'enquiry.Priority',
				displayField: 'value',
				valueField: 'id',
				typeAhead: true,
				forceSelection: true,
				allowBlank: false
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype : 'textfield',
				name : 'followupStatusUpdateTime',
				itemId : 'followupStatusUpdateTime',
				fieldLabel : getEnquiryTranslation('FOLLOW_UP_STATUS_UPDATE_DATE_AND_TIME'),
				//store : 'enquiry.FollowupActivityStatus',
				displayField : 'value',
				valueField : 'id',
				width: 256,
				typeAhead : true,
				forceSelection : true,
				allowBlank : false
			}]
		}, {
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
			xtype: 'textarea',
			width: 455,
			maxLength : 1000,
			name: 'remark',
			itemId: 'remarkItemId',
			fieldLabel: getEnquiryTranslation('FOLLOW_UP_REMARKS'),
		}]
		}, {
			xtype: 'checkboxfield',
			boxLabel:getEnquiryTranslation('SCHEDULE_NEXT_FOLLOW_UP'),
			name:'whetherNextFollowUp',
			itemId:'whetherNextFollowUpId'
		}, {

			xtype: 'fieldcontainer',
			width: 'auto',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'enquiryStatus',
				itemId:'trackEnquiry_enquiryStatus',
				fieldLabel: getEnquiryTranslation('TRACK_ENQUIRY_STATUS'),
				valueField: 'id',
				displayField: 'value',
				hidden:true,//Hidden status as discussed with  mrinal and acd-12046 
				typeAhead: true,
				forceSelection: true,
				store: {
					fields: ['text', 'value', 'code'],
					data : [
					        {"id":"O", "value":"Open", "code": "O"},
					        {"id":"C", "value":"Closed", "code": "C"},
					        ]
				}
			},{
				xtype: 'customcombobox',
				name:'closerReason',
				itemId:'closerReasonId',
				store: 'enquiry.followup.ClosureReason',
				fieldLabel: getEnquiryTranslation('CLOSURE_REASON'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				hidden:true,
				forceSelection:true
			},{
				xtype: 'datefield',
				name: 'nextFollowUpDate',
				itemId: 'nextFollowUpDateId',
				vtype: 'daterange',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				fieldLabel: getEnquiryTranslation('NEXT_FOLLOW_UP_DATE'),
				allowBlank: true,
				hidden:true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}, {
				xtype: 'customcombobox',
				name: 'userByAssignTo',
				itemId: 'userByAssignToId',
				store: 'enquiry.FollowUpUserWithDepartment',
				fieldLabel: getEnquiryTranslation('ASSIGN_TO'),
				valueField: 'id',
				displayField: 'value',
				queryParam: 'name',
				minChars: 3,
				allowBlank: true,
				typeAhead: false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection: true,
				hidden:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'textfield',
				name: 'departmentName',
				readOnly: true,
				hidden:true,
				fieldLabel: getEnquiryTranslation('DEPARTMENT'),
				itemId: 'departmentName'
			}]
		}, {
			xtype: 'fieldcontainer',
			cls: 'form-fixed-footer',
			layout : 'hbox',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				itemId: 'followdetail_submitbuttonId',
				name: 'followdetail_submitbutton',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}/*, {
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				ui: 'CustomBtnCancel',
				itemId: 'followdetail_resetbuttonId',
				scale: CONSTANTS.BUTTONSIZE

			}*/]
		}]
	}]
});