/**
 *  vyabha thakur
 */

Ext.define('Academia.view.enquiry.student.ChangeLinkedApplication', {
    extend: 'Ext.window.Window',
    alias: 'widget.changelinkedapplication',
    modal: true,
    autoScroll:true,
    title: getEnquiryTranslation('CHANGE_LINKED_APPLICATION'),
    maxHeight:600,
    items: [{
        xtype: 'form',
        method: 'POST',
        autoScroll:true,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: 'anchor',
        standardSubmit: false,
        plugins:"formlabelrequired",
        defaults: {
        	  labelAlign: 'top',
        	  width: 256,
        },
        items: [{  
        	    xtype: 'hidden',
                name: 'id'
            },{
				xtype: 'customcombobox',
				name: 'applicationId',
				itemId: 'applicationId',
				fieldLabel: getCommonTranslation('APPLICATION_ID'),
				store:'enquiry.followup.CurrentAlApplicationStore',
				displayField: 'value',
				valueField: 'id',
				queryParam:'code',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            forceSelection:true,
				listConfig: {
	  				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	  				loadingText: getCommonTranslation('SEARCHING'),
	  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	  				getInnerTpl: function() {
	  					return '<div class="search-item">' +
	  					'{value}' +
	  					'</div>';
	  				}
	  			}
				
			},{
            layout: {
                type: 'hbox'
            },
            style:{
            	marginLeft:'0px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'saveBtn',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'cancelBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                handler :function(button) {
                	button.up('window').close();
                }
            }]
        }]
    }]
});