/**
 *  Bhanu PS
 */
Ext.define('Academia.view.enquiry.student.EnquiryReassignWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.enquiryreassignwindow',
	modal: true,
	autoScroll:true,
	title:getCommonTranslation('REASSIGN_ENQUIRY'),
	maxHeight:600,
	width: 600,
	height:'50%',
	items: [{
		//xtype: 'form',
		xtype: 'idgeneratorformwin',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox',
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
				xtype: 'hidden',
				name: 'id'
					
			},{
				xtype: 'customcombobox',
				name: 'userByAssignTo',
				itemId: 'userByAssignToId',
				store: 'enquiry.FollowUpUserWithDepartment',
				fieldLabel: getCommonTranslation('REASSIGN_TO'),
				valueField: 'id',
				displayField: 'value',
				queryParam: 'name',
				minChars: 3,
				typeAhead: false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection: true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				},
				allowBlank:false
			},{
				xtype: 'datefield',
				name: 'reasignDate',
				itemId: 'reasignDateId',
				maxValue: new Date(),
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				fieldLabel: getCommonTranslation('REASSIGNMENT_DATE'),
				listeners: {
					render: function(field) {
						dateFormatRender(field);
						field.setValue(new Date());
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'vbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'checkboxfield',
				itemId : 'sendReassignNotificationField',
				labelAlign: 'right',
				region: 'south',
				boxLabel: getCommonTranslation('SEND_REASSIGN_NOTIFICATION'),
				name: 'sendReassignNotification',
				inputValue: true,
				uncheckedValue: false,
				checked:true
 			},{
				xtype: 'textarea',
				width: 462,
				name: 'remark',
				itemId: 'remarkItemId',
				fieldLabel: getCommonTranslation('REASSIGNMENT_REASON')
			}]
		}, {
			xtype: 'fieldcontainer',
			width: '100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'saveBtn',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE,
				handler :function(button) {
					button.up('window').close();
				}
			}]
		}]
	}]
});