/**
 * @author Bhartendu Bhaskar
 * 
 */
Ext.define('Academia.view.eventmeetingminutes.EMMMinuteReportsFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.emmminutereportsfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'eventId',
            itemId: 'eventIdItemId',
            fieldLabel: getServiceRequestTranslation('EVENT_NAME'),
            store: 'eventmeetingminutes.EMMMinuteReportsEventNameStore',
            valueField: 'id',
            displayField: 'value',
            queryParam: 'name',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            forceSelection: true,
            maxLength: 100,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            },
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'dateType',
            itemId: 'dateTypeItemId',
            fieldLabel: getServiceRequestTranslation('EMM_DATE_TYPE'),
            store: 'eventmeetingminutes.EventMeetingMinutesDateTypeStore',
            valueField: 'value',
            displayField: 'name',
            typeAhead: false,
            value: 'Assigned Date',
            forceSelection: true,
            editable: false,
            maxLength: 40
        }, {
            xtype: 'datefield',
            name: 'fromDate',
            itemId: 'fromDateItemId',
            vtype: 'daterange',
            endDateField: 'toDateItemId',
            fieldLabel: getServiceRequestTranslation('FD_FROM_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			allowBlank:false,
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }, {
            xtype: 'datefield',
            name: 'toDate',
            itemId: 'toDateItemId',
            vtype: 'daterange',
            startDateField: 'fromDateItemId',
            fieldLabel: getServiceRequestTranslation('FD_TO_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			allowBlank:false,
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
			xtype: 'customcombobox',
			name: 'userType',
			itemId: 'userTypeItemId',
			fieldLabel: getFileManagementTranslation('USER_TYPE'),
			editable: false,
			disableKeyFilter: false,
			valueField: 'id',
			displayField: 'userGroupName',
			store: 'attendance.UserGroup'
		}, {
			xtype: 'customcombobox',
			name:'ownerId',
			itemId:'ownerIdItemId',
			fieldLabel : getServiceRequestTranslation('EMM_USER_ID_NAME'),
			msgTarget: 'qtip',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:3,
			disabled:true,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
	        maxLength: 100,
			listeners:{
				render : function(combo){
					var store=Ext.create('Academia.store.hostel.roomallocation.UserSmartSearchByUserType');
					combo.bindStore(store)
				}
			},
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'taskType',
            itemId: 'taskTypeItemId',
            fieldLabel: getServiceRequestTranslation('EMM_MINUTE'),
            valueField: 'id',
            displayField: 'value',
            store: 'eventmeetingminutes.EventMeetingMinutesTaskTypeStore',
            forceSelection: true,
            editable: false,
        }, {
            xtype: 'customcombobox',
            name: 'taskStatus',
            itemId: 'taskStatusItemId',
            fieldLabel: getServiceRequestTranslation('EMM_MINUTE_STATUS'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            editable: false,
            store: 'eventmeetingminutes.EventMeetingMinutesStatusStore',
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnEmmminutereportsfilterItemId',
            //buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true,
			margin: '0 44 0 0'
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetEmmminutereportsfilterItemId',
            //buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});