/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.eventmeetingminutes.EventMeetingMinutesTaskGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.eventmeetingminutestaskgrid',
    store: 'eventmeetingminutes.EventMeetingMinutesTaskStore',
    title: getServiceRequestTranslation('EMM_MEETING_MINUTES'),
    border: true,
    autoScroll: false,
    frame: false,
    isFixHeightGrid: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [{
        header: getServiceRequestTranslation('EMM_SERIAL_NO'),
        dataIndex: 'serialNo',
        flex: 0.4,
        sortable: true
    }, {
        header: getServiceRequestTranslation('EMM_ASSIGN_DATE'),
        dataIndex: 'assignDate',
        flex: 0.9,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getServiceRequestTranslation('EMM_TOPIC'),
        dataIndex: 'topic',
        flex: 1.3,
        sortable: true,
        editor: {
            xtype: 'textfield',
            name: 'topic',
            itemId: 'topicItemId',
            maxLength: 40,
        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    }, {
        header: getServiceRequestTranslation('EMM_TYPE'),
        dataIndex: 'type',
        flex: 0.7,
        sortable: true,
        editor: {
            xtype: 'customcombobox',
            name: 'type',
            itemId: 'typeItemId',
            valueField: 'id',
            displayField: 'colorValue',
            forceSelection: true,
            editable: false,
            listeners: {
                focus: function(combo, eOpt) {
                    combo.setRawValue(getCommonTranslation(combo.getValue()));
                },
                blur: function(combo, r) {
                    combo.setValue(combo.getValue());
                },
                render: function(combo) {
                    var store = Ext.create('Academia.store.eventmeetingminutes.EventMeetingMinutesTaskTypeStore');
                    combo.bindStore(store);
                },
                change: function(combo, eOpt) {
                    combo.setRawValue(getCommonTranslation(combo.getValue()));
                }
            }
        },
        renderer: function(value, rec) {
            if (isNullOrEmpty(value)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var colorValue = '';
                if (value == 'AGENDA') {
                    colorValue = "<span style = 'color:#2b78e4;'>" + getCommonTranslation(value) + "</span>";
                } else if (value == 'IDEA') {
                    colorValue = "<span style = 'color:#ff9900;'>" + getCommonTranslation(value) + "</span>";
                } else if (value == 'DECISION') {
                    colorValue = "<span style = 'color:#cc0000;'>" + getCommonTranslation(value) + "</span>";
                } else if (value == 'INFO') {
                    colorValue = "<span style = 'color:#009e0f;'>" + getCommonTranslation(value) + "</span>";
                } else if (value == 'TASK') {
                    colorValue = "<span style = 'color:#9900ff;'>" + getCommonTranslation(value) + "</span>";
                }
                return colorValue;
            }
        }
    }, {
        header: getServiceRequestTranslation('DESCRIPTION'),
        dataIndex: 'description',
        flex: 2,
        sortable: true,
        editor: {        	
        	xtype: 'textareafield',
            name: 'description',
            itemId: 'descriptionId',
            maxLength: 255,
            autoScroll: true,
            grow: true,
            minHeight: 40,
            shrinkWrap: true,
            padding: 0,
            rows: 10,
            autoHeight: true,
            height: 40,
            margin: '10 0 0 0',
            listeners: {
                focus: function(th, e, oldValue, eOpts) {
                    th.autoSize();
                    var carLngth = th.getValue().length;
                    th.setHeight((carLngth / 40) * 23);
                    var relatedTarget = Ext.get(e.relatedTarget);
                    var currentTarget = Ext.get(e.target);
                    topValue = relatedTarget.getRegion().top;
                    currentTarget.setRegion({
                        top: topValue
                    });
                    th.up().up().doComponentLayout();
                }
            }
        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val) && isNullOrEmpty(rec.record.data.designation)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    }, {
        header: getServiceRequestTranslation('EMM_OWNER'),
        dataIndex: 'ownerId',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'customcombobox',
            name: 'ownerId',
            itemId: 'ownerIdItemId',
            store: 'eventmeetingminutes.EventMeetingMinutesParticipantStore',
            valueField: 'id',
            displayField: 'codePrintName',
            queryParam: 'codeOrName',
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            //triggerAction: '',
            hideTrigger: false,
            //allowBlank: false,
            forceSelection: true,
            maxLength: 100,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            }
        },
        renderer: function(val, meta, record, rowIndex, colIndex, store, view) {
            var grid = view.up();

            if (isNullOrEmpty(val)) {
                meta.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            }

            var viewParticipantList = grid.getViewParticipantList && grid.getViewParticipantList();
            if (!isNullOrEmpty(viewParticipantList)) {
                var match = viewParticipantList.find(function(item) {
                    return item.id == val;
                });
                if (match) {
                    return match.printName || match.codePrintName;
                }
            }

            var comboStore = Ext.getStore('eventmeetingminutes.EventMeetingMinutesParticipantStore');
            if (comboStore && comboStore.getCount() > 0) {
                var rec = comboStore.findRecord('id', val);
                if (rec) {
                    return rec.get('codePrintName');
                }
            }
            if (comboStore && comboStore.getCount() === 0 && !comboStore.isLoading()) {
                comboStore.load({
                    callback: function() {
                        grid.getView().refresh();
                    }
                });
            }
            return val;
        }

    }, {
        header: getServiceRequestTranslation('EMM_MINUTE_STATUS'),
        dataIndex: 'status',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'customcombobox',
            name: 'status',
            itemId: 'statusItemId',
            valueField: 'id',
            displayField: 'colorValue',
            forceSelection: true,
            editable: false,
            listeners: {
                focus: function(combo, eOpt) {
                    if (combo.getRawValue() == "")
                        combo.setRawValue(getCommonTranslation("PENDING"));
                    else
                        combo.setRawValue(getCommonTranslation(combo.getValue()));
                },
                blur: function(combo, r) {
                    combo.setValue(combo.getValue());
                },
                render: function(combo) {
                    var store = Ext.create('Academia.store.eventmeetingminutes.EventMeetingMinutesStatusStore');
                    combo.bindStore(store);
                },
                change: function(combo, eOpt) {
                    combo.setRawValue(getCommonTranslation(combo.getValue()));
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.statusPrefillValue)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {
                    if (record.data.statusPrefillValue == 'PENDING') {
                        if (val == 'COMPLETED') {
                            /*if (!isNullOrEmpty(record.data.dueDate)) {
                            	var dueDateTime = record.data.dueDate.getTime();
                            	var currentDate =  new Date();
                            	currentDate.setHours(0);
                            	currentDate.setMinutes(0);
                            	currentDate.setSeconds(0);
                            	currentDate.setMilliseconds(0);
                            	var completeDateTime = currentDate.getTime();
                            	if(dueDateTime < completeDateTime) {
                            		var noOfOverdue = (dueDateTime - completeDateTime) / (86400000);
                            		models[rowIndex].set("noOfDaysOverdue", noOfOverdue);
                            	}
                            }*/
                            models[rowIndex].set("completionDate", new Date());
                        } else {
                            models[rowIndex].set("completionDate", '');
                        }
                    }
                } else if (!isNullOrEmpty(record.data.statusPrefillValue)) {
                    val = record.data.statusPrefillValue;
                    models[rowIndex].set("status", val);
                }
                var colorValue = '';
                if (val == 'PENDING') {
                    colorValue = "<span style = 'color:#cc0000;'>" + getCommonTranslation(val) + "</span>";
                } else if (val == 'COMPLETED') {
                    colorValue = "<span style = 'color:#009e0f;'>" + getCommonTranslation(val) + "</span>";
                } else if (val == 'FORWARDED') {
                    colorValue = "<a href='#' style = 'color:#2b78e4;'>" + val + "</a>";
                }
                return colorValue;
            }
        }
    }, {
        header: getServiceRequestTranslation('DUE_DATE'),
        dataIndex: 'dueDate',
        flex: 0.9,
        sortable: true,
        editor: {
            xtype: 'datefield',
            name: 'dueDate',
            itemId: 'dueDateItemId',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            minValue: new Date(),
            vtype: 'daterange',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.dueDatePrefillValue)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.dueDatePrefillValue)) {
                    val = record.data.dueDatePrefillValue;
                }
                models[rowIndex].set("dueDate", val);
                models[rowIndex].set("dueDatePrefillValue", val);
                return dateRender(val);
            }
        }
    }, {
        header: getServiceRequestTranslation('EMM_COMPLETION_DATE'),
        dataIndex: 'completionDate',
        flex: 0.9,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getServiceRequestTranslation('EMM_NO_OF_DAYS_OVERDUE'),
        dataIndex: 'noOfDaysOverdue',
        flex: 1,
        sortable: true,
    }, {
        header: getServiceRequestTranslation('EMM_ADD'),
        dataIndex: 'addButton',
        flex: 0.5,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow)
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.6,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            if (rowIndex > 0 && !isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            }
            return '';
        }
    }, {
        header: getServiceRequestTranslation('REMARK'),
        dataIndex: 'showViewLink',
        flex: 0.6,
        sortable: true,
        hidden: true,
        renderer: function(value, meta, record) {
            if (value)
                return "<a href='#'>View</a>";
            return '';
        }
    }],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(obj, editor, context) {
                if (editor.record.data.isEditable == 'ADD') {
                    return true;
                } else if (editor.record.data.isEditable == 'EDIT') {
                    var columnDataIndex = obj.context.field;
                    if (columnDataIndex == "dueDate") {
                        return true;
                    } else if (columnDataIndex == "status") {
                        return true;
                    }
                    return false;
                } else if (editor.record.data.isEditable == 'VIEW') {
                    return false;
                }
            }
        }
    }]
});

var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
    clicksToEdit: 1,
    listeners: {
        beforeedit: function(editor, context, e) {}
    }
});