/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.examcancellation.ExamCancellationRequestFilter', {
extend: 'Ext.form.FormPanel',
	alias: 'widget.examcancellationrequestfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype:'hidden',
		name:'statusName',
		itemId:'statusNameItemId'
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'academyLocationName',
			width: 536,
			itemId:'academyLocationItemId',
			store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
			displayField: 'value',
			valueField: 'id',
			forceSelection:true,
			enableKeyEvents  : 'true',
			typeAhead:false,
			fieldLabel:getCommonTranslation('ACADEMYLOCATION'),
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    hideTrigger:false,
		    queryParam:'qry',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
				xtype: 'customcombobox',
        		width: 256,
				name:'academicTermName',
				itemId:'academicTermItemId',
				fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
				minChars:3,
				displayField: 'value',
				valueField: 'id',
				forceSelection:true,
				store : Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
		
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'programName',
			itemId:'programNameItemId',
			store:Ext.create('Academia.store.common.AssignedProgramStore'),
			valueField: 'id',
			width: 536,
			displayField: 'code',
			forceSelection:true,
			enableKeyEvents  : 'true',
			typeAhead:false,
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    hideTrigger:false,
		    queryParam:'name',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
				xtype: 'customcombobox',
        		width: 256,
				name:'batchName',
				itemId:'batchName',
				fieldLabel: getCommonTranslation('BATCH'),
				minChars:3,
				displayField: 'value',
				valueField: 'id',
				forceSelection:true,
				disabled:true,
				store:Ext.create('Academia.store.examinationcenters.reports.SpecialGradeBatchStore'),
		
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'admissionCodeSTDName',
			itemId:'admissionCodeSTDName',
			store:Ext.create('Academia.store.examinationcenters.reports.ExaminationReportStudentStore'),
			valueField: 'id',
			displayField: 'valueCode',
			width: 536,
			forceSelection:true,
			enableKeyEvents  : 'true',
			typeAhead:false,
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    hideTrigger:false,
		    queryParam:'name',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'examCancellationName',
			itemId:'examCancellationName',
			store:Ext.create('Academia.store.examcancellation.ExamCancellationNameStore'),
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			enableKeyEvents  : 'true',
			typeAhead:false,
			fieldLabel:getExaminationTranslation('EXAM_CANCELLATION_NAME'),
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    hideTrigger:false,
		    queryParam:'examCancellationName',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
				xtype: 'customcombobox',
        		width: 256,
				name:'approveStatus',
				itemId:'approveStatus',
				fieldLabel: getCommonTranslation('APPROVAL_STATUS'),
				minChars:3,
				displayField: 'value',
				valueField: 'id',
				forceSelection:true,
				store:Ext.create('Academia.store.examcancellation.ExamCancellationReqStatusEnumStore'),
		
		}]
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		width: 256,
		items:[{
			xtype:'displayfield',
			value:getCommonTranslation('REQUEST_DATE'),
			cls:'examcancellationrequestcls'
		}]
	},{

		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
				xtype: 'datefield',
				name:'fromDate',
				itemId:'fromDate',
				fieldLabel:getCommonTranslation('FROM_DATE'),
				width: 256,
				vtype: 'daterange',
				endDateField: 'tillDate',
				listeners: {
						render: function(field) {
						return dateFormatRender(field);
   			    }
				},
		},{	    xtype: 'datefield',
        		width: 256,
				name:'tillDate',
				itemId:'tillDate',
				fieldLabel:getCommonTranslation('END_DATE'),
				vtype: 'daterange',
				startDateField: 'fromDate',
				listeners: {
						render: function(field) {
						return dateFormatRender(field);
   			    }
				},
		}]
	
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'quickSearchId',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
