/**
 * Deepika Parmar
 */
var examCancellationRequestGridStore=Ext.create('Academia.store.examcancellation.ExamCancellationRequestGridStore');
Ext.define('Academia.view.examcancellation.ExamCancellationRequestGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.examcancellationrequestgrid',
	store: examCancellationRequestGridStore,
	border: true,
	frame:false,
	title:getCommonTranslation('EXAM_CANCELLATION_REQUEST_LIST'),
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
	selModel: {
	    multiSelect :true,
	    mode:'SIMPLE',
	    checkOnly : false
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
				xtype: 'custompagingtoolbar',
				itemId:'managePaggingToolBarItemId',
				plugins:['pagesize'],
			    store : examCancellationRequestGridStore,
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
		}]
	}],
  isGridConfigurable:true,
   enableColumnHide: false,
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
 },
 tbar: [{
       xtype: 'button',
       itemId: 'approveRejectBtn',
       tooltip: getExaminationTranslation('APPROVE_REJECT'),
       text: getExaminationTranslation('APPROVE_REJECT'),
       disabled: true
   }],
 	
	columns: [{
		header: getCommonTranslation('REQUEST_DATE'),
		dataIndex: 'examCancellationRequestDate',
		flex:.4,
		sortable:true,
		renderer:function(value,meta,record){
        	if(!isNullOrEmpty(value)) {
					return dateRender(value);
			}
        }
	},{
		header: getCommonTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.4,
		sortable:true,
		hidden:true
	},{
		header: getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationName',
		flex:.3,
		sortable: true
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:.3,
		sortable: true
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:.3,
		sortable: true
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:.3,
		sortable: true
	},{
		header : getCommonTranslation('COURSE_CODE'),
		dataIndex : 'courseCode',
		flex:.3,
		sortable: true,
		hidden:true
	},{
		header : getCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex:.3,
		sortable: true
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantName',
		flex:.3,
		sortable: true,
		hidden:true
	},{
		header : getCommonTranslation('STUDENT_REMARKS'),
		dataIndex : 'remark',
		flex:.3,
		sortable: true,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				if(value.length > 45) {
					var splitValue = value.slice(0,45);
					metaData.tdAttr = 'data-qtip="' + Ext.String.htmlEncode(value) + '"';
					return splitValue;
				}
				else {
					return value;
				}
			}	
		}
	},{
		header : getCommonTranslation('REFERENCE_DOCUMENTS'),
		dataIndex : 'documentId',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.documentId)) {
				return "<a href='#'>"+"Certificate"+"</a>" ;
			} else {
				return "-" ;
			}                       
		}
	},{
		header : getCommonTranslation('EXAM_CANCELLATION_NAME'),
		dataIndex : 'examCancellationName',
		flex:.3,
		sortable: true,
		hidden:true
	},{
		header : getCommonTranslation('APPROVAL_STATUS'),
		dataIndex : 'status',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.status)) {
				return getCommonTranslation(record.data.status);
			}                        
		}
		
	},{
		header : getCommonTranslation('APPROVAL/REJECT REMARKS'),
		dataIndex : 'approvalRemark',
		flex:.3,
		sortable: true,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				if(value.length > 45) {
					var splitValue = value.slice(0,45);
					metaData.tdAttr = 'data-qtip="' + Ext.String.htmlEncode(value) + '"';
					return splitValue;
				}
				else {
					return value;
				}
			}	
		},
		/*listConfig: { 
           listeners: {
            		 beforeshow: function(picker) {
            			 picker.minWidth = picker.up('combobox').getSize().width;
            		 }
           },
           getInnerTpl: function(displayField) { 
            		 return '<tpl if="xindex%2==0"><div class="oddColorCombo" style="width:404px"></tpl><tpl if="xindex%2==1"><div class="evenColorCombo" style="width:404px"></tpl> {' + displayField + '} </div>';
            	 } 
        }*/
	}]
});
