/**
 * @Author Deepika P
 */
Ext.define('Academia.view.examconcession.ExamConcessionApplyToStructure', { 
	extend : 'Ext.panel.Panel',
	alias : 'widget.examconcessionapplytostructure',
	autoScroll: false,
	plain: true,
	items : [
		{
			xtype:'grid',
			border:true,
			autoScroll:true,
			store:'examconcession.ExamConcessionMappedProgramGridStore',
		    title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
		    autoScroll: true,
		    viewConfig: {
		        stripeRows: CONSTANTS.STRIPEROWS
		    },
		    dockedItems : [{
				xtype : 'toolbar',
				dock : 'bottom',
				items : [{
						xtype: 'custompagingtoolbar',
						itemId:'managePaggingToolBarItemId',
						plugins:['pagesize'],
					    store : 'examconcession.ExamConcessionMappedProgramGridStore',
						emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
						displayInfo : true
				}]
			}],
		    tbar: [{
		        xtype: 'button',
		        itemId: 'btnAdd',
		        tooltip: getCommonTranslation('ADD'),
		        iconCls:'icon-addbutton',
				cls:'addbutton'
		    }, {
		        xtype: 'button',
		        itemId: 'btnView',
		        tooltip: getCommonTranslation('VIEW'),
		        iconCls: 'icon-View',
				cls:'iconView',
		        disabled: true
		    }, {
		        xtype: 'button',
		        itemId: 'btnDelete',
		        cls: 'CustomToolbarBtnReject',
		        tooltip: getCommonTranslation('DELETE'),
		        iconCls: 'icon-Delete',
				cls:'iconDelete',
		        disabled: true
		    }],
			columns:[{
				header:getCommonTranslation('ACADEMY_LOCATION'),
				dataIndex:'academyLocationName',
				flex:1
			},{
				header:getCommonTranslation('PROGRAM_BATCH'),
				dataIndex:'programBatch',
				flex:1
			}]
		}
	]
});	