/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.examexecution.StudentMarkRemarkEntryFacultyFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.studentmarkremarkentryfacultyfilter',
	autoScroll: false,
	modal: true,
	plugins:"formlabelrequired",
	cls:'customSearchPanel',
	style:{
		margin: '-10px;'
	},
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [
			{
				xtype : 'customcombobox',
				name : 'academicTerm',
				itemId : 'academicTerm',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				valueField : 'id',
				displayField : 'value',
				allowBlank: false
				//hidden:true,
			},{
				xtype: 'customcombobox',
				name:'studentName',
				itemId : 'studentNameItemId',
				allowBlank: false,
				store:Ext.create('Academia.store.examexecution.StudentMarkRemarkStore'),
				fieldLabel:getExaminationTranslation('STUDENT_ID_NAME'),
				//labelStyle: 'width: 250px;',
				valueField: 'id',
				displayField: 'value',
				queryParam:'studentName',
				minChars:3,
				disabled:true,
				width: 536,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			},]
	},{

		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [,{
			xtype:'hidden',
			name:'eventStatus',
			itemId: 'eventStatus',
		},{
			xtype: 'customcombobox',
			name: 'evaluationplantype',
			itemId:'evaluationplantypeItemId',
			store:Ext.create('Academia.store.examCenter.AssignSequence.EvaluationType'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN_TYPE'),
			//allowBlank: false
		},{
			xtype: 'multiselectcombofield',
			name:'courseId',
			itemId:'courseItemId',
			store: Ext.create('Academia.store.examexecution.StudentRemarkCourseStore'),//'examinationcenters.evaluation.CourseAndVariantsContainsEvaluation',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'displayValue',
			queryParam:'courseName',
			minChars:3,
			width: 536,
			autoloadStore: false,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryMode:'remote',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			editable:false,
			
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{

			xtype: 'customcombobox',
			name:'programId',
			itemId:'programIdItemId',
//			store:'common.ProgramByAcademyLocationStore',
			store:Ext.create('Academia.store.examexecution.StudentRemarkProgramStore'),
			fieldLabel:getExaminationTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'programName',
			minChars:3,
			width: 536,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			hidden:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
	  }]
	},
	{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'batchIdItemId',
			store:Ext.create('Academia.store.examexecution.StudentRemarkBatchStore'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			hidden:true,
			queryParam:'batchName',
			minChars:3,
			fieldLabel: getExaminationTranslation('BATCH'),
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodIdItemId',
			fieldLabel: getExaminationTranslation('PERIOD'),
			store:Ext.create('Academia.store.examexecution.StudentRemarkPeriodStore'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			hidden:true,
			typeAhead:true,
			disabled:true,
			queryParam:'periodName',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		},{
			xtype: 'customcombobox',
			name: 'sectionId',
			fieldLabel: getExaminationTranslation('SECTION'),
			store:Ext.create('Academia.store.examexecution.StudentRemarkSectionStore'),
			itemId:'sectionIdItemId',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			hidden:true,
			disabled:true,
			queryParam:'sectionName',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{

			xtype: 'customcombobox',
			name:'evaluationPlan',
			itemId:'evaluationPlanItemId',
			store:Ext.create('Academia.store.examexecution.StudentRemarkEvalPlanStore'),
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'planName',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'groupingcombobox',
			name: 'evalPlanLevelId',
			itemId:'evalPlanLevelItemId',
			labelAlign:'top',
			queryMode: 'local',
			groupField: 'code',
			groupDisplayField: 'code',
			store: Ext.create('Academia.store.examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanIdStore'),
			fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
			displayField: 'value',
			valueField: 'id' ,
			minChar : 3,
			disabled:true,
			listeners:{
				select:function(obj,rec){
					var data=rec[0].data.code;
					//obj.nextSibling().setValue(data);
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'detailSequence',
			itemId:'detailSequenceItemId',
			store:Ext.create('Academia.store.examinationcenters.manageEvaluation.EvaluationEventByEvalPlan'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			disabled:true,
			fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),

		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: []
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			itemId:'searchBtn',
			text: getCommonTranslation('SEARCH'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
