/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.examexecution.StudentMarkRemarkEntryFacultyGrid', {
    extend: 'Ext.tree.Panel',
    alias: 'widget.studentmarkremarkentryfacultygrid',
    title: getMegaMenuTranslation('EXAM_STUDENT_MARK_REMARK_ENTRY'),
    border: true,
   rootVisible: false,
    singleExpand: false,
    reserveScrollbar: true,
    height: window.innerHeight-350,
    useArrows: false,
    //disableSelection: true,
	cls: 'studentassessmentreportgrid no-tree-icon treeGrid',
    frame:false,
	rowLines: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
    tbar : [{
        xtype: 'button',
        itemId: 'studentMarkRemarkSaveBtn',
  	    tooltip: getCommonTranslation('SAVE'),
  	    text : getCommonTranslation('SAVE') 
    },{
        xtype: 'button',
        itemId: 'studentMarkRemarkSubmitBtn',
  	    tooltip: getExaminationTranslation('SUBMIT'),
  	    text : getExaminationTranslation('SUBMIT')
    },{
	    xtype : 'button',
	    itemId : 'deleteMarksGradeBtn',
	    tooltip : getExaminationTranslation('DELETE_MARKS_GRADE'),
	    text : getExaminationTranslation('DELETE_MARKS_GRADE'),
	  disabled: true	    
	},{
	    xtype : 'button',
	    itemId : 'publishMarksGradeBtn',
	    tooltip : getExaminationTranslation('PUBLISH_MARKS_GRADE'),
	    text : getExaminationTranslation('PUBLISH_MARKS_GRADE'),
	   disabled: true	    
	}, {
	    xtype : 'button',
	    itemId : 'unpublishMarksGradeBtnFaculty',
	    tooltip : getExaminationTranslation('UNPUBLISH_MARKS_GRADE'),
	    text : getExaminationTranslation('UNPUBLISH_MARKS_GRADE'),
	    disabled: true        
	},{
	    xtype : 'button',
	    itemId : 'checkHistoryBtnFaculty',
	    tooltip : getExaminationTranslation('CHECK_HISTORY'), 
	    text : getExaminationTranslation('CHECK_HISTORY'),
	    disabled: true
	}],
	store: 'examexecution.StudentMarkRemarkGridStore', 
    columns: [{
		header:  "<input type='checkbox'>",
		width:50,
		hideable : false,
		menuDisabled: true,
		resizable: false,
		sealed: true
	},{
        xtype: 'treecolumn',
        text: getCommonTranslation('COURSE_CODE_NAME'),
        flex: .33,
        dataIndex: 'treeNode',
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.get('isCourseLevelNode') || record.isLeaf()){
				return val;
			}
			else{
				rec.innerCls = "x-grid-cell-inner-treecolumn noChecked";
				return val;
			}
		}
    },{
		header:  getExaminationTranslation('SIMILARITY_INDEX'),
		dataIndex: 'similarityIndex',
		flex:.15,
		editor: {
        	xtype: 'numberfield',
			name: 'similarityIndex',
			itemId:'similarityIndex',
			minValue:0,
			maxValue:100,
			decimalPrecision:4,
			mouseWheelEnabled:false
        },
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.get('isCourseLevelNode')){
				if(!isNullOrEmpty(val)){
					return roundToPrecision(val,2);
				} else {
					rec.tdCls = 'gridInputCustomStyle';
	        		return getExaminationTranslation('CLICK_TO_ENTER');
				}
			} else {
				return '';
			}
		}
	},{
		header:  getExaminationTranslation('MARK_ENTRY_STATUS'),
		dataIndex: 'examStatus',
		flex:.15,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.get('isCourseLevelNode')){
				return '';
			} else if(!record.isLeaf()) {
				return '-';
			} else {
				if(val=="CONDUCTED"){
					return getExaminationTranslation('OPEN_FOR_MARKENTRY');
				}
				else{
					return Ext.util.Format.capitalize(getExaminationTranslation(val));
				}
			}
		}
	},{
		header:  getExaminationTranslation('MAX_MARKS_GRADE'),
		dataIndex: 'maxMarksOrGrade',
		flex:.15,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.get('isCourseLevelNode')){
				return '';
			} else if(!record.isLeaf()) {
				return '-';
			} else {
				return val;
			}
		}
	},{
		header:  getExaminationTranslation('MARKS_GRADE_OBTAINED'),
		dataIndex: 'obtainedMarksGrade',
		flex:.15,
		getEditor: function(record){
			if (record.data.markEntryType == 'MARK') {
				return Ext.create('Ext.grid.CellEditor', {
					field: Ext.create( 'Ext.form.field.Number', {
						name:'totalMarks',
						minValue:0,
						maxValue:100,
						decimalPrecision:4,
						mouseWheelEnabled:false
					})
				});
			}
			else{
				return Ext.create('Ext.grid.CellEditor', {
					field: Ext.create( 'Ext.form.field.ComboBox', {
						name:'finalGrade',
						store:'gradeMaster.GradeGroupMapping',
						valueField:'grade',
						displayField:'grade',
						editable:false
					})
				});
			}
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.get('isCourseLevelNode') || !(record.get('whetherExamAttended'))){
				return '';
			} else if(!record.isLeaf()) {
				return '-';
			} else {
				if(isNullOrEmpty(val)){
					if(record.get('examStatus')!="CONDUCTED"){
						return '';
					}
					else{
						rec.tdCls = 'gridInputCustomStyle'; 
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}else{
					if(record.get('markEntryType') == "MARK"){
						if(val>parseFloat(record.get('maxMarksOrGrade')) || val<0){
							return '';
						}
						return roundToPrecision(val,2);
					}
					else{
						return val;
					}
				}
			}
		}
	},{
		header:  getExaminationTranslation('PENALTY_MARKS'),
		dataIndex: 'penaltyMarks',
		flex:.15,
		editor: {
			xtype: 'numberfield',
			name:'penaltyMarks',
			minValue:0,
			maxValue:100,
			decimalPrecision:4,
			mouseWheelEnabled:false
		},
		renderer:function(val,rec,record){
			var data=rec.record.data;
			if(!record.isLeaf()) {
				return '';
			} else if(data.markEntryType != "MARK" || !(data.whetherExamAttended)){
				return '';
			}
			else{
				//--code here
				if(isNullOrEmpty(val)){
					if(data.examStatus!="CONDUCTED"){
						return '';
					}
					else{
						rec.tdCls = 'gridInputCustomStyle'; 
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}else{
					if(val>parseFloat(data.maxMarksOrGrade) || val<0){
						return '';
					}
					if(val>parseFloat(data.obtainedMarksGrade)){
						data.penaltyMarks = '';
						showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('TOTAL_PENALTY_MARKS_WARNING_MSG'));
						rec.tdCls = 'gridInputCustomStyle'; 
        	    		return getExaminationTranslation('CLICK_TO_ENTER');
					}
					return roundToPrecision(val,2);
				}
			}
		}
	},{
		header:  getExaminationTranslation('GRACE_MARKS'),
		dataIndex: 'graceMarks',
		flex:.15,
		editor: {
			xtype: 'numberfield',
			name:'graceMarks',
			minValue:0,
			maxValue:100,
			decimalPrecision:4,
			mouseWheelEnabled:false
		},
		renderer:function(val,rec,record){
			var data=rec.record.data;
			if(!record.isLeaf()) {
				return '';
			} else if(data.markEntryType != "MARK" || !(data.whetherExamAttended)){
				return '';
			}
			else{
				//--code here
				if(isNullOrEmpty(val)){
					if(data.examStatus!="CONDUCTED"){
						return '';
					}
					else{
						rec.tdCls = 'gridInputCustomStyle'; 
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}else{
					if(val>parseFloat(data.maxMarksOrGrade) || val<0){
						return '';
					}
					if(!isNullOrEmpty(data.obtainedMarksGrade)){
						var oM = data.obtainedMarksGrade;
						var pM = data.penaltyMarks;
						var gM = data.graceMarks;
						if(isNullOrEmpty(data.obtainedMarksGrade)){
							oM = 0;
						}
						if(isNullOrEmpty(data.penaltyMarks)){
							pM = 0;
						}
						if(isNullOrEmpty(data.graceMarks)){
							gM = 0;
						}
						var totalMarksCalc = parseFloat(oM) - parseFloat(pM) + parseFloat(gM);
						if(totalMarksCalc>parseFloat(data.maxMarksOrGrade)){
							data.graceMarks = '';
							showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('NET_MARKS_MAX_AWARD_WARNING_MSG'));
							rec.tdCls = 'gridInputCustomStyle'; 
	        	    		return getExaminationTranslation('CLICK_TO_ENTER');
						}
					}
					else{
						data.graceMarks = '';
						showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('NET_MARKS_MAX_AWARD_WARNING_MSG'));
						rec.tdCls = 'gridInputCustomStyle'; 
        	    		return getExaminationTranslation('CLICK_TO_ENTER');
					}
					return roundToPrecision(val,2);
				}
			}
		}
	},{
		header: getExaminationTranslation('NET_TOTAL_MARKS'),
		dataIndex: 'totalMarkCalc',
		flex:.15,
		hidden: true,
		renderer: function(val,rec,record){
			var data=rec.record.data;
			if(!record.isLeaf()) {
				return '';
			} else if(data.markEntryType != "MARK" || !(data.whetherExamAttended)){
				return '';
			}
			else{
				//--code here
				if(!isNullOrEmpty(data.obtainedMarksGrade)){
					var oM = data.obtainedMarksGrade;
					var pM = data.penaltyMarks;
					var gM = data.graceMarks;
					if(isNullOrEmpty(data.obtainedMarksGrade)){
						oM = 0;
					}
					if(isNullOrEmpty(data.penaltyMarks)){
						pM = 0;
					}
					if(isNullOrEmpty(data.graceMarks)){
						gM = 0;
					}
					var totalMarksCalc = parseFloat(oM) - parseFloat(pM) + parseFloat(gM);
					if(totalMarksCalc>parseFloat(data.maxMarksOrGrade) || val<0){
						return '';
					}
					return roundToPrecision(totalMarksCalc,2);
				}
			}
		}
	},{
		header: getCommonTranslation('ABSENT_STATUS'),
		dataIndex: 'whetherExamAttended',
		flex:.15,
		hidden: true,
		renderer: function(val,rec,record){
			var data=rec.record.data;
			if(!record.isLeaf()) {
				return '';
			}
			else{
				if(val){
	                return getExaminationTranslation('PRESENT');
	            }else {
	                return getExaminationTranslation('ABSENT');
	            }
			}
		}
	},{
		header: getExaminationTranslation('REMARK_ENTRY_STATUS'),
		flex:.15,
		renderer:function(val,rec,record){
			if(record.get('isCourseLevelNode') || record.isLeaf()){
				return '';
			}
			else{
				if(!record.get('whetherRemark')) {
					return 'N/A';
				} else{
					if(record.parentNode.data.isCourseLevelNode){
						//type
						var remark = record.get('typeStatus');
					}
					else if(record.childNodes[0].isLeaf()){
						//method
						var remark = record.get('methodStatus');
					}
					else{
						//subtype
						var remark = record.get('subTypeStatus');
					}
					return (remark=="COMPLETED") ? "Closed" : "Open";
				}
			}
		}
	},{
		header:  getAdmissionTranslation('REMARK'),
		flex:.15,
		renderer:function(val,rec,record){
			if(record.get('isCourseLevelNode') || record.isLeaf()){
				return '';
			}
			else{
				if(!record.get('whetherRemark')) {
					return '-';
				} else{
		    		rec.style = 'white-space: nowrap !important;overflow: hidden;text-overflow: ellipsis;';
					if(record.parentNode.data.isCourseLevelNode){
						//type
						rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(record.get('typeRemark')) + '"';
						return record.get('typeRemark');
					}
					else if(record.childNodes[0].isLeaf()){
						//method
						rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(record.get('methodRemark')) + '"';
						return record.get('methodRemark');
					}
					else{
						//subtype
						rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(record.get('subTypeRemark')) + '"';
						return record.get('subTypeRemark');
					}
				}
			}
		}
	},{
		xtype:'actioncolumn',
		header: getExaminationTranslation('REMARK_ACTIONS'),
		flex:.15,
        items: [{
        	tooltip: getCommonTranslation('ADD'),
    		iconCls: 'addButtonClsForGridActionCls gridColumnBtns',
    		handler: function(tGrid, rowIndex, colIndex) {
    			var grid = Ext.ComponentQuery.query('studentmarkremarkentryfacultygrid')[0];
    			var btn = this.items[0];
    			var store = tGrid.getStore();
    			var storeRecord = store.getAt(rowIndex);
    			var remarkId = storeRecord.get('remarkId');
    			var submitUrl = SERVERURL.EVALUATION_REMARK_CREATE_URl;
    			var data = {
    					"id":storeRecord.data.remarkId,
    					"admissionId" : storeRecord.data.admissionId,
    					"evaluationPlanId" : storeRecord.raw.evaluationPlanId,
    					"evaluationSequenceId": btn.level3Id,
    					"evaluationPlanLevelTwoId" : btn.level2Id,
    					"evaluationPlanLevelOneId" : btn.level1Id,
    					"remark" : null,
						"sectionId" : storeRecord.raw.sectionId,
    					"courseVariantId":storeRecord.raw.courseVariantId,
    					"periodId":storeRecord.raw.periodId,
    					"remarkOnlyAssessment":storeRecord.raw.remarkOnlyAssessment
    			};
    			var newTagLinkWindow = Ext.create('Ext.window.Window', {
    				title: getAdmissionTranslation('REMARK'),
    				height: 250,
    				width: 400,
    				resizable:false,
    				border:true,
    				autoScroll : false,
    				modal : true,
    				closeAction: 'destroy',
    				layout: 'vbox',
    				items: [{
    					xtype: 'textareafield',
    					name: 'remark',
    					fieldLabel: getAdmissionTranslation('REMARK'),        
    					labelAlign: 'top',
    					width: 350,
    					height: 100,
    					maxLength: 2048
    				},{
    					xtype: 'fieldcontainer',
    					width: '100%',
    					style: 'margin-top:10px !important;',
    					items: [{
    						xtype: 'button',
    						text: getCommonTranslation('SAVE'),
    						buttonAlign: 'right',
    						ui: 'CustomBtnSubmit',
    						scale: CONSTANTS.BUTTONSIZE,
    						handler: function(btn){
    							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    							data.remark = btn.up('window').down('[name=remark]').value;
    							Ext.Ajax.request({
    								type : 'rest',
    								url : submitUrl,
    								jsonData : [data],
    								method : 'POST',
    								success : function(resp, action) {
    									Ext.getBody().unmask();
    									btn.up('window').close();
    									grid.getStore().reload();
    									grid.getSelectionModel().deselectAll();
    								}
    							});
    						}
    					}, {
    						xtype: 'button',
    						text: getCommonTranslation('CANCEL'),
    						handler: function(btn){
    							btn.up('window').close();
    						},
    						ui: 'CustomBtnCancel',
    						scale: CONSTANTS.BUTTONSIZE
    					}]
    				}]
    			}).show();
    		},
            isDisabled: function(view, rowIndex, colIndex, item, record){
            	var grid = Ext.ComponentQuery.query('studentmarkremarkentryfacultygrid')[0],
            	studentmarkremarkfacultystructure = grid.up('studentmarkremarkfacultystructure'),
					createRemarkHidden = studentmarkremarkfacultystructure.createRemarkHidden,
					editRemarkHidden = studentmarkremarkfacultystructure.editRemarkHidden,
					deleteRemarkHidden = studentmarkremarkfacultystructure.deleteRemarkHidden,
					buttonDisabled = false,
					buttonHidden = false,
					store = record.store;
            	if(record.get('isCourseLevelNode') || record.isLeaf() || createRemarkHidden == true){
            		buttonHidden = true;
    			}
            	else{
    				if(!record.get('whetherRemark')) {
    					buttonHidden = true;
    					//-- set '-'
    				} else{
    					var level1Id = null;
    					var level2Id = null;
    					var level3Id = null;
    					if(record.parentNode.data.isCourseLevelNode){
    						//type
    						var remark = record.get('typeStatus');
    						var remarkVal = record.get('typeRemark');
    						level1Id = record.raw.evaluationPlanLevelOneId;
    					}
    					else if(record.childNodes[0].isLeaf()){
    						//method
    						var remark = record.get('methodStatus');
    						var remarkVal = record.get('methodRemark');
    						level3Id = record.raw.evaluationSequenceId;
    					}
    					else{
    						//subtype
    						var remark = record.get('subTypeStatus');
    						var remarkVal = record.get('subTypeRemark');
    						level2Id = record.raw.evaluationPlanLevelTwoId;
    					}
    					if (remark=="COMPLETED"){
    						var buttonDisabled = true;
    					}
    					else{
    						var buttonDisabled = false;
    					}

    					if(!isNullOrEmpty(remarkVal)){
    						buttonHidden = true;
    					}
    					else{
        					item.level1Id= level1Id;
        					item.level2Id= level2Id;
        					item.level3Id= level3Id;
    					}
    				}
            	}
            	if(buttonHidden){
            		item.iconCls = 'addButtonClsForGridActionCls gridColumnBtns hiddenItem';
            	}
            	else{
            		item.iconCls = 'addButtonClsForGridActionCls gridColumnBtns';
            	}
            	return buttonDisabled;
            }
        },{
        	tooltip: getCommonTranslation('EDIT'),
    		iconCls: 'editButtonClsForGridActionCls gridColumnBtns',
    		handler: function(tGrid, rowIndex, colIndex) {
    			var grid = Ext.ComponentQuery.query('studentmarkremarkentryfacultygrid')[0];
    			var btn = this.items[1];
    			var store = tGrid.getStore();
    			var storeRecord = store.getAt(rowIndex);
    			var remarkId = storeRecord.get('remarkId');
    			var submitUrl = SERVERURL.EVALUATION_REMARK_CREATE_URl;
    			var data = {
    					"id":storeRecord.data.remarkId,
    					"admissionId" : storeRecord.data.admissionId,
    					"evaluationPlanId" : storeRecord.raw.evaluationPlanId,
    					"evaluationSequenceId": btn.level3Id,
    					"evaluationPlanLevelTwoId" : btn.level2Id,
    					"evaluationPlanLevelOneId" : btn.level1Id,
    					"remark" : null,
    					"sectionId" : storeRecord.raw.sectionId,
    					"courseVariantId":storeRecord.raw.courseVariantId,
    					"periodId":storeRecord.raw.periodId,
    					"remarkOnlyAssessment":storeRecord.raw.remarkOnlyAssessment
    			};
    			var newTagLinkWindow = Ext.create('Ext.window.Window', {
    				title: getAdmissionTranslation('REMARK'),
    				height: 250,
    				width: 400,
    				resizable:false,
    				border:true,
    				autoScroll : false,
    				modal : true,
    				closeAction: 'destroy',
    				layout: 'vbox',
    				items: [{
    					xtype: 'textareafield',
    					name: 'remark',
    					fieldLabel: getAdmissionTranslation('REMARK'),        
    					labelAlign: 'top',
    					width: 350,
    					height: 100,
    					maxLength: 2048,
    					value: btn.remarkVal
    				},{
    					xtype: 'fieldcontainer',
    					width: '100%',
    					style: 'margin-top:10px !important;',
    					items: [{
    						xtype: 'button',
    						text: getCommonTranslation('SAVE'),
    						buttonAlign: 'right',
    						ui: 'CustomBtnSubmit',
    						scale: CONSTANTS.BUTTONSIZE,
    						handler: function(btn){
    							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    							data.remark = btn.up('window').down('[name=remark]').value;
    							Ext.Ajax.request({
    								type : 'rest',
    								url : submitUrl,
    								jsonData : [data],
    								method : 'POST',
    								success : function(resp, action) {
    									Ext.getBody().unmask();
    									btn.up('window').close();
    									grid.getStore().reload();
    									grid.getSelectionModel().deselectAll();
    								}
    							});
    						}
    					}, {
    						xtype: 'button',
    						text: getCommonTranslation('CANCEL'),
    						handler: function(btn){
    							btn.up('window').close();
    						},
    						ui: 'CustomBtnCancel',
    						scale: CONSTANTS.BUTTONSIZE
    					}]
    				}]
    			}).show();
    		},
            isDisabled: function(view, rowIndex, colIndex, item, record){
            	var grid = Ext.ComponentQuery.query('studentmarkremarkentryfacultygrid')[0],
            	studentmarkremarkfacultystructure = grid.up('studentmarkremarkfacultystructure'),
					createRemarkHidden = studentmarkremarkfacultystructure.createRemarkHidden,
					editRemarkHidden = studentmarkremarkfacultystructure.editRemarkHidden,
					deleteRemarkHidden = studentmarkremarkfacultystructure.deleteRemarkHidden,
					buttonDisabled = false,
					buttonHidden = false,
					store = record.store;
            	if(record.get('isCourseLevelNode') || record.isLeaf() || editRemarkHidden == true){
            		buttonHidden = true;
    			}
            	else{
    				if(!record.get('whetherRemark')) {
    					buttonHidden = true;
    					//-- set '-'
    				} else{
    					var level1Id = null;
    					var level2Id = null;
    					var level3Id = null;
    					if(record.parentNode.data.isCourseLevelNode){
    						//type
    						var remark = record.get('typeStatus');
    						var remarkVal = record.get('typeRemark');
    						level1Id = record.raw.evaluationPlanLevelOneId;
    					}
    					else if(record.childNodes[0].isLeaf()){
    						//method
    						var remark = record.get('methodStatus');
    						var remarkVal = record.get('methodRemark');
    						level3Id = record.raw.evaluationSequenceId;
    					}
    					else{
    						//subtype
    						var remark = record.get('subTypeStatus');
    						var remarkVal = record.get('subTypeRemark');
    						level2Id = record.raw.evaluationPlanLevelTwoId;
    					}
    					if (remark=="COMPLETED"){
    						var buttonDisabled = true;
    					}
    					else{
    						var buttonDisabled = false;
    					}

    					if(isNullOrEmpty(remarkVal)){
        					buttonHidden = true;
    					}
    					else{
        					item.level1Id= level1Id;
        					item.level2Id= level2Id;
        					item.level3Id= level3Id;
        					item.remarkVal = remarkVal;
    					}
    				}
            	}
            	if(buttonHidden){
            		item.iconCls = 'editButtonClsForGridActionCls gridColumnBtns hiddenItem';
            	}
            	else{
            		item.iconCls = 'editButtonClsForGridActionCls gridColumnBtns';
            	}
            	return buttonDisabled;
            }
        },{
        	xtype: 'button',
        	tooltip: getCommonTranslation('DELETE'),
    		iconCls: 'deleteButtonClsForGridActionCls gridColumnBtns',
    		handler: function(tGrid, rowIndex, colIndex) {
    			var grid = Ext.ComponentQuery.query('studentmarkremarkentryfacultygrid')[0];
    			var btn = this.items[2];
    			var store = tGrid.getStore();
    			var storeRecord = store.getAt(rowIndex);
    			var remarkId = storeRecord.get('remarkId');
    			var submitUrl = SERVERURL.EVALUATION_REMARK_CREATE_URl;
    			var data = {
    					"id":storeRecord.data.remarkId,
    					"admissionId" : storeRecord.data.admissionId,
    					"evaluationPlanId" : storeRecord.raw.evaluationPlanId,
    					"evaluationSequenceId": btn.level3Id,
    					"evaluationPlanLevelTwoId" : btn.level2Id,
    					"evaluationPlanLevelOneId" : btn.level1Id,
    					"remark" : null,
    					"sectionId" : storeRecord.raw.sectionId,
    					"courseVariantId":storeRecord.raw.courseVariantId,
    					"periodId":storeRecord.raw.periodId,
    					"remarkOnlyAssessment":storeRecord.raw.remarkOnlyAssessment
    			};
    			showConfirmMessage(getExaminationTranslation('REMARK'), getExaminationTranslation('DELETE_REMARK_CORFIRMATION_MSG'),
    					function(btn, text) {
    				if (btn == 'yes') {
    					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    					Ext.Ajax.request({
    						type : 'rest',
    						url : submitUrl,
    						jsonData : [data],
    						method : 'POST',
    						success : function(resp, action) {
    							Ext.getBody().unmask();
    							showSuccessMessage(getExaminationTranslation('REMARK'),
    									getExaminationTranslation('REMARK_DELETED_SUCCESSFULLY'));
    							grid.getStore().reload();
    							grid.getSelectionModel().deselectAll();
    						}
    					});
    				}
    			});
            },
            isDisabled: function(view, rowIndex, colIndex, item, record){
            	var grid = Ext.ComponentQuery.query('studentmarkremarkentryfacultygrid')[0],
            	studentmarkremarkfacultystructure = grid.up('studentmarkremarkfacultystructure'),
					createRemarkHidden = studentmarkremarkfacultystructure.createRemarkHidden,
					editRemarkHidden = studentmarkremarkfacultystructure.editRemarkHidden,
					deleteRemarkHidden = studentmarkremarkfacultystructure.deleteRemarkHidden,
					buttonDisabled = false,
					buttonHidden = false,
					store = record.store;
            	if(record.get('isCourseLevelNode') || record.isLeaf() || deleteRemarkHidden == true){
            		buttonHidden = true;
    			}
            	else{
    				if(!record.get('whetherRemark')) {
    					buttonHidden = true;
    					//-- set '-'
    				} else{
    					var level1Id = null;
    					var level2Id = null;
    					var level3Id = null;
    					if(record.parentNode.data.isCourseLevelNode){
    						//type
    						var remark = record.get('typeStatus');
    						var remarkVal = record.get('typeRemark');
    						level1Id = record.raw.evaluationPlanLevelOneId;
    					}
    					else if(record.childNodes[0].isLeaf()){
    						//method
    						var remark = record.get('methodStatus');
    						var remarkVal = record.get('methodRemark');
    						level3Id = record.raw.evaluationSequenceId;
    					}
    					else{
    						//subtype
    						var remark = record.get('subTypeStatus');
    						var remarkVal = record.get('subTypeRemark');
    						level2Id = record.raw.evaluationPlanLevelTwoId;
    					}
    					if (remark=="COMPLETED"){
    						var buttonDisabled = true;
    					}
    					else{
    						var buttonDisabled = false;
    					}

    					if(isNullOrEmpty(remarkVal)){
    						buttonHidden = true;
    					}
    					else{
        					item.level1Id= level1Id;
        					item.level2Id= level2Id;
        					item.level3Id= level3Id;
    					}
    				}
            	}
            	if(buttonHidden){
            		item.iconCls = 'deleteButtonClsForGridActionCls gridColumnBtns hiddenItem';
            	}
            	else{
            		item.iconCls = 'deleteButtonClsForGridActionCls gridColumnBtns';
            	}
            	return buttonDisabled;
            }
        }]
	}, {
	    header: getExaminationTranslation('OFFERED_US_CREDITS'),
	    dataIndex: 'offeredUsCredits',
	    flex: .1
	}, {
	    header: getExaminationTranslation('OFFERED_ECTS_CREDITS'),
	    dataIndex: 'offeredEctsCredits',
	    flex: .1
	}, /*{
	    header: getExaminationTranslation('ASSESSMENT_EVENTS'),
	    dataIndex: 'assessmentEvent',
	    flex: .1
	}, */{
	    header: getExaminationTranslation('OFFERED_MARKS_OR_GRADES'),
	    dataIndex: 'typeRemark',
	    flex: .1
	}, {
	    header: getExaminationTranslation('COURSE_AVERAGE'),
	    dataIndex: 'courseAverage',
	    flex: .1
	}, {
	    header: getExaminationTranslation('SPECIAL_GRADES'),
	    dataIndex: 'specialGrade',
	    flex: .1
	}, {
	    header: getExaminationTranslation('STATUS'),
	    dataIndex: 'status',
	    flex: .1,
	    renderer: function(val, rec, record) {
	    	if(!isNullOrEmpty(val)) {
	    		return getExaminationTranslation(val);
	    	}
	    	return val;
	    }
	}, {
	    header: getExaminationTranslation('RETAKE_COURSE'),
	    dataIndex: 'retakeCourse',
	    flex: .1,
	    renderer: function(val, rec, record) {
	    	if(!isNullOrEmpty(val) && val) {
	    		return getExaminationTranslation('YES');
	    	}
	    	else  if(!isNullOrEmpty(val) && val == false) {
	    		return getExaminationTranslation('NO');
	    	}
	    	return val;
	    }
	}, {
	    header: getCommonTranslation('RESIT'),
	    dataIndex: 'resit',
	    flex: .1,
	    renderer: function(val, rec, record) {
	    	if(!isNullOrEmpty(val) && val) {
	    		return getExaminationTranslation('YES');
	    	}
	    	else  if(!isNullOrEmpty(val) && val == false) {
	    		return getExaminationTranslation('NO');
	    	}
	    	return val;
	    }
	}, {
	    header: getExaminationTranslation('OBTAINED_US_CREDITS'),
	    dataIndex: 'obtainedUsCredits',
	    flex: .1
	}, {
	    header: getExaminationTranslation('OBTAINED_ECTS_CREDITS'),
	    dataIndex: 'obtainedEctsCredits',
	    flex: .1
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
            beforeedit: function(ed,e){
            	e.grid.getSelectionModel().deselectAll();
            	if(e.field == "similarityIndex" && !e.record.get('isCourseLevelNode')){
            		return false;
            	} else if(e.field == "similarityIndex" && e.record.get('isCourseLevelNode')){
            		return true;
            	}
            	
            	if(e.field == "obtainedMarksGrade" && e.record.isLeaf()){
            		if(e.record.get('examStatus')!="CONDUCTED" || !(e.record.get('whetherExamAttended'))){
            			return false;
            		}if(e.record.get('examResultStatus') == "RESULT_ENTERED"){
            			return false;
            		} 
            		else{
                		return true;
            		}
            	}
            	else if((e.field == "penaltyMarks" || e.field == "graceMarks")  && e.record.isLeaf()){
            		if(e.record.get('examStatus')!="CONDUCTED" || !(e.record.get('whetherExamAttended'))){
            			return false;
            		}
            		else{
                		if(e.record.get('markEntryType')=="MARK"){
                			return true;
                		}
                		else{
                			return false;
                		}
                	}
            	}
            	else{
            		if(e.column.text == getAdmissionTranslation('REMARK') && e.record.isLeaf()) {
            			e.grid.eventLevelRemarkStore = e.column.getEditor().getStore();
            			return true;
            		}
            		return false;
            	}
            }
        }
	}]
});