/**
 * @author Niklesh Tiwane
 */
Ext.define('Academia.view.examexecution.checkHistoryWindowGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.checkhistorywindowgrid',
	border : true,
	store: 'examexecution.StudentMarkRemarkCheckHistoryGridStore',
	//cls: 'x-grid-check-histroy',
	autoScroll: true,
	width: '95%',
    viewConfig: {
        getRowClass: function(record) {
            return record.get('showBold') ? 'bold-row' : '';
        }
    },
    tbar:[],
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
        	displayInfo : true,		 
        	emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			store : 'examexecution.StudentMarkRemarkCheckHistoryGridStore'
        }]
    }],
	columns : [{
        header: getExaminationTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex: 1
	},{
        header: getExaminationTranslation('ADMISSION_ID'),
        dataIndex: 'admissionCode',
        flex: 1
	},{
        header: getCommonTranslation('STUDENT_PRINT_NAME'),
        dataIndex: 'studentName',
        flex: 1
	},{
        header: getExaminationTranslation('PREVIOUS_MARKS/GRADES'),
        dataIndex: 'previousGrades',
        flex: 1,
        renderer: function(val,rec,record,rowIndex,colIndex,store,view) {
        	if(record.get('previousMarks')!=null) {
        		return record.get('previousMarks');
        	}
        	return record.get('previousGrades');
        }
	},{
        header: getExaminationTranslation('PREVIOUS_REMARK'),
        dataIndex: 'previousRemark',
        flex: 1
	},{
        header: getExaminationTranslation('UPDATED_MARKS/GRADES'),
        dataIndex: 'updatedMarks',
        flex: 1,
        renderer: function(val,rec,record,rowIndex,colIndex,store,view) {
        	if(record.get('updatedMarks')!=null) {
        		return record.get('updatedMarks');
        	}
        	return record.get('updatedGrades');
        }
	},{
        header: getExaminationTranslation('UPDATED_REMARK'),
        dataIndex: 'updatedRemark',
        flex: 1
	},{
        header: getExaminationTranslation('MODIFICATION_BY'),
        dataIndex: 'updatedBy',
        flex: 1
	},{
        header: getExaminationTranslation('MODIFICATION_DATE'),
        dataIndex: 'date',
        flex: 1
	},{
        header: getExaminationTranslation('MODIFICATION_TIME'),
        dataIndex: 'time',
        flex: 1
	}]
});