/**
 * @author Ankush.Solanki
 */
Ext.define('Academia.view.examinationOBEAttainment.AttainmentLevelGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.attainmentlevelgrid',
	title: getExaminationTranslation('ATTAINMENT_LEVELS'),
	store:'examinationOBEAttainment.AttainmentLevelGridStore',
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
	},

	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		disabled: true
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getTransportTranslation('SAVE'),
			itemId: 'btnSaveItemId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind :true,
			disabled:true
		}]

	}],
	columns: [{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		dataIndex: 'rownumberer',
		align :'center',
		sortable:false,
		flex: 0.1
	},{
		header: getExaminationTranslation('ATTAINMENT_LEVEL_NAME'),
		dataIndex: 'name',
		flex:.6,
		sortable:false,
		editor: {
			xtype: 'textfield',
			name: 'examAttainmentLevelName',
			width:50,
			minValue:0,
			maxLength: 45,
			allowBlank:false,
			enforceMaxLength : true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals:false,
			itemId: 'examAttainmentLevelNameItemId',
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
			else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},{
		header: getExaminationTranslation('ATTAINMENT_LEVEL_RANGE_FROM'),
		dataIndex: 'percentageRangeFrom',
		flex:.6,
		sortable:false,
		editor: {
			xtype: 'numberfield',
			name: 'examPercentageRangeFromLevel',
			itemId: 'examPercentageRangeFromLevelItemId',
			width:50,
			enforceMaxLength : true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			decimalPrecision : 2,
			decimalPrecision: 2,
			minValue: 0,
			maxValue: 99.99,
			/*listeners:{
				blur:function(obj,val){
					if (!isNullOrEmpty(obj) && !isNullOrEmpty(obj.up().up().down('#examPercenTageRangeToLevelItemId'))) {
						obj.up().up().down('#examPercenTageRangeToLevelItemId').setMinValue(obj.getValue()+0.01);
					}
				}
			}*/
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
			else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	}, {
		header: getExaminationTranslation('ATTAINMENT_LEVEL_RANGE_TO'),
		dataIndex: 'percentageRangeTo',
		flex:.6,
		sortable:false,
		editor: {
			xtype: 'numberfield',
			name: 'examPercenTageRangeToLevel',
			itemId: 'examPercenTageRangeToLevelItemId',
			width:50,
			width:50,
			enforceMaxLength : true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			decimalPrecision : 2,
			decimalPrecision: 2,
			minValue: 0,
			maxValue: 100,
			/*listeners:{
				blur:function(obj,val){
					if (!isNullOrEmpty(obj) && !isNullOrEmpty(obj.up().up().down('#examPercentageRangeFromLevelItemId'))) {
						if(parseFloat((obj.getValue()-0.01).toFixed(2))>=0){
							obj.up().up().down('#examPercentageRangeFromLevelItemId').setMaxValue(parseFloat((obj.getValue()-0.01).toFixed(2)));
						}
					}
				}
			}*/


		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
			else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},{
		header: getExaminationTranslation('ATTAINMENT_LEVEL_VALUE'),
		dataIndex: 'levelValue',
		flex:.6,
		sortable:false,
		editor: {
			xtype: 'numberfield',
			name: 'examlevelValue',
			width:50,
			minValue: 0,
			maxValue: 100,
			enforceMaxLength : true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential: false,
			allowDecimals:false,
			itemId: 'examlevelValueItemId'
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
			else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	}, {
		header: getCommonTranslation('ADD'),
		dataIndex: 'addButton',
		flex: .5,
		cls: 'CustomBodyBtnSettings',
		style:{'text-align':'center'},
		sortable: false,
		renderer: function(value, meta, record) {
			return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
		}
	}, {
		header: getServiceRequestTranslation('EMM_DELETE'),
		dataIndex: 'deleteButton',
		flex: .5,
		cls: 'CustomBodyBtnSettings',
		style:{'text-align':'center'},
		sortable: false,
		renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
			return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
		}
	}],
	plugins: {
		ptype: 'cellediting',
		clicksToEdit: 1
	},
	initComponent: function() {
		var this$ = this;
		this$.callParent(arguments);
	}
});