Ext.define('Academia.view.examinationcenters.ExaminationAddressDetails', {
	extend: 'Ext.window.Window',
	alias : 'widget.examinationaddressdetails',
	title:getExaminationTranslation('ADD_ADDRESS'),
	autoScroll: true,
	modal: true,
	items : [
		    {
		    xtype: 'form',
		    method: 'POST', 
		    autoScroll:true,
		    margin: 0,
		   // bodyPadding: '10 10 10 10',
		    layout: {
		        type: 'vbox'
		    },
		    defaults: {
		        labelAlign: 'top',
		        autoScroll:true,
		        width: 256
		    },
	        standardSubmit: false,
	        plugins:"formlabelrequired",
		    items: [{
    		xtype : 'hidden',
    		name : 'id'
        },{
        	xtype : 'hidden',
    		name : 'version'
        },{
		xtype : 'customcombobox',
		fieldLabel : getCommonTranslation('ADDRESS_TYPE'),
		name : 'addressType',
		itemId : 'addressTypeId',
		store:'organization.AddressTypeStore', 
		valueField : 'id',
		displayField : 'addressTypeName',
		editable : false,
		hidden:true
	}, {
		xtype : 'textareafield',
		fieldLabel : getCommonTranslation('ADDRESS'),
		name : 'addressText',
		allowBlank:false,
		width: 536
	},{
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 256
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('ADDRESS_COUNTRY'),
        		hiddenName : 'country',
        		itemId : 'countryId',
        		store:'common.CountryStore',
        		valueField : 'id',
        		displayField : 'countryName',
        		name : 'country',
        		editable : false,
        		valueNotFoundText:"",        		        						
				forceSelection :true,
				allowBlank:false
        	}, {
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('COUNTRY_REGION'),
//        		name : 'genericField1',
        		itemId : 'parentCountryRegionId',
        		store:'organization.CountryRegionStore',
        		valueField : 'id',
        		displayField : 'countryRegionName',
        		name : 'parentCountryRegion',
        		editable : false,
        		valueNotFoundText:"",        		        						
				forceSelection :true,
				allowBlank:false
        	}/*,{
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('ADDRESS_CITY'),
        		hiddenName : 'city',
        		itemId : 'cityId',
        		store:'organization.CityStore',
        		valueField : 'id',
        		displayField : 'cityName',
        		name : 'city',
        		editable : false,    
        		valueNotFoundText:"",        		
				forceSelection :true,
				allowBlank:false
        	}*/]
	}, {
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 256
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
    		xtype : 'customcombobox',
    		fieldLabel : getCommonTranslation('ADDRESS_CITY'),
    		hiddenName : 'city',
    		itemId : 'cityId',
//    		store:'organization.CityStore',
    		store:'organization.CityByCountryRegion',
    		valueField : 'id',
//    		displayField : 'cityName',
    		displayField : 'value',
    		name : 'city',
    		editable : false,    
    		valueNotFoundText:"",        		
			forceSelection :true,
			allowBlank:false
    	},{
    		xtype : 'textfield',
    		fieldLabel : getCommonTranslation('PINCODE'),
//    		hiddenName : 'pincode',
    		itemId : 'pincodeId',
    		name : 'pincode',
    		minValue : 0,
    		maxLength: 8,
    		maskRe:/^[a-zA-Z0-9\s]+$/,
      	    mouseWheelEnabled :false,
      	    hideTrigger :true,
      	    //allowExponential:false,
      	    allowDecimals:false
//			allowBlank:false
    	}]
	    },/* {
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 256
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('ADDRESS_Generic_Field_1'),
        		hiddenName : 'genericField1',
        		itemId : 'genericFieldId1',
        		store:'organization.CountryRegionStore',
        		valueField : 'id',
        		displayField : 'countryRegionName',
        		triggerAction : 'all',
        		name : 'parentCountryRegion',
        		editable : false,
        		valueNotFoundText:"",        		        						
				forceSelection :true,
				allowBlank:false
        	}, {
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('ADDRESS_Generic_Field_2'),
        		hiddenName : 'genericField2',
        		itemId : 'genericFieldId2',
        		store:'organization.CountryRegionStore1',
        		valueField : 'id',
        		displayField : 'countryRegionName',
        		name : 'countryRegion',
        		triggerAction : 'all',
        		editable : false,
        		valueNotFoundText:"", 
        		disabled:true,
				forceSelection :true        
        	}]
	},*/ {
		xtype: 'fieldcontainer',
	    width: 'auto',
		fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),		
		allowBlank:false,
		layout : {
			type : 'hbox'
		},
		defaults: {
			enforceMaxLength : true,
			labelAlign: 'top',
			width: 256
			//cls:'inputInRow'
		},
		items : [ {
			xtype : 'customcombobox',
			hiddenName : 'phoneNumber1',
			valueField : 'isdCode',
			displayField : 'isdCode',
			store:'common.CountryStore',
			queryMode: 'local',
			triggerAction : 'all',
			name : 'phoneCountryCode',
			itemId : 'phoneCountryCode',
			editable : false,			
			width: 108
		}, {
			xtype : 'numberfield',
			emptyText : getCommonTranslation('ADDRESS_AREA_CODE'),
			name : 'phoneAreaCode',
			width: 108,
			maxLength: 5,
			// To Remove spinner buttons, and arrow key and mouse wheel listeners
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false
		}, {
			xtype : 'numberfield',
			itemId : 'phoneNoField',
			name : 'phoneNo',
			maxLength: 10,
			// To Remove spinner buttons, and arrow key and mouse wheel listeners
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false
		} ]
	}, {
	    	xtype: 'fieldcontainer',
		    width: 'auto',
	    	fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
		defaults: {
			enforceMaxLength : true,
			labelAlign: 'top',
			width: 256
		},
		layout : {
			type : 'hbox'
		},
		items : [ {
			xtype : 'customcombobox',
			name : 'cellCountryCode',
			itemId : 'cellCountryCode',
			valueField : 'isdCode',
			displayField : 'isdCode',
			store:'common.CountryStore',
			queryMode: 'local',
			triggerAction : 'all',
			editable : false,
			width: 108
		}, {
			xtype : 'numberfield',
			name : 'cellNo',
			itemId : 'cellNo',
//			minLength: 6,
//			maxLength: 11,
			// To Remove spinner buttons, and arrow key and mouse wheel listeners
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false
		} ]
	}, {
		xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 256
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [ {
            		xtype : 'textfield',
            		fieldLabel : getCommonTranslation('ADDRESS_PRIMARY_EMAIL'),
            		name : 'primaryeEmailId',
            		vtype: 'email',
            		allowBlank: false
            	}, {
            		xtype : 'textfield',
            		fieldLabel : getCommonTranslation('ADDRESS_SECONDARY_EMAIL'),
            		name : 'alternateEmailId',
            		vtype: 'email',
            		allowBlank: true
            	}]
	}
	, {
		border : false,

		layout : {
			type : 'hbox',
			width : '100%'
		},
		style:{
			marginLeft:'0px'
		},
		items : [ {
			xtype : 'button',
			text : 'Save',
			itemId : 'saveButtonId',
			buttonAlign : 'right',
			ui:'CustomBtnSubmit',
			scale:CONSTANTS.BUTTONSIZE,
			formBind: true
		}, {
			xtype : 'button',
			text : 'Cancel',
			ui: 'CustomBtnCancel',  
			itemId : 'cancelButtonId',
			scale : CONSTANTS.BUTTONSIZE
		}]
	}]
}]

});
