/**
 * @author Deepika P
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.EventDetainedStudentFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.eventdetainedstudentfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'program',
			itemId: 'programItemId',
			fieldLabel : getExaminationTranslation('PROGRAM'),
			store:'facilitiesresources.resourcemaster.ProgramGridStore',
			displayField:'value',
			valueField:'id',
			maxLength:15000,
			autoloadStore: false,
			allowBlank:false,
			height:'10px'
		},{
            xtype: 'customcombobox',
            name: 'BATCH_NAME',
            itemId: 'batchId',
            store:'common.BatchesByProgramId',
            fieldLabel: getExaminationTranslation('BATCH'),
            editable: false,
            allowBlank:false,
            disabled:true,
            queryMode: 'local',
            displayField: 'value',
            valueField: 'id'
		},{
            xtype: 'customcombobox',
            name: 'PERIOD_NAME',
            itemId: 'periodId',
            store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
            fieldLabel: getExaminationTranslation('PERIOD'),
            editable: false,
            disabled:true,
            allowBlank:false,
            queryMode: 'local',
            displayField: 'value',
            valueField: 'id',
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top'
		},
		items: [{
            xtype: 'customcombobox',
            name: 'section',
            itemId: 'sectionId',
            store:'program.programDetails.programBatches.courseParameter.SectionForEvent',
            fieldLabel: getExaminationTranslation('SECTION'),
            editable: false,
            width: 256,
            queryMode: 'local',
            displayField: 'value',
            valueField: 'id',
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
        	xtype: 'customcombobox',
			name:'mappedStudentCourseId',
			itemId:'mappedStudentCourseId',
			store:'examinationcenters.assessmentEvent.MappedStudentCoursesStore',
			allowBlank:false,
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'courseName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
        },{
			xtype: 'customcombobox',
			name:'mappedStudentEvaluationplan',
			itemId:'mappedStudentEvaluationplan',
			store:'examinationcenters.assessmentEvent.MappedStudentsEvaluationPlanForEventStore',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			width: 256,
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}

		},{
			xtype: 'customcombobox',
			name: 'mappedStudentDetailSequence',
			itemId:'mappedStudentDetailSequence',
			store:'examinationcenters.manageEvaluation.MappedStudentEvaluationEventByEvalPlan',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
			allowBlank: false,
		},{
			xtype: 'hidden',
			name: 'selectedEventId',
			itemId:'selectedEventId',
		},,{
			xtype: 'hidden',
			name: 'selectedId',
			itemId:'selectedId',
		},{
			xtype: 'hidden',
			name: 'examStatus',
			itemId:'examStatus',
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'studentId',
			itemId: 'studentItemId',
			store:'examinationcenters.reports.ExaminationReportStudentStore',
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			width: 536,
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
        }]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'quickSearchId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

//}]
});