/**
 * @pankaj sisodiya
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.ManageAssessmentStatusFilter', {
	extend: 'Academia.view.common.DynamicFieldForm',
	alias: 'widget.manageAssessmentStatusFilter',     
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top'      
		},
		items: [{
			xtype: 'multiselectcombofield',
			width: 536,
			name: 'academyLocation',
			itemId: 'academyLocationId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'user.UserAcademyLocationStore',
			displayField:'value',
			valueField:'id',
			autoloadStore: false,
			queryParam:'qry',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]

	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype : 'customcombobox',
			name : 'assessmentSchemeAcademicTerm',
			itemId : 'assessmentSchemeAcademicTermId',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store :Ext.create('Academia.store.common.AcademicTermStore'),
			valueField : 'id',
			displayField : 'value',
			forceSelection:true,
			typeAhead:true,
 			allowBlank:false,
		},{
			xtype: 'customcombobox',
			name:'assesmentScheme',
			itemId:'assesmentSchemeId',
			store:'examinationcenters.assessmentEvent.ManageAssessmentSchemeStore',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			width: 256,
			displayField: 'value',
			minChars:3,
			queryParam:'qry',
			typeAhead:false,
			disabled:true,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}

		},
		{
			xtype: 'customcombobox',
			name: 'program',
			itemId: 'programItemId',
			fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:'examinationcenters.assessmentEvent.ManageAssessmentProgramStore',
			displayField:'value',
			valueField:'id',
			maxLength:15000,
			autoloadStore: false,
			allowBlank:true,
			queryParam:'programName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			width: 256,
			name:'batchName',
			itemId:'batchNameId',
			fieldLabel: getExaminationTranslation('BATCH'),
			queryParam:'batch',
			minChars:3,
			displayField: 'value',
			valueField: 'id',
			forceSelection:true,
			disabled:true,
			store:'examinationcenters.assessmentEvent.ManageAssessmentBatcheStore',

		}
		,{
			xtype: 'customcombobox',
			name: 'periodName',
			itemId: 'periodNameId',
			store:'examinationcenters.assessmentEvent.ManageAssessmentPeriodStore',
			fieldLabel: getExaminationTranslation('PERIOD'),
			//        editable: false, courseManageItemId
			disabled:true,
			queryMode: 'local',
			displayField: 'value',
			forceSelection:true,
			valueField: 'id',
		},{
			xtype: 'multiselectcombofield',
			name: 'courseManageItem',
			itemId:'courseManageItemId',
			labelAlign: 'top',
			fieldLabel:getExaminationTranslation('COURSE_CODE_NAME'),
			store:'examinationcenters.assessmentEvent.ManageAssessmentCoursesStore',
			valueField: 'id',
			displayField: 'value',
			queryParam:'courseName',
			autoloadStore: false,
			disabled:true,
			typeAhead:false,
			forceSelection:true,
		matchFieldWidth: true,
			width: 256,
			cls:'commonAutoHeightMultiselectField resetPasswordMultiselect',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'groupingcombobox',
			name:'assessmentSchemeLevel',
			itemId:'assessmentSchemeLevel',
            labelAlign:'top',
            width: 256,
           // queryMode: 'local',
            groupField: 'code',
            groupDisplayField: 'code',
            store:'examinationcenters.assessmentEvent.ManageAssessmentSchemeLevel',
            fieldLabel: getExaminationTranslation('ASSESSMENT_SCHEME_LEVEL'),
            displayField: 'value',
           // valueField: 'id' ,
            minChar : 3,
            disabled:true,
            forceSelection:true,

		}
		,{
			xtype: 'customcombobox',
			name: 'eventStatus',
			itemId: 'eventStatus',
			 store: {
	                fields: ['id', 'name'],
	                data: [{
	                	id: 'PENDING',
	                	name: 'Pending'
	                }, {
	                    id: 'CONDUCTED',
	                    name: 'Open For Mark Entry'
	                }, {
	                    id: 'CLOSED',
	                    name: 'Result Declared'
	                }]
	            },
			fieldLabel: getExaminationTranslation('EVENT_STATUS'),
			queryMode: 'local',
			displayField: 'name',
			forceSelection:true,
			valueField: 'id',
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'manageAssesmentSearchId',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true,
			margin: '0 44 0 0'
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			itemId: 'manageHierarchyStatus',
			name:'manageHierarchyStatus',
			text: getExaminationTranslation('MANAGE_HIERARCHY_STATUS'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		}],
	}]

//}]
});