/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.RoomAndStaffAllocationFilter', {
    extend: 'Academia.view.common.DynamicFieldForm',
    alias: 'widget.roomAndStaffAllocationFilter',
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'administrativeBy',
            itemId: 'administrativeByRoomAndStaffAllocation',
            fieldLabel: getExaminationTranslation('ADMINISTRATIVE_BY'),
            store: Ext.create('Academia.store.examinationcenters.assessmentEvent.AdministrativeByStore'),
            valueField: 'value',
            displayField: 'value',
            forceSelection: true,
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'assessmentSchemeAcademicTerm',
            itemId: 'academicTermRoomAndStaffAllocation',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            store: Ext.create('Academia.store.common.AcademicTermStore'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            allowBlank: false,
            disabled: true
        }, {
            xtype: 'multiselectcombofield',
            name: 'assesmentScheme',
            itemId: 'assesmentSchemeRoomAndStaffAllocation',
            store: 'examinationcenters.assessmentEvent.EvaluationPlanSmartSearchStore',
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN'),
            valueField: 'id',
            width: 256,
            displayField: 'evaluationPlanNumber',
            //minChars: 3,
            //queryParam: 'qry',
            typeAhead: false,
            disabled: true,
            allowBlank: false,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            //emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            autoloadStore: false,
            cls: 'commonAutoHeightMultiselectField resetPasswordMultiselect',
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
        	xtype: 'multiselectcombofield',
            name: 'courseManageItem',
            itemId: 'courseItemIdRoomAndStaffAllocation',
            labelAlign: 'top',
            fieldLabel: getExaminationTranslation('COURSE_CODE_NAME'),
            store: 'examinationcenters.assessmentEvent.AssessmentCoursesForRoomAllocationStore',
            valueField: 'id',
            displayField: 'valueCode',
            autoloadStore: false,
            disabled: true,
            forceSelection: true,
            matchFieldWidth: true,
            width: 256,
            cls: 'commonAutoHeightMultiselectField resetPasswordMultiselect',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            name: 'fromdate',
            itemId: 'fromDateRoomAndStaffAllocation',
            disabled: true,
            listeners: {
                render: function (field) {
                    return dateFormatRender(field);
                }
            },
            vtype: 'daterange',
            endDateField: 'tillDateRoomAndStaffAllocation',
            editable: false,
            fieldLabel: getExaminationTranslation('FROM_DATE')
        }, {
            xtype: 'datefield',
            name: 'tilldate',
            itemId: 'tillDateRoomAndStaffAllocation',
            disabled: true,
            vtype: 'daterange',
            startDateField: 'fromDateRoomAndStaffAllocation',
            editable: false,
            listeners: {
                render: function (field) {
                    return dateFormatRender(field);
                }
            },
            fieldLabel: getExaminationTranslation('TILL_DATE')
        }, /*{
            xtype: 'groupingcombobox',
            name: 'evaluationLevelName',
            itemId: 'evaluationLevelRoomAndStaffAllocation',
            labelAlign: 'top',
            groupField: 'code',
            groupDisplayField: 'code',
            store: 'examinationcenters.preExamDetails.EvalPlanLevels',
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
            disabled: true,
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }*/{
            xtype: 'multiselectcombofield',
            name: 'detailSequence',
            itemId: 'detailSequenceRoomAndStaffAllocation',
            disabled: true,
            cls: 'receiptHeaderMultiselect resetPasswordMultiselect',
            displayField: 'eventName',
            valueField: 'id',
            forceSelection: true,
            store: 'examinationcenters.assessmentEvent.EvalPlanLevelRoomAllocationStore',
            queryMode: 'local',
            fieldLabel: getExaminationTranslation('DETAILED_SEQUENCE'),
            disabled: true,
            autoloadStore: false,
            allowBlank: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{eventName}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'roomAndStaffSearchId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetBtn',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});