/**
 * kuldeep yadav
 */
Ext.define('Academia.view.examinationcenters.attestationform.AttestationFormGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.attestationformgrid',
	store: 'examinationcenters.evaluationgroup.AttestationFormGridStore',
	title: getExaminationTranslation('ATTESTATION_FORM'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'examinationcenters.evaluationgroup.AttestationFormGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);
	},
	tbar : [{
			xtype: 'button',
			itemId: 'btnRegenerationAttestationId',
			text: getExaminationTranslation('REGENERATE_ATTESTATION_FORM'),
			disabled:true,
	},{
		xtype: 'button',
		itemId: 'btnDownloadAllAttestationForm',
		disabled:true,
		text:getExaminationTranslation('DOWNLOAD_ALL_ATTESTATION_FORM')
	}],
	columns: [{
		header: getExaminationTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.3,
		sortable:true
	},{
		header: getExaminationTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.4,
		sortable:true
	},{
		header: getExaminationTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.4,
		sortable:true
	}, {
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('EVALUATION_GROUP'),
		dataIndex: 'evaluationGroupCode',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('TOTAL_OUTSTANDING'),
		dataIndex: 'totalOutstanding',
		flex:.3,
		hidden:true,
		sortable: true,
		renderer: function(currency) {
			if(!isNullOrEmpty(currency)) {
				return "INR. "+currencyRender(currency);
			} else {
				return "<b>N/A</b>";
			}
		}
	}, {
		header: getExaminationTranslation('APPLICATION_STATUS'),
		dataIndex: 'applicationStatus',
		flex:.3,
		sortable: true,
		renderer: function(value){
			if(value!=null)
				return capitaliseEnumValue(value);
		}
	}, {
		header: getExaminationTranslation('ATTESTATION_FORM'),
		dataIndex: 'hallticket',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			if(value!=null) {
				return '<a href=#>'+value+'</a>';
			}
		}
	}]
});