/**
 * @author kuldeep yadav
 */
Ext.define('Academia.view.examinationcenters.attestationform.StudentRollListFilter', {
	extend: 'Ext.form.FormPanel',
    alias: 'widget.studentrolllistfilter',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    modal: true,
    standardSubmit : false,
    plugins : "formlabelrequired",
	    items: [{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 256,
	            labelAlign: 'top'
	        },
	        items: [{
				xtype : 'customcombobox',
				name : 'academicTerm',
				itemId : 'academicTermId',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
				store :Ext.create('Academia.store.common.AcademicTermStore'),
				valueField : 'id',
				displayField : 'value',
				forceSelection:true,
				minChars:3,
				queryParam:'academicTermName',
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			 },{
		        	xtype: 'customcombobox',
		            name: 'evaluationGroupId',
		            itemId: 'evaluationGroupId',
		            store:'examinationcenters.evalresultlisting.EvaluationGroup',
		            displayField:'code',
		            valueField:'id',
		            fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
					queryParam:'evaluationGroupCode',
					minChars:3,
					width: 256,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					allowBlank:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}

		        }]
	    },{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 256,
	            labelAlign: 'top'
	        },
	        items: [{
	        		xtype: 'customcombobox',
					name:'program',
					itemId:'programItemId',
					store:'examinationcenters.manageEvaluation.evaluationgroup.EGProgramStore',
					fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'name',
					minChars:3,
					width: 256,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					disabled : true,
			          
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
	            },{
		        	xtype: 'customcombobox',
		            name: 'batchId',
		            itemId:'batchIdItemId',
		            store:'examinationcenters.manageEvaluation.evaluationgroup.EGBatchStore',
		            displayField:'value',
		            valueField:'id',
		            forceSelection:true,
		            typeAhead:true,
		            minChars:3,
		            disabled : true,
		            fieldLabel:getExaminationTranslation('BATCH'),
		           
	            },{
		        	xtype: 'customcombobox',
		            name: 'periodId',
		            itemId: 'periodItemId',
		            store:'examinationcenters.manageEvaluation.evaluationgroup.AEGPeriodStore',
		            displayField:'value',
		            valueField:'id',
		            forceSelection:true,
		            typeAhead:true,
		            disabled : true,
		            fieldLabel:getExaminationTranslation('PERIOD'),
	//	            allowBlank:true
		           
		        }]
	    },
	    {
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 256,
	            labelAlign: 'top'
	        },
	        items: [{
	        	xtype: 'customcombobox',
	            name: 'studentType', 
	            itemId:'studentTypeId',
	            store: 'examinationcenters.evaluationgroup.StudentResultStatusEnumStore',
	            displayField: 'value',
	            valueField: 'id',
	            typeAhead: true,
	            fieldLabel:getExaminationTranslation('STUDENT_TYPE'),
	            hidden:false
            },{
					xtype: 'customcombobox',
					name:'admissionId',
					itemId:'admissionItemId',
					store: 'examinationcenters.evaluationgroup.ExamRollListStudentStore',//'examinationcenters.evaluationgroup.studentcovered.StundentNameCombo',
					fieldLabel: getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'name',
					minChars:3,
					width: 536,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					allowBlank:true,
					disabled:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				}]
	    },{
		    xtype: 'fieldcontainer',
	        width:'100%',
			cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
	        items: [ {
	            xtype: 'button',
	            itemId:'searchBtn',
	            text: getCommonTranslation('SEARCH'),
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind:true
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('RESET'),
	            itemId:'resetBtn',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getExaminationTranslation('GENERATE_ROLL_LIST'),
	            itemId:'btnGenerateRollListId',
	            ui: 'CustomBtnThird',
	            cls:'btn-with-no-icon',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind:true
	       }]
	   }]
});