/**
 * kuldeep yadav
 */
Ext.define('Academia.view.examinationcenters.attestationform.StudentRollListGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentrolllistgrid',
	store: 'examinationcenters.evaluationgroup.StudentRollListGridStore',
	title: getExaminationTranslation('STUDENT_ROLL_LIST'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'examinationcenters.evaluationgroup.StudentRollListGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);
	},
	tbar : [{
			xtype: 'button',
			itemId: 'btnRegerateRollListId',
			text: getExaminationTranslation('REGENERATE_ROLL_LIST'),
			disabled:true,
		
	}],
	columns: [{
		header: getExaminationTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.3,
		sortable:true
	},{
		header: getExaminationTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.4,
		sortable:true
	},{
		header: getExaminationTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.4,
		sortable:true
	}, {
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.3,
		sortable: true
	}
	// Hide as suggested by rahul gupta
	/*,{
		header: getExaminationTranslation('COURSE_CODE'),
		dataIndex: 'courseCode',
		flex:.3,
		sortable: true,
	}*/,{
		header: getExaminationTranslation('COURSE_COUNT'),
		dataIndex: 'totalCourse',
		flex:.3,
		sortable: true
	}]
});