/**
 /author  Deepika Parmar
 */
Ext.define('Academia.view.examinationcenters.averagereport.StudentAverageReportFilter', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentaveragereportfilter',  
	plugins : "formlabelrequired",
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    items: [{
    	xtype : 'fieldcontainer',
    	layout : {
    		type : 'hbox'
    	},
    	defaults : {
    		width: 256,
    		labelAlign : 'top'
    	},
    	items : [{
			xtype:'hidden',
			name:'evalLevelIds',
			itemId : 'evalLevelIds',
		},
		{
    		xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'academicTermId',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			//store :Ext.create('Academia.store.common.AcademicTermStore'),
			store :Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField : 'id',
			displayField : 'value',
			forceSelection:true,
			typeAhead:false,
			allowBlank : false,

	},{
		xtype: 'customcombobox',
		name: 'assessmentschemelevel',
		itemId: 'assessmentschemelevelItemId',
		store: Ext.create('Academia.store.examinationcenters.marksheet.CalculateAverageReportEvaluationLevelStore'),
		allowBlank : false,
		fieldLabel : getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
		displayField:'value',
		valueField:'id',
		autoloadStore: false,
		forceSelection:true, //V2D-402844 
		disabled:true

	},{

		xtype: 'customcombobox',
		name: 'assessmentlevelname',
		itemId: 'assessmentlevelnameItemId',
		store:Ext.create('Academia.store.examinationcenters.marksheet.CalculateAverageReportEvaluationLevelType'),
		allowBlank : false,
		fieldLabel : getExaminationTranslation('EVALUATION_LEVEL_NAME'),
		displayField:'value',
		valueField:'value',
		autoloadStore: false,
		forceSelection:true, 
		disabled:true
	
	}]
   },{
		xtype : 'fieldcontainer',
    	layout : {
    		type : 'hbox'
    	},
    	defaults : {
    		width: 256,
    		labelAlign : 'top'
    	},
    	items:[{

    		xtype: 'customcombobox',
    		name: 'programGroup',
    		itemId: 'programGroupItemId',
    		fieldLabel : getCommonTranslation('PROGRAM_GROUP'),
    		valueField: 'id',
			displayField: 'value',
			store:Ext.create('Academia.store.program.ProgramGroupByAccessibleALStore'),
    		maxLength:15000,
    		autoloadStore: false,
    		disabled:true
		
    	  },{


  			xtype: 'multiselectcombofield',
  			name: 'programBatch',
  			width: 536,
  			itemId: 'programBatchItemId',
  			fieldLabel: getExaminationTranslation('PROGRAM_BATCH'),
  			store: Ext.create('Academia.store.examinationcenters.marksheet.CalculateAverageReportProgramBatchStore'),
  			displayField:'value',
			valueField:'id',
			queryParam:'programName',
  			typeAhead : true,
  			allowBlank:true,
  			forceSelection:true,
  			hideTrigger:false,
  			triggerAction: 'all',
  			/*disabled:true,*/
  			minChars:3,
	        cls:'ProgramCourseMultiselectField placementProgramMultiselect',
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
  			disabled:true,
  			autoloadStore: false,
  			listConfig: {
  				listeners: {
  					beforeshow: function(picker) {
  						picker.minWidth = picker.up('combobox').getSize().width;
  					}
  				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{value}'  +
  					'</div>';
  				}
  			}
    	}]
   },{
    	xtype : 'fieldcontainer',
    	layout : {
    		type : 'hbox'
    	},
    	defaults : {
    		width: 256,
    		labelAlign : 'top'
    	},
    	items : [{
			xtype: 'customcombobox',
			name:'admissionId',
			itemId:'admissionStudentId',
			store:Ext.create('Academia.store.examinationcenters.reports.StudentAverageReportStudentListStore'),
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			width: 536,
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentName',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			triggerAction: '',
			hideTrigger:false,
			maxLength: 100,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            disabled:true,
			listConfig: {
			  listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                    '{code} / {value}'  +
                    '</div>';
                }
            }
		},{

			xtype: 'customcombobox',
			name:'status',
			itemId:'statusItemId',
			store:Ext.create('Academia.store.common.picklist.StudentActiveInactiveStatusStore'),
			fieldLabel:getExaminationTranslation('STATUS'),			
			valueField: 'value',
            displayField: 'name',
			autoloadStore: false,
			forceSelection: true
		
		}]},{
            xtype: 'fieldcontainer',
            width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'searchBtn',
                //buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                formBind:true,
                scale: CONSTANTS.BUTTONSIZE,
                margin: '0 44 0 0'
            },{
                xtype: 'button',
                text: getCourseTxCommonTranslation('RESET'),
                itemId: 'resetBtn',
                //buttonAlign: 'left',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
});