/**
 * Deepika Parmar
 */
var StudentAverageReportStore = Ext.create('Academia.store.examinationcenters.averagereport.StudentAverageReportStore');
Ext.define('Academia.view.examinationcenters.averagereport.StudentAverageReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentaveragereportgrid',
	store: StudentAverageReportStore,
	border: true,
	title:getExaminationTranslation('LIST_OF_STUDENTS'),
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
			    store : StudentAverageReportStore,
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
		}]
	}],
   
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
 },
 tbar: [{
		 xtype: 'button',
		 text:getCommonTranslation('EXPORTREPORTS'),
		 itemId:'exportReoprtItemId',
		 disabled:true,
		 tooltip: getCommonTranslation('EXPORTREPORTS'),		 
 	}],
 	
	columns: [{
		header: getCommonTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		hidden:true,
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.3,
		sortable: true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex:.3,
		sortable: true,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex:.3,
		sortable: true,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex:.3,
		sortable: true,
		hidden :true
	},{
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.4,
		sortable:true,
		hidden:true
	},{
		header: getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('AVERAGE_MARKS'),
		dataIndex: 'marks',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,e){
    		if(!isNullOrEmpty(val)){
    			if(val=='0' || val == '0.00' || val == '0.0'){
    				return val;
    			}else{
    				return val.toFixed(2);
    			}
    		} else {
    			return "-";
    		}
    	}
	},{
		header: getCommonTranslation('AVERAGE_GRADE'),
		dataIndex: 'grade',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('STUDENT_PROMOTION_STATUS'),
		dataIndex: 'status',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,e){
    		if(!isNullOrEmpty(val)){
    			if(val=='DASH'){
    				return "-";
    			}else{
    				return getExaminationTranslation(val);
    			}
    		} else {
    			return "-";
    		}
    	}
	},{
		header: getCommonTranslation('ADMISSION_STATUS'),
		dataIndex: 'admissionStatus',
		flex:.4,
		sortable:true,
		renderer:function(val,rec,e){
    		if(!isNullOrEmpty(val)){
    			if(val==true){
    				return "Active";
    			}else{
    				return "Inactive";
    			}
    		} else {
    			return "-";
    		}
    	}
	},{
		header: getCommonTranslation('STUDENT_STATUS'),
		dataIndex: 'studentStatus',
		flex:.4,
		sortable:true,
		renderer:function(val,rec,e){
    		if(!isNullOrEmpty(val)){
    			if(val==true){
    				return "Active";
    			}else{
    				return "Inactive";
    			}
    		} else {
    			return "-";
    		}
    	}
	}]
	/*plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(editor , context){
			}
		  } 
		}]*/
});
