/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.calculateAverage.CalculateAverageLevelWiseFilter', {
    extend: 'Academia.view.common.DynamicFieldForm',
    alias: 'widget.calculateAverageLevelWiseFilter',
    plugins: "formlabelrequired",
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    defaults: {
        layout: 'hbox',
        width: '100%'
    },
    items: [{
        xtype: 'fieldcontainer',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programItemIdLvlWise',
            store: 'examinationcenters.calculateAverage.calculateAverageLevelWise.ProgramStore',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'name',
            minChars: 3,
            allowBlank: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{valueCode}' +
                        '</div>';
                },
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'batchId',
            itemId: 'batchItemIdLvlWise',
            store: 'examinationcenters.calculateAverage.calculateAverageLevelWise.BatchStore',
            fieldLabel: getExaminationTranslation('BATCH'),
            valueField: 'id',
            displayField: 'value',
            disabled: true,
            allowBlank: false,
            editable: false,
            forceSelection: true,
            listConfig: {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                },
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'evaluationLevel',
            itemId: 'evaluationLevelItemIdLvlWise',
            store: Ext.create('Academia.store.examinationcenters.marksheet.EventEvaluationLevelType'),
            displayField: 'value',
            valueField: 'id',
            forceSelection: true,
            width: 256,
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            allowBlank: false,
            editable: false,
            disabled: true,
            queryMode: 'local',
            listConfig: {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                },
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'admissionCodeSTDName',
            itemId: 'admissionCodeSTDNameLvlWise',
            store: 'examinationcenters.calculateAverage.calculateAverageLevelWise.StudentStore',
            valueField: 'id',
            displayField: 'studentDisplayVal',
            width: 536,
            forceSelection: true,
            enableKeyEvents: 'true',
            typeAhead: false,
            fieldLabel: getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
            minChars: 3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            hideTrigger: false,
            queryParam: 'name',
            disabled: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{studentDisplayVal}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtn',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});