/**
 *  @author Rajkumar.patidar
 */

Ext.define('Academia.view.examinationcenters.calculateResults.ResultCalculationGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.resultcalculationgrid',
	store : 'quartz.RecalculateQuartzJobList',
	title: getExaminationTranslation('JOB_HISTORY'),
	border: true,
	autoScroll: false,
	cls: 'limitedColumnGrid',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'quartz.RecalculateQuartzJobList',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],  
	tbar: [{
			xtype: 'button',
			itemId: 'btnRefresh',
			iconCls: 'refresh-icon',
			cls: 'refresh-btn-result-screen refresh-btn',
			tooltip: getExaminationTranslation('REFRESH'),
//			ui: 'CustomBtnSubmit',
//	        scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('REFRESH'),
	}],
	columns: [{
		header : getCommonTranslation('JOB_NAME'),
		dataIndex : 'jobName',
		flex:1
	},{
		header : getCommonTranslation('START_DATE'),
		dataIndex : 'startDateTime',
		flex:1,
		renderer: function(dateTime) {
			return dateRender(dateTime)+" "+timeRender(dateTime);
		}
	},{
		header : getCommonTranslation('END_DATE'),
		dataIndex : 'endDateTime',
		flex:1,
		renderer: function(dateTime) {
			return dateRender(dateTime)+" "+timeRender(dateTime);
		}
	},{
		header : getCommonTranslation('USER'),
		dataIndex : 'triggeredBy',
		flex:1
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'status',
		flex:1
	},{
		header : getCommonTranslation('REPORT'),
		dataIndex : 'report',
		flex:1, 
		renderer: function(value) {  
			if(!isNullOrEmpty(value))
			return '<a href=#>' + "Report" + '<a>';
		}
	}]
});