/**
 * @author sumit meena
 * @author Bhnau PS
 */
Ext.define('Academia.view.examinationcenters.evalresultlisting.EvalRLQuickFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.evalrlquickfilter',
    autoScroll: false,
    frame: false,
    modal: true,
    plugins:"formlabelrequired",
    collapsible:false,
    standardSubmit: false,
    //title: getCommonTranslation('SEARCH'),
    cls: 'customSearchPanel',
    items: [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
	        	xtype: 'customcombobox',
	            name: 'rank',
	            itemId:'rankItemId',
	            store:'examinationcenters.evalresultlisting.RankType',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            typeAhead:true,
	            minChars:3,
	            fieldLabel:getExaminationTranslation('RANK_TYPE'),
	            allowBlank: false
	        },{
            	xtype: 'customcombobox',
                name: 'evaluationPlanType',
                itemId:'evaluationPlanTypeItemId',
                store:'examCenter.AssignSequence.EvaluationType',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
	            typeAhead:true,
	            minChars:3,
	            hidden:true,
	            fieldLabel:getExaminationTranslation('EVALUATION_PLAN_TYPE'),
	            allowBlank: false
            },{
	        	xtype: 'customcombobox',
	            name: 'evalStage',
	            itemId:'evalStageItemId',
	            store:'examinationcenters.CenterUseFor',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            typeAhead:true,
	            minChars:3,
	            hidden:true,
	            fieldLabel:getExaminationTranslation('EVALUATION_STAGE'),
	            allowBlank: false
            }]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
	        	xtype: 'customcombobox',
	 			name:'programId',
	 			itemId:'programIdItemId',
	 			store:'examinationcenters.reports.ReportProgramStore',
				store:Ext.create('Academia.store.examinationcenters.reports.ExamRankReportProgramStore'),
	 			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
	 			displayField:'valueCode',
			    valueField:'id',
	 			queryParam:'name',
	 			minChars:3,
	 			//width: 536,
	 			//typeAhead:true,
	 			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	 			enableKeyEvents  : 'true',
	 			hideTrigger:false,
	 			forceSelection:true,
	 			allowBlank:false,
	 			//hidden:true,
	 			disabled:true,
	 			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	 			listConfig: {
	 				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	 				loadingText: getCommonTranslation('SEARCHING'),
	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	 				getInnerTpl: function() {
	 					return '<div class="search-item">' +
	 					'{value}' +
	 					'</div>';
	 				}
	 			}  
				/* xtype: 'customcombobox',
			     name: 'programId',
			     itemId:'programIdItemId',
			     fieldLabel: getExaminationTranslation('PROGRAM'),
			     store:'common.ProgramStore',
			     displayField:'value',
			     valueField:'id',
			     forceSelection:true,
			     typeAhead:true,
			     allowBlank: false*/
	       },{
				 xtype: 'customcombobox',
			     name: 'batchId',
			     store:Ext.create('Academia.store.examinationcenters.reports.ExamRankReportBatchStore'),
			     displayField:'value',
			     valueField:'id',
			     itemId:'batchIdItemId',
			     forceSelection:true,
			     typeAhead:true,
			     disabled:true,
			     fieldLabel: getExaminationTranslation('BATCH'),
			     allowBlank: false
			},{
				 xtype: 'customcombobox',
			     name: 'periodId',
			     fieldLabel: getExaminationTranslation('PERIOD'),
			     store:Ext.create('Academia.store.examinationcenters.reports.ExamRankReportPeriodStore'),
			     displayField:'value',
			     valueField:'id',
			     forceSelection:true,
			     typeAhead:true,
			     disabled:true,
			     itemId:'periodIdItemId',
			     allowBlank: false
            }]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
			xtype: 'customcombobox',
			name: 'studentId',
			itemId: 'studentItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.ExaminationResultStudentStore'),
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width: 536,
			typeAhead:false,
			disabled:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						var structure = picker.up('combobox').up().up().up();
						structure.body.on('scroll',function(e,target) {
							picker.hide();
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
    		xtype: 'customcombobox',
    		width: 256,
			name:'studentStatus',
			itemId:'studentStatus',
			fieldLabel: getCommonTranslation('STATUS'),
			minChars:3,
			typeAhead:false,
			value:true,
			 valueField: 'value',
             displayField: 'name',
			forceSelection:true,
			store:'common.picklist.StudentActiveInactiveStatusStore',
			disabled:false,
    	}]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [/*{
	        	 xtype: 'customcombobox',
			     name: 'sectionId',
			     fieldLabel: getExaminationTranslation('SECTION'),
			     store:'examinationcenters.reports.ExaminationReportSectionStore',
			     displayField:'value',
			     valueField:'id',
			    // forceSelection:true,
			     typeAhead:true,
			     disabled:true,
//			     allowBlank: false
            },
            */{
	        	 xtype: 'customcombobox',
			     name: 'evalGroupId',
			     fieldLabel: getExaminationTranslation('EVALUATION_GROUP'),
			     store:'examinationcenters.evalresultlisting.EvaluationGroup',
			     displayField:'code',
			     valueField:'id',
			    // forceSelection:true,
			     typeAhead:true,
			     disabled:true,
			     hidden:true,
		         allowBlank: false
           },
            {
				/*xtype: 'customcombobox',
				name: 'courseId',
				//itemId: 'courseItemId',
				width: 536,
				fieldLabel: getCommonTranslation('COURSE'),
				store : 'program.programDetails.programBatches.courseParameter.ProgramCourseCode',
	        	displayField : 'code',
	        	valueField : 'id',
				//allowBlank: false,
				disabled : true,
				hidden:true*/
				
				xtype: 'customcombobox',
    			name:'courseId',
    			itemId:'courseItemId',
    			store:'examinationcenters.reports.ExaminationSubjectLevelReportCourseStore',
    			fieldLabel: getCommonTranslation('COURSE'),
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'name',
    			width: 536,
    			minChars:3,
    			typeAhead:false,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
    			//allowBlank: false,
				disabled : true,
				hidden:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}' +
    					'</div>';
    				}
    			}
			}]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
        	xtype: 'customcombobox',
            name: 'courseVariant',
            itemId:'courseVariantItemId',
            store:Ext.create('Academia.store.facilitiesresources.resourcebooking.CourseVariantsListStore'),
            displayField:'code',
            queryParam:'courseName',
            valueField:'id',
            width: 536,
            typeAhead:false,
            hidden:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
            fieldLabel:getExaminationTranslation('COURSE_VARIANT')
        
        }]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
	        	xtype: 'hidden',
	            name: '',
	           // store: 'examinationcenters.evaluationgroup.EvaluationStatus',
	            displayField: 'value',
	            valueField: 'value',
	            typeAhead: true,
	            fieldLabel:getExaminationTranslation('STUDENT_NAME')
            },{
            	xtype: 'hidden',
	            name: '',
	            //store: 'program.programDetails.programBatches.assignExamCenter.ProgramCenterTypeStore',
	            displayField: 'value',
	            valueField: 'value',
	            typeAhead: true,
	            fieldLabel:getExaminationTranslation('ADMISSION_NO')
            },{
            	xtype: 'hidden',
	            name: 'admissionId',
            }]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
	        	xtype: 'customcombobox',
	            name: 'evaluationplan',
	            store:'examinationcenters.evaluation.EvaluationPlanNo',
	            displayField:'value',
	            valueField:'id',
	            typeAhead:true,
	            disabled:true,
	            fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
	            hidden:true,
	            disabled:true,
	            allowBlank:true
	          }]
    },{
	    xtype: 'fieldcontainer',
        width:'100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
        items: [ {
            xtype: 'button',
            itemId:'searchBtn',
            text: getCommonTranslation('SEARCH'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        },{
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId:'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            itemId:'exportButtonItemId',
            text: getCommonTranslation('EXPORT_REPORT'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            hidden:true,
            disabled:true,
            margin: '0 5 0 0'
        }]
   }]
});